/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.msg;

import com.zgkxzx.modbus4And.Modbus;
import com.zgkxzx.modbus4And.ProcessImage;
import com.zgkxzx.modbus4And.base.ModbusUtils;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.msg.WriteRegisterResponse;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;

public class WriteRegisterRequest
extends ModbusRequest {
    private int writeOffset;
    private int writeValue;

    public WriteRegisterRequest(int slaveId, int writeOffset, int writeValue) throws ModbusTransportException {
        super(slaveId);
        this.writeOffset = writeOffset;
        this.writeValue = writeValue;
    }

    @Override
    public void validate(Modbus modbus) throws ModbusTransportException {
        ModbusUtils.validateOffset(this.writeOffset);
    }

    WriteRegisterRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    protected void writeRequest(ByteQueue queue) {
        ModbusUtils.pushShort(queue, this.writeOffset);
        ModbusUtils.pushShort(queue, this.writeValue);
    }

    @Override
    ModbusResponse handleImpl(ProcessImage processImage) throws ModbusTransportException {
        processImage.writeHoldingRegister(this.writeOffset, (short)this.writeValue);
        return new WriteRegisterResponse(this.slaveId, this.writeOffset, this.writeValue);
    }

    @Override
    public byte getFunctionCode() {
        return 6;
    }

    @Override
    ModbusResponse getResponseInstance(int slaveId) throws ModbusTransportException {
        return new WriteRegisterResponse(slaveId);
    }

    @Override
    protected void readRequest(ByteQueue queue) {
        this.writeOffset = ModbusUtils.popUnsignedShort(queue);
        this.writeValue = ModbusUtils.popUnsignedShort(queue);
    }
}

