/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.ip.xa;

import com.zgkxzx.modbus4And.base.ModbusUtils;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.ip.xa.XaMessage;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.sero.messaging.IncomingRequestMessage;
import com.zgkxzx.modbus4And.sero.messaging.OutgoingRequestMessage;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;

public class XaMessageRequest
extends XaMessage
implements OutgoingRequestMessage,
IncomingRequestMessage {
    static XaMessageRequest createXaMessageRequest(ByteQueue queue) throws ModbusTransportException {
        int transactionId = ModbusUtils.popShort(queue);
        int protocolId = ModbusUtils.popShort(queue);
        if (protocolId != 0) {
            throw new ModbusTransportException("Unsupported IP protocol id: " + protocolId);
        }
        ModbusUtils.popShort(queue);
        ModbusRequest request = ModbusRequest.createModbusRequest(queue);
        return new XaMessageRequest(request, transactionId);
    }

    public XaMessageRequest(ModbusRequest modbusRequest, int transactionId) {
        super(modbusRequest, transactionId);
    }

    @Override
    public boolean expectsResponse() {
        return this.modbusMessage.getSlaveId() != 0;
    }

    public ModbusRequest getModbusRequest() {
        return (ModbusRequest)this.modbusMessage;
    }
}

