/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.ip.udp;

import com.zgkxzx.modbus4And.ModbusMaster;
import com.zgkxzx.modbus4And.base.BaseMessageParser;
import com.zgkxzx.modbus4And.exception.ModbusInitException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.ip.IpMessage;
import com.zgkxzx.modbus4And.ip.IpMessageResponse;
import com.zgkxzx.modbus4And.ip.IpParameters;
import com.zgkxzx.modbus4And.ip.encap.EncapMessageParser;
import com.zgkxzx.modbus4And.ip.encap.EncapMessageRequest;
import com.zgkxzx.modbus4And.ip.xa.XaMessageParser;
import com.zgkxzx.modbus4And.ip.xa.XaMessageRequest;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.sero.messaging.OutgoingRequestMessage;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class UdpMaster
extends ModbusMaster {
    private static final int MESSAGE_LENGTH = 1024;
    private short nextTransactionId = 0;
    private final IpParameters ipParameters;
    private BaseMessageParser messageParser;
    private DatagramSocket socket;

    public UdpMaster(IpParameters params) {
        this.ipParameters = params;
    }

    protected short getNextTransactionId() {
        short s = this.nextTransactionId;
        this.nextTransactionId = (short)(s + 1);
        return s;
    }

    @Override
    public void init() throws ModbusInitException {
        this.messageParser = this.ipParameters.isEncapsulated() ? new EncapMessageParser(true) : new XaMessageParser(true);
        try {
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(this.getTimeout());
        }
        catch (SocketException e) {
            throw new ModbusInitException(e);
        }
        this.initialized = true;
    }

    @Override
    public void destroy() {
        this.socket.close();
    }

    @Override
    public ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        IpMessage ipRequest = this.ipParameters.isEncapsulated() ? new EncapMessageRequest(request) : new XaMessageRequest(request, (int)this.getNextTransactionId());
        try {
            IpMessageResponse ipResponse;
            int attempts = this.getRetries() + 1;
            while (true) {
                this.sendImpl((OutgoingRequestMessage)((Object)ipRequest));
                if (!ipRequest.expectsResponse()) {
                    return null;
                }
                try {
                    ipResponse = this.receiveImpl();
                }
                catch (SocketTimeoutException e) {
                    if (--attempts > 0) continue;
                    throw new ModbusTransportException(e, request.getSlaveId());
                }
                break;
            }
            return ipResponse.getModbusResponse();
        }
        catch (IOException e) {
            throw new ModbusTransportException(e, request.getSlaveId());
        }
    }

    private void sendImpl(OutgoingRequestMessage request) throws IOException {
        byte[] data = request.getMessageData();
        DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName(this.ipParameters.getHost()), this.ipParameters.getPort());
        this.socket.send(packet);
    }

    private IpMessageResponse receiveImpl() throws IOException, ModbusTransportException {
        IpMessageResponse response;
        DatagramPacket packet = new DatagramPacket(new byte[1024], 1024);
        this.socket.receive(packet);
        ByteQueue queue = new ByteQueue(packet.getData(), 0, packet.getLength());
        try {
            response = (IpMessageResponse)this.messageParser.parseMessage(queue);
        }
        catch (Exception e) {
            throw new ModbusTransportException(e);
        }
        if (response == null) {
            throw new ModbusTransportException("Invalid response received");
        }
        return response;
    }
}

