/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.ip.listener;

import com.zgkxzx.modbus4And.ModbusMaster;
import com.zgkxzx.modbus4And.base.BaseMessageParser;
import com.zgkxzx.modbus4And.exception.ModbusInitException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.ip.IpMessage;
import com.zgkxzx.modbus4And.ip.IpMessageResponse;
import com.zgkxzx.modbus4And.ip.IpParameters;
import com.zgkxzx.modbus4And.ip.encap.EncapMessageParser;
import com.zgkxzx.modbus4And.ip.encap.EncapMessageRequest;
import com.zgkxzx.modbus4And.ip.encap.EncapWaitingRoomKeyFactory;
import com.zgkxzx.modbus4And.ip.xa.XaMessageParser;
import com.zgkxzx.modbus4And.ip.xa.XaMessageRequest;
import com.zgkxzx.modbus4And.ip.xa.XaWaitingRoomKeyFactory;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.sero.messaging.EpollStreamTransport;
import com.zgkxzx.modbus4And.sero.messaging.MessageControl;
import com.zgkxzx.modbus4And.sero.messaging.OutgoingRequestMessage;
import com.zgkxzx.modbus4And.sero.messaging.StreamTransport;
import com.zgkxzx.modbus4And.sero.messaging.Transport;
import com.zgkxzx.modbus4And.sero.messaging.WaitingRoomKeyFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpListener
extends ModbusMaster {
    private final Log LOG = LogFactory.getLog(TcpListener.class);
    private short nextTransactionId = 0;
    private short retries = 0;
    private final IpParameters ipParameters;
    private ServerSocket serverSocket;
    private Socket socket;
    private ExecutorService executorService;
    private ListenerConnectionHandler handler;

    public TcpListener(IpParameters params) {
        this.LOG.debug((Object)("Creating TcpListener in port " + params.getPort()));
        this.ipParameters = params;
        this.connected = false;
        this.LOG.debug((Object)("TcpListener created! Port: " + this.ipParameters.getPort()));
    }

    protected short getNextTransactionId() {
        short s = this.nextTransactionId;
        this.nextTransactionId = (short)(s + 1);
        return s;
    }

    @Override
    public synchronized void init() throws ModbusInitException {
        this.LOG.debug((Object)("Init TcpListener Port: " + this.ipParameters.getPort()));
        this.executorService = Executors.newCachedThreadPool();
        this.startListener();
        this.initialized = true;
        this.LOG.warn((Object)("Initialized Port: " + this.ipParameters.getPort()));
    }

    private void startListener() throws ModbusInitException {
        try {
            if (this.handler != null) {
                this.LOG.debug((Object)"handler not null!!!");
            }
            this.handler = new ListenerConnectionHandler(this.socket);
            this.LOG.debug((Object)"Init handler thread");
            this.executorService.execute(this.handler);
        }
        catch (Exception e) {
            this.LOG.warn((Object)"Error initializing TcpListener ", (Throwable)e);
            throw new ModbusInitException(e);
        }
    }

    @Override
    public synchronized void destroy() {
        this.LOG.debug((Object)("Destroy TCPListener Port: " + this.ipParameters.getPort()));
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            this.LOG.warn((Object)("Error closing socket" + e.getLocalizedMessage()));
            this.getExceptionHandler().receivedException(e);
        }
        if (this.handler != null) {
            this.handler.closeConnection();
        }
        this.terminateListener();
        this.initialized = false;
        this.LOG.debug((Object)("TCPListener destroyed,  Port: " + this.ipParameters.getPort()));
    }

    private void terminateListener() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(300L, TimeUnit.MILLISECONDS);
            this.LOG.debug((Object)("Handler Thread terminated,  Port: " + this.ipParameters.getPort()));
        }
        catch (InterruptedException e) {
            this.LOG.debug((Object)("Error terminating executorService - " + e.getLocalizedMessage()));
            this.getExceptionHandler().receivedException(e);
        }
        this.handler = null;
    }

    @Override
    public synchronized ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        StringBuilder sb;
        IpMessage ipRequest;
        if (!this.connected) {
            this.LOG.debug((Object)("No connection in Port: " + this.ipParameters.getPort()));
            throw new ModbusTransportException(new Exception("TCP Listener has no active connection!"), request.getSlaveId());
        }
        if (!this.initialized) {
            this.LOG.debug((Object)("Listener already terminated " + this.ipParameters.getPort()));
            return null;
        }
        if (this.ipParameters.isEncapsulated()) {
            ipRequest = new EncapMessageRequest(request);
            sb = new StringBuilder();
            for (byte b : Arrays.copyOfRange(ipRequest.getMessageData(), 0, ipRequest.getMessageData().length)) {
                sb.append(String.format("%02X ", b));
            }
            this.LOG.debug((Object)("Encap Request: " + sb.toString()));
        } else {
            ipRequest = new XaMessageRequest(request, (int)this.getNextTransactionId());
            sb = new StringBuilder();
            for (byte b : Arrays.copyOfRange(ipRequest.getMessageData(), 0, ipRequest.getMessageData().length)) {
                sb.append(String.format("%02X ", b));
            }
            this.LOG.debug((Object)("Xa Request: " + sb.toString()));
        }
        try {
            ((ListenerConnectionHandler)this.handler).conn.DEBUG = true;
            IpMessageResponse ipResponse = (IpMessageResponse)this.handler.conn.send((OutgoingRequestMessage)((Object)ipRequest));
            if (ipResponse == null) {
                throw new ModbusTransportException(new Exception("No valid response from slave!"), request.getSlaveId());
            }
            StringBuilder sb2 = new StringBuilder();
            for (byte b : Arrays.copyOfRange(ipResponse.getMessageData(), 0, ipResponse.getMessageData().length)) {
                sb2.append(String.format("%02X ", b));
            }
            this.LOG.debug((Object)("Response: " + sb2.toString()));
            return ipResponse.getModbusResponse();
        }
        catch (Exception e) {
            this.LOG.debug((Object)(e.getLocalizedMessage() + ",  Port: " + this.ipParameters.getPort() + ", retries: " + this.retries));
            if (this.retries < 10 && !e.getLocalizedMessage().contains("Broken")) {
                this.retries = (short)(this.retries + 1);
            } else {
                this.LOG.debug((Object)("Restarting Socket,  Port: " + this.ipParameters.getPort() + ", retries: " + this.retries));
                try {
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException e2) {
                    this.LOG.debug((Object)("Error closing socket" + e2.getLocalizedMessage()), (Throwable)e);
                    this.getExceptionHandler().receivedException(e2);
                }
                if (this.handler != null) {
                    this.handler.closeConnection();
                    this.terminateListener();
                }
                if (!this.initialized) {
                    this.LOG.debug((Object)("Listener already terminated " + this.ipParameters.getPort()));
                    return null;
                }
                this.executorService = Executors.newCachedThreadPool();
                try {
                    this.startListener();
                }
                catch (Exception e2) {
                    this.LOG.warn((Object)("Error trying to restart socket" + e2.getLocalizedMessage()), (Throwable)e);
                    throw new ModbusTransportException(e2, request.getSlaveId());
                }
                this.retries = 0;
            }
            this.LOG.warn((Object)("Error sending request,  Port: " + this.ipParameters.getPort() + ", msg: " + e.getMessage()));
            throw new ModbusTransportException(e, request.getSlaveId());
        }
    }

    static /* synthetic */ boolean access$300(TcpListener x0) {
        return x0.connected;
    }

    static /* synthetic */ ServerSocket access$402(TcpListener x0, ServerSocket x1) {
        x0.serverSocket = x1;
        return x0.serverSocket;
    }

    static /* synthetic */ ServerSocket access$400(TcpListener x0) {
        return x0.serverSocket;
    }

    static /* synthetic */ MessageControl access$500(TcpListener x0) {
        return x0.getMessageControl();
    }

    static /* synthetic */ boolean access$602(TcpListener x0, boolean x1) {
        x0.connected = x1;
        return x0.connected;
    }

    class ListenerConnectionHandler
    implements Runnable {
        private Socket socket;
        private Transport transport;
        private MessageControl conn;
        private BaseMessageParser ipMessageParser;
        private WaitingRoomKeyFactory waitingRoomKeyFactory;

        public ListenerConnectionHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            TcpListener.this.LOG.debug((Object)" ListenerConnectionHandler::run() ");
            if (TcpListener.this.ipParameters.isEncapsulated()) {
                this.ipMessageParser = new EncapMessageParser(true);
                this.waitingRoomKeyFactory = new EncapWaitingRoomKeyFactory();
            } else {
                this.ipMessageParser = new XaMessageParser(true);
                this.waitingRoomKeyFactory = new XaWaitingRoomKeyFactory();
            }
            try {
                this.acceptConnection();
            }
            catch (IOException e) {
                TcpListener.this.LOG.debug((Object)("Error in TCP Listener! - " + e.getLocalizedMessage()), (Throwable)e);
                this.conn.close();
                this.closeConnection();
                TcpListener.this.getExceptionHandler().receivedException(new ModbusInitException(e));
            }
        }

        /*
         * Unable to fully structure code
         */
        private void acceptConnection() throws IOException, BindException {
            while (true) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (TcpListener.access$300(TcpListener.this)) continue;
                try {
                    TcpListener.access$402(TcpListener.this, new ServerSocket(TcpListener.access$200(TcpListener.this).getPort()));
                    TcpListener.access$100(TcpListener.this).debug((Object)("Start Accept on port: " + TcpListener.access$200(TcpListener.this).getPort()));
                    this.socket = TcpListener.access$400(TcpListener.this).accept();
                    TcpListener.access$100(TcpListener.this).info((Object)("Connected: " + this.socket.getInetAddress() + ":" + TcpListener.access$200(TcpListener.this).getPort()));
                    if (TcpListener.this.getePoll() != null) {
                        this.transport = new EpollStreamTransport(this.socket.getInputStream(), this.socket.getOutputStream(), TcpListener.this.getePoll());
                        break;
                    }
                    this.transport = new StreamTransport(this.socket.getInputStream(), this.socket.getOutputStream());
                }
                catch (Exception e) {
                    TcpListener.access$100(TcpListener.this).warn((Object)("Open connection failed on port " + TcpListener.access$200(TcpListener.this).getPort() + ", caused by " + e.getLocalizedMessage()), (Throwable)e);
                    if (e instanceof SocketTimeoutException) continue;
                    if (e.getLocalizedMessage().contains("closed")) {
                        return;
                    }
                    if (e instanceof BindException) ** break;
                    continue;
                    this.closeConnection();
                    throw (BindException)e;
                }
                break;
            }
            this.conn = TcpListener.access$500(TcpListener.this);
            this.conn.setExceptionHandler(TcpListener.this.getExceptionHandler());
            this.conn.DEBUG = true;
            this.conn.start(this.transport, this.ipMessageParser, null, this.waitingRoomKeyFactory);
            if (TcpListener.this.getePoll() == null) {
                ((StreamTransport)this.transport).start("Modbus4J TcpMaster");
            }
            TcpListener.access$602(TcpListener.this, true);
        }

        void closeConnection() {
            if (this.conn != null) {
                TcpListener.this.LOG.debug((Object)("Closing Message Control on port: " + TcpListener.this.ipParameters.getPort()));
                TcpListener.this.closeMessageControl(this.conn);
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                TcpListener.this.LOG.debug((Object)("Error closing socket on port " + TcpListener.this.ipParameters.getPort() + ". " + e.getLocalizedMessage()));
                TcpListener.this.getExceptionHandler().receivedException(new ModbusInitException(e));
            }
            TcpListener.this.connected = false;
            this.conn = null;
            this.socket = null;
        }
    }
}

