/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.website;

import com.yanzhenjie.andserver.exception.NotFoundException;
import com.yanzhenjie.andserver.util.HttpRequestParser;
import com.yanzhenjie.andserver.view.View;
import com.yanzhenjie.andserver.website.WebSite;
import java.io.File;
import java.io.IOException;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.HttpResponse;
import org.apache.httpcore.protocol.HttpContext;

public abstract class SimpleWebsite
implements WebSite {
    protected static final String INDEX_FILE_PATH = "/index.html";

    protected String addStartSlash(String target) {
        if (!target.startsWith(File.separator)) {
            target = File.separator + target;
        }
        return target;
    }

    protected String addEndSlash(String target) {
        if (!target.endsWith(File.separator)) {
            target = target + File.separator;
        }
        return target;
    }

    protected String trimStartSlash(String target) {
        while (target.startsWith(File.separator)) {
            target = target.substring(1);
        }
        return target;
    }

    protected String trimEndSlash(String target) {
        while (target.endsWith(File.separator)) {
            target = target.substring(0, target.length() - 1);
        }
        return target;
    }

    protected String trimSlash(String target) {
        target = this.trimStartSlash(target);
        target = this.trimEndSlash(target);
        return target;
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        View view = this.handle(request, response);
        response.setStatusCode(view.getHttpCode());
        response.setEntity(view.getHttpEntity());
        response.setHeaders(view.getHeaders());
    }

    protected View handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        return this.handle(request);
    }

    protected View handle(HttpRequest request) throws HttpException, IOException {
        throw new NotFoundException(HttpRequestParser.getRequestPath(request));
    }
}

