/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.website;

import com.yanzhenjie.andserver.exception.NotFoundException;
import com.yanzhenjie.andserver.protocol.ETag;
import com.yanzhenjie.andserver.protocol.LastModified;
import com.yanzhenjie.andserver.util.FileUtils;
import com.yanzhenjie.andserver.util.HttpRequestParser;
import com.yanzhenjie.andserver.view.View;
import com.yanzhenjie.andserver.website.SimpleWebsite;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.entity.ContentType;
import org.apache.httpcore.entity.FileEntity;
import org.apache.httpcore.protocol.HttpContext;

public class FileBrowser
extends SimpleWebsite
implements LastModified,
ETag {
    private final String mRootPath;
    private static final String FOLDER_HTML_PREFIX = "<!DOCTYPE html><html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/><meta name=\"viewport\" content=\"width=device-width, initial-scale=1, user-scalable=no\"><meta name=\"format-detection\" content=\"telephone=no\"/><title>%1$s</title><style>.center_horizontal{margin:0 auto;text-align:center;}*,*::after,*::before {box-sizing: border-box;margin: 0;padding: 0;}a:-webkit-any-link {color: -webkit-link;cursor: auto;text-decoration: underline;}ul {list-style: none;display: block;list-style-type: none;-webkit-margin-before: 1em;-webkit-margin-after: 1em;-webkit-margin-start: 0px;-webkit-margin-end: 0px;-webkit-padding-start: 40px;}li {display: list-item;text-align: -webkit-match-parent;margin-bottom: 5px;}</style></head><body><h1 class=\"center_horizontal\">%2$s</h1><ul>";
    private static final String FOLDER_ITEM = "<li><a href=\"%1$s\">%2$s</a></li>";
    private static final String FOLDER_HTML_SUFFIX = "</ul></body></html>";

    public FileBrowser(String rootPath) {
        this.mRootPath = rootPath;
    }

    @Override
    public boolean intercept(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String httpPath = HttpRequestParser.getRequestPath(request);
        httpPath = "/".equals(httpPath) ? "/" : this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        return source != null;
    }

    private File findPathSource(String httpPath) {
        if ("/".equals(httpPath)) {
            return new File(this.mRootPath);
        }
        File sourceFile = new File(this.mRootPath, httpPath);
        if (sourceFile.exists()) {
            return sourceFile;
        }
        return null;
    }

    @Override
    public View handle(HttpRequest request) throws HttpException, IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        if (source == null) {
            throw new NotFoundException(httpPath);
        }
        return this.generatePageView(source);
    }

    private View generatePageView(File source) throws IOException {
        if (source.isDirectory()) {
            File[] files = source.listFiles();
            File tempFile = File.createTempFile("file_browser", ".html");
            FileOutputStream outputStream = new FileOutputStream(tempFile);
            String folderName = source.getName();
            String prefix = String.format(FOLDER_HTML_PREFIX, folderName, folderName);
            ((OutputStream)outputStream).write(prefix.getBytes("utf-8"));
            if (files != null && files.length > 0) {
                for (File file : files) {
                    String filePath = file.getAbsolutePath();
                    int rootIndex = filePath.indexOf(this.mRootPath);
                    String httpPath = filePath.substring(rootIndex + this.mRootPath.length());
                    httpPath = this.addStartSlash(httpPath);
                    String fileItem = String.format(FOLDER_ITEM, httpPath, file.getName());
                    ((OutputStream)outputStream).write(fileItem.getBytes("utf-8"));
                }
            }
            ((OutputStream)outputStream).write(FOLDER_HTML_SUFFIX.getBytes("utf-8"));
            return this.generateSourceView(tempFile);
        }
        return this.generateSourceView(source);
    }

    private View generateSourceView(File source) throws IOException {
        String mimeType = FileUtils.getMimeType(source.getAbsolutePath());
        FileEntity httpEntity = new FileEntity(source, ContentType.create((String)mimeType, (Charset)Charset.defaultCharset()));
        return new View(200, (HttpEntity)httpEntity);
    }

    @Override
    public long getLastModified(HttpRequest request) throws IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        if (source != null && source.isFile()) {
            return source.lastModified();
        }
        return -1L;
    }

    @Override
    public String getETag(HttpRequest request) throws IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        File source = this.findPathSource(httpPath);
        if (source != null && source.isFile()) {
            long sourceSize = source.length();
            String sourcePath = source.getAbsolutePath();
            long lastModified = source.lastModified();
            return sourceSize + sourcePath + lastModified;
        }
        return null;
    }
}

