/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ab.adapter.AbFragmentPagerAdapter;
import com.ab.util.AbLogUtil;
import com.ab.view.sliding.AbTabItemView;
import java.util.ArrayList;
import java.util.List;

public class AbSlidingTabView
extends LinearLayout {
    private Context context;
    private Runnable mTabSelector;
    private ViewPager.OnPageChangeListener mListener;
    public int mMaxTabWidth;
    private int mSelectedTabIndex;
    private int tabBackgroundResource = -1;
    private int tabTextSize = 30;
    private int tabTextColor = -16777216;
    private int tabSelectColor = -16777216;
    private LinearLayout mTabLayout = null;
    private HorizontalScrollView mTabScrollView = null;
    private ViewPager mViewPager;
    private List<String> tabItemTextList = null;
    private List<Drawable> tabItemDrawableList = null;
    private ArrayList<Fragment> pagerItemList = null;
    private ArrayList<TextView> tabItemList = null;
    private AbFragmentPagerAdapter mFragmentPagerAdapter = null;
    private View.OnClickListener mTabClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            AbTabItemView tabView = (AbTabItemView)view;
            AbSlidingTabView.this.mViewPager.setCurrentItem(tabView.getIndex());
        }
    };

    public AbSlidingTabView(Context context) {
        this(context, null);
    }

    public AbSlidingTabView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setOrientation(1);
        this.setBackgroundColor(Color.rgb((int)255, (int)255, (int)255));
        this.mTabScrollView = new HorizontalScrollView(context);
        this.mTabScrollView.setHorizontalScrollBarEnabled(false);
        this.mTabScrollView.setSmoothScrollingEnabled(true);
        this.mTabLayout = new LinearLayout(context);
        this.mTabLayout.setOrientation(0);
        this.mTabLayout.setGravity(17);
        this.mTabScrollView.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
        this.addView((View)this.mTabScrollView, new ViewGroup.LayoutParams(-1, -2));
        this.mViewPager = new ViewPager(context);
        this.mViewPager.setId(1985);
        this.pagerItemList = new ArrayList();
        this.tabItemList = new ArrayList();
        this.tabItemTextList = new ArrayList<String>();
        this.tabItemDrawableList = new ArrayList<Drawable>();
        if (!(this.context instanceof FragmentActivity)) {
            AbLogUtil.e(AbSlidingTabView.class, "\u6784\u9020AbSlidingTabView\u7684\u53c2\u6570context,\u5fc5\u987b\u662fFragmentActivity\u7684\u5b9e\u4f8b\u3002");
        }
        FragmentManager mFragmentManager = ((FragmentActivity)this.context).getFragmentManager();
        this.mFragmentPagerAdapter = new AbFragmentPagerAdapter(mFragmentManager, this.pagerItemList);
        this.mViewPager.setAdapter((PagerAdapter)this.mFragmentPagerAdapter);
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new MyOnPageChangeListener());
        this.mViewPager.setOffscreenPageLimit(3);
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        boolean lockedExpanded = widthMode == 0x40000000;
        this.mTabScrollView.setFillViewport(lockedExpanded);
        int childCount = this.mTabLayout.getChildCount();
        this.mMaxTabWidth = childCount > 1 && (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE) ? (childCount > 2 ? (int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * 0.4f) : View.MeasureSpec.getSize((int)widthMeasureSpec) / 2) : -1;
        int oldWidth = this.getMeasuredWidth();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newWidth = this.getMeasuredWidth();
        if (lockedExpanded && oldWidth != newWidth) {
            this.setCurrentItem(this.mSelectedTabIndex);
        }
    }

    private void animateToTab(int position) {
        final View tabView = this.mTabLayout.getChildAt(position);
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
        this.mTabSelector = new Runnable(){

            @Override
            public void run() {
                int scrollPos = tabView.getLeft() - (AbSlidingTabView.this.getWidth() - tabView.getWidth()) / 2;
                AbSlidingTabView.this.mTabScrollView.smoothScrollTo(scrollPos, 0);
                AbSlidingTabView.this.mTabSelector = null;
            }
        };
        this.post(this.mTabSelector);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabSelector != null) {
            this.post(this.mTabSelector);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
    }

    private void addTab(String text, int index) {
        this.addTab(text, index, null);
    }

    private void addTab(String text, int index, Drawable top) {
        AbTabItemView tabView = new AbTabItemView(this.context);
        if (this.tabBackgroundResource != -1) {
            tabView.setTabBackgroundResource(this.tabBackgroundResource);
        }
        if (top != null) {
            tabView.setTabCompoundDrawables(null, top, null, null);
        }
        tabView.setTabTextColor(this.tabTextColor);
        tabView.setTabTextSize(this.tabTextSize);
        tabView.init(index, text);
        this.tabItemList.add(tabView.getTextView());
        tabView.setOnClickListener(this.mTabClickListener);
        this.mTabLayout.addView((View)tabView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
    }

    public void notifyTabDataSetChanged() {
        this.mTabLayout.removeAllViews();
        this.tabItemList.clear();
        int count = this.mFragmentPagerAdapter.getCount();
        int i = 0;
        while (i < count) {
            if (this.tabItemDrawableList.size() > 0) {
                this.addTab(this.tabItemTextList.get(i), i, this.tabItemDrawableList.get(i));
            } else {
                this.addTab(this.tabItemTextList.get(i), i);
            }
            ++i;
        }
        if (this.mSelectedTabIndex > count) {
            this.mSelectedTabIndex = count - 1;
        }
        this.setCurrentItem(this.mSelectedTabIndex);
        this.requestLayout();
    }

    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mSelectedTabIndex = item;
        int tabCount = this.mTabLayout.getChildCount();
        int i = 0;
        while (i < tabCount) {
            AbTabItemView child = (AbTabItemView)this.mTabLayout.getChildAt(i);
            boolean isSelected = i == item;
            child.setSelected(isSelected);
            if (isSelected) {
                child.setTabTextColor(this.tabSelectColor);
                this.animateToTab(item);
            } else {
                child.setTabTextColor(this.tabTextColor);
            }
            ++i;
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public void setTabTextColor(int tabColor) {
        this.tabTextColor = tabColor;
    }

    public void setTabSelectColor(int tabColor) {
        this.tabSelectColor = tabColor;
    }

    public void setTabTextSize(int tabTextSize) {
        this.tabTextSize = tabTextSize;
    }

    public void setTabBackgroundResource(int resid) {
        this.tabBackgroundResource = resid;
    }

    public void setTabLayoutBackgroundResource(int resid) {
        this.mTabLayout.setBackgroundResource(resid);
    }

    public void addItemViews(List<String> tabTexts, List<Fragment> fragments) {
        this.tabItemTextList.addAll(tabTexts);
        this.pagerItemList.addAll(fragments);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void addItemViews(List<String> tabTexts, List<Fragment> fragments, List<Drawable> drawables) {
        this.tabItemTextList.addAll(tabTexts);
        this.pagerItemList.addAll(fragments);
        this.tabItemDrawableList.addAll(drawables);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void addItemView(String tabText, Fragment fragment) {
        this.tabItemTextList.add(tabText);
        this.pagerItemList.add(fragment);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void addItemView(String tabText, Fragment fragment, Drawable drawable) {
        this.tabItemTextList.add(tabText);
        this.pagerItemList.add(fragment);
        this.tabItemDrawableList.add(drawable);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void removeItemView(int index) {
        this.mTabLayout.removeViewAt(index);
        this.pagerItemList.remove(index);
        this.tabItemList.remove(index);
        this.tabItemDrawableList.remove(index);
        this.tabItemTextList.remove(index);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void removeAllItemViews() {
        this.mTabLayout.removeAllViews();
        this.pagerItemList.clear();
        this.tabItemList.clear();
        this.tabItemDrawableList.clear();
        this.tabItemTextList.clear();
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setTabPadding(int left, int top, int right, int bottom) {
        int i = 0;
        while (i < this.tabItemList.size()) {
            TextView tv = this.tabItemList.get(i);
            tv.setPadding(left, top, right, bottom);
            ++i;
        }
    }

    public class MyOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        public void onPageScrollStateChanged(int arg0) {
            if (AbSlidingTabView.this.mListener != null) {
                AbSlidingTabView.this.mListener.onPageScrollStateChanged(arg0);
            }
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
            if (AbSlidingTabView.this.mListener != null) {
                AbSlidingTabView.this.mListener.onPageScrolled(arg0, arg1, arg2);
            }
        }

        public void onPageSelected(int arg0) {
            AbSlidingTabView.this.setCurrentItem(arg0);
            if (AbSlidingTabView.this.mListener != null) {
                AbSlidingTabView.this.mListener.onPageSelected(arg0);
            }
        }
    }
}

