/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;

public class AbSlidingPageView
extends ViewGroup {
    private String TAG = AbSlidingPageView.class.getSimpleName();
    private boolean D = true;
    private Scroller mScroller;
    private VelocityTracker mVelocityTracker;
    public static final int SCREEN_STATE_NEXT = 0;
    public static final int SCREEN_STATE_PROVIOUS = 1;
    private int mScreenState = 1;
    private int nextViewOffset = 50;
    private ViewPager.OnPageChangeListener onPageChangeListener = null;
    private boolean finish = true;

    public AbSlidingPageView(Context context) {
        super(context);
        this.mScroller = new Scroller(context);
    }

    public AbSlidingPageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int i = 0;
        while (i < this.getChildCount()) {
            View child = this.getChildAt(i);
            int height = child.getMeasuredHeight();
            int width = child.getMeasuredWidth();
            child.setFocusable(true);
            if (this.D) {
                Log.d((String)this.TAG, (String)("--onLayout--:" + width));
            }
            if (i == 0) {
                child.layout(-this.nextViewOffset, 0, this.nextViewOffset + width, height);
            } else {
                child.layout(width - this.nextViewOffset, 0, 2 * width - this.nextViewOffset, height);
            }
            ++i;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.D) {
            Log.d((String)this.TAG, (String)"--onMeasure--");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChildAt(i).measure(widthMeasureSpec, heightMeasureSpec);
            ++i;
        }
    }

    public void showNext() {
        if (!this.finish || this.mScreenState == 0) {
            return;
        }
        this.finish = false;
        this.mScreenState = 0;
        if (this.onPageChangeListener != null) {
            this.onPageChangeListener.onPageSelected(1);
        }
        if (this.D) {
            Log.d((String)this.TAG, (String)("--showNext--:" + this.getScrollX() + " dx " + (this.getChildAt(1).getWidth() - 2 * this.nextViewOffset)));
        }
        this.mScroller.startScroll(this.getScrollX(), 0, this.getChildAt(1).getWidth() - 2 * this.nextViewOffset, 0, 800);
        this.invalidate();
    }

    public void showPrevious() {
        if (!this.finish || this.mScreenState == 1) {
            return;
        }
        this.mScreenState = 1;
        if (this.onPageChangeListener != null) {
            this.onPageChangeListener.onPageSelected(0);
        }
        if (this.D) {
            Log.d((String)this.TAG, (String)("--showPrevious--:" + this.getScrollX() + " dx -" + this.getScrollX()));
        }
        this.mScroller.startScroll(this.getScrollX(), 0, -this.getScrollX(), 0, 800);
        this.invalidate();
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.postInvalidate();
        }
        if (this.mScroller.getFinalX() == this.mScroller.getCurrX()) {
            this.finish = true;
        }
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public int getScreenState() {
        return this.mScreenState;
    }

    public void addContentView(View view) {
        this.addView(view, 0, this.getLayoutParams());
        view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    AbSlidingPageView.this.showPrevious();
                }
            }
        });
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    AbSlidingPageView.this.showPrevious();
                }
                return false;
            }
        });
    }

    public void addNextView(View view) {
        this.addView(view, 1, this.getLayoutParams());
        view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    AbSlidingPageView.this.showNext();
                }
            }
        });
        view.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    AbSlidingPageView.this.showNext();
                }
                return false;
            }
        });
    }

    public int getNextViewOffset() {
        return this.nextViewOffset;
    }

    public void setNextViewOffset(int nextViewOffset) {
        this.nextViewOffset = nextViewOffset;
    }

    public ViewPager.OnPageChangeListener getOnPageChangeListener() {
        return this.onPageChangeListener;
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
    }
}

