/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sample;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public class AbTextView
extends TextView {
    private float leftPadding = 0.0f;
    private float topPadding = 0.0f;
    private float rightPadding = 0.0f;
    private float bottomPadding = 0.0f;
    private float lineSpacing = 0.0f;
    private int maxLines = 1;
    private float textSize = 14.0f;
    private int textColor = -1;
    private TextPaint mTextPaint = this.getPaint();

    public AbTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mTextPaint.setColor(this.textColor);
        this.mTextPaint.setTextSize(this.textSize);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(0);
        this.drawText(canvas, this.getText().toString(), this.getWidth(), this.getPaint());
    }

    public void setPadding(float left, float top, float right, float bottom) {
        this.leftPadding = left;
        this.topPadding = top;
        this.rightPadding = right;
        this.bottomPadding = bottom;
        this.invalidate();
    }

    public int subStringLength(String str, int maxPix, TextPaint paint) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return 0;
        }
        int currentIndex = 0;
        int i = 0;
        while (i < str.length()) {
            String temp = str.substring(0, i + 1);
            float valueLength = paint.measureText(temp) + this.leftPadding + this.rightPadding;
            if (valueLength > (float)maxPix) {
                currentIndex = i - 1;
                break;
            }
            if (valueLength == (float)maxPix) {
                currentIndex = i;
                break;
            }
            ++i;
        }
        if (currentIndex == 0) {
            currentIndex = str.length() - 1;
        }
        return currentIndex;
    }

    public float getStringWidth(String str, TextPaint paint) {
        float strWidth = paint.measureText(str);
        return strWidth;
    }

    public float getDesiredWidth(String str, TextPaint paint) {
        float strWidth = Layout.getDesiredWidth((CharSequence)str, (TextPaint)paint);
        return strWidth;
    }

    public List<String> getDrawRowStr(String text, int maxWPix, TextPaint paint) {
        String[] texts = null;
        texts = text.indexOf("\n") != -1 ? text.split("\n") : new String[]{text};
        ArrayList<String> mStrList = new ArrayList<String>();
        int i = 0;
        while (i < texts.length) {
            String textLine = texts[i];
            while (true) {
                int endIndex;
                if ((endIndex = this.subStringLength(textLine, maxWPix, paint)) <= 0) {
                    mStrList.add(textLine);
                } else if (endIndex == textLine.length() - 1) {
                    mStrList.add(textLine);
                } else {
                    mStrList.add(textLine.substring(0, endIndex + 1));
                }
                if (textLine.length() <= endIndex + 1) break;
                textLine = textLine.substring(endIndex + 1);
            }
            ++i;
        }
        return mStrList;
    }

    public int getDrawRowCount(String text, int maxWPix, TextPaint paint) {
        String[] texts = null;
        texts = text.indexOf("\n") != -1 ? text.split("\n") : new String[]{text};
        ArrayList<String> mStrList = new ArrayList<String>();
        int i = 0;
        while (i < texts.length) {
            String textLine = texts[i];
            while (true) {
                int endIndex;
                if ((endIndex = this.subStringLength(textLine, maxWPix, paint)) <= 0) {
                    mStrList.add(textLine);
                } else if (endIndex == textLine.length() - 1) {
                    mStrList.add(textLine);
                } else {
                    mStrList.add(textLine.substring(0, endIndex + 1));
                }
                if (textLine.length() <= endIndex + 1) break;
                textLine = textLine.substring(endIndex + 1);
            }
            ++i;
        }
        return mStrList.size();
    }

    public int drawText(Canvas canvas, String text, int maxWPix, TextPaint paint) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 1;
        }
        List<String> mStrList = this.getDrawRowStr(text, maxWPix, paint);
        Paint.FontMetrics fm = paint.getFontMetrics();
        int hSize = (int)Math.ceil(fm.descent - fm.ascent);
        int i = 0;
        while (i < mStrList.size()) {
            float x = this.leftPadding;
            float y = this.topPadding + (float)(hSize / 2) + (float)i * ((float)hSize + this.lineSpacing) + this.bottomPadding;
            String textLine = mStrList.get(i);
            if (i < this.maxLines) {
                canvas.drawText(textLine, x, y, (Paint)paint);
            }
            ++i;
        }
        return mStrList.size();
    }

    @SuppressLint(value={"Override"})
    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
        this.invalidate();
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setTextSize(float size) {
        this.textSize = size;
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        this.setRawTextSize(TypedValue.applyDimension((int)2, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
    }

    private void setRawTextSize(float size) {
        if (size != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(size);
            this.invalidate();
        }
    }

    public float getTextSize() {
        return this.textSize;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.mTextPaint.setColor(textColor);
        this.invalidate();
    }
}

