/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.level;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextPaint;
import com.ab.util.AbGraphicUtil;
import com.ab.util.AbViewUtil;
import com.ab.view.level.AbLevelAbstractChart;
import com.ab.view.level.AbLevelSeriesDataset;
import com.ab.view.level.AbLevelSeriesRenderer;

public class AbLevelChart
extends AbLevelAbstractChart {
    private static final long serialVersionUID = 1L;
    protected AbLevelSeriesDataset mDataset;
    protected AbLevelSeriesRenderer mRenderer;
    private int measureWidth;
    private int measureHeight;
    private int[] color = null;
    private float[] part = null;
    private float[] partValue = null;
    private String textValue = null;
    private String textDesc = null;
    private int textlevelIndex = 0;
    private int textLevelSize = 30;
    private int marginTop = 30;
    private int arrowWidth = 20;
    private int arrowHeight = 10;
    private int levelHeight = 20;
    private int arrowMarginTop = 10;
    private int partTextSize = 15;
    private int textDescSize = 22;

    protected AbLevelChart() {
    }

    public AbLevelChart(AbLevelSeriesDataset mDataset, AbLevelSeriesRenderer mRenderer) {
        this.mDataset = mDataset;
        this.mRenderer = mRenderer;
        this.measureWidth = mRenderer.getWidth();
        this.measureHeight = mRenderer.getHeight();
    }

    protected void setDatasetRenderer(AbLevelSeriesDataset dataset, AbLevelSeriesRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    @Override
    public void draw(Canvas canvas, int x, int y, int measureWidth, int measureHeight, int screenWidth, int screenHeight, Paint paint) {
        this.color = this.mRenderer.getColor();
        this.part = this.mRenderer.getPart();
        this.partValue = this.mRenderer.getPartValue();
        this.textValue = this.mRenderer.getTextValue();
        this.textDesc = this.mRenderer.getTextDesc();
        this.textlevelIndex = this.mRenderer.getTextlevelIndex();
        this.textLevelSize = this.mRenderer.getTextLevelSize();
        this.textLevelSize = AbViewUtil.scale(screenWidth, screenHeight, this.textLevelSize);
        this.marginTop = this.mRenderer.getMarginTop();
        this.arrowWidth = this.mRenderer.getArrowWidth();
        this.arrowHeight = this.mRenderer.getArrowHeight();
        this.levelHeight = this.mRenderer.getLevelHeight();
        this.arrowMarginTop = this.mRenderer.getArrowMarginTop();
        this.partTextSize = this.mRenderer.getPartTextSize();
        this.textDescSize = this.mRenderer.getTextDescSize();
        TextPaint mTextPaint = new TextPaint(1);
        mTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        mTextPaint.setTextSize((float)this.textLevelSize);
        Paint.FontMetrics fm = mTextPaint.getFontMetrics();
        int textHeight = (int)Math.ceil(fm.descent - fm.ascent) + 2 - 20;
        int textWidth = (int)AbGraphicUtil.getStringWidth(this.textValue, mTextPaint);
        int left = (screenWidth - measureWidth) / 2;
        int topLevel = this.marginTop + textHeight + this.arrowHeight + this.arrowMarginTop;
        RectF mLevelRect = new RectF((float)left, (float)topLevel, (float)(left + measureWidth), (float)(topLevel + this.levelHeight));
        paint.setStyle(Paint.Style.FILL);
        paint.setAntiAlias(true);
        paint.setStrokeWidth(2.0f);
        paint.setColor(Color.rgb((int)228, (int)228, (int)228));
        canvas.drawRoundRect(mLevelRect, 1.0f, 1.0f, paint);
        int partWidth = measureWidth / 10;
        RectF mLevelRectPart = null;
        float sumLeft = 0.0f;
        float sumRight = 0.0f;
        int i = 0;
        while (i < this.color.length) {
            if (i == 0) {
                sumLeft = left;
                sumRight = sumLeft + this.part[i] * (float)partWidth;
                mLevelRectPart = new RectF(sumLeft, (float)topLevel, sumRight, (float)(topLevel + this.levelHeight));
            } else {
                mLevelRectPart = new RectF((sumLeft += this.part[i - 1] * (float)partWidth) + 1.0f, (float)topLevel, sumRight += this.part[i] * (float)partWidth, (float)(topLevel + this.levelHeight));
            }
            paint.setColor(this.color[i]);
            if (this.textlevelIndex == i) {
                paint.setFlags(1);
                paint.setTextSize((float)this.textLevelSize);
                paint.setTypeface(Typeface.DEFAULT_BOLD);
                float textLeftOffset = (this.part[i] * (float)partWidth - (float)textWidth) / 2.0f;
                canvas.drawText(this.textValue, sumLeft + textLeftOffset, (float)this.marginTop, paint);
                float arrowLeftOffset = (this.part[i] * (float)partWidth - (float)this.arrowWidth) / 2.0f;
                float center = sumLeft + arrowLeftOffset + (float)(this.arrowWidth / 2);
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(Color.rgb((int)153, (int)234, (int)71));
                Path path1 = new Path();
                path1.moveTo(center, (float)(this.marginTop + textHeight + this.arrowHeight));
                path1.lineTo(sumLeft + arrowLeftOffset, (float)(this.marginTop + textHeight));
                path1.lineTo(sumLeft + arrowLeftOffset + (float)this.arrowWidth, (float)(this.marginTop + textHeight));
                path1.close();
                canvas.drawPath(path1, paint);
                paint.setColor(Color.rgb((int)227, (int)227, (int)227));
                paint.setStyle(Paint.Style.FILL);
                Path path2 = new Path();
                path2.moveTo(center, (float)(this.marginTop + textHeight + this.arrowHeight + this.levelHeight + 2 * this.arrowMarginTop));
                path2.lineTo(sumLeft + arrowLeftOffset, (float)(this.marginTop + textHeight + this.levelHeight + 2 * this.arrowHeight + 2 * this.arrowMarginTop));
                path2.lineTo(sumLeft + arrowLeftOffset + (float)this.arrowWidth, (float)(this.marginTop + textHeight + this.levelHeight + 2 * this.arrowHeight + 2 * this.arrowMarginTop));
                path2.close();
                canvas.drawPath(path2, paint);
                int topDesc = this.marginTop + textHeight + 2 * this.arrowHeight + 2 * this.arrowMarginTop + this.levelHeight;
                RectF mLevelDescRect = new RectF(center - (float)(this.mRenderer.getTextRectWidth() / 2), (float)topDesc, center + (float)(this.mRenderer.getTextRectWidth() / 2), (float)(topDesc + this.mRenderer.getTextRectHeight()));
                canvas.drawRoundRect(mLevelDescRect, 5.0f, 5.0f, paint);
                paint.setTypeface(Typeface.DEFAULT_BOLD);
                paint.setTextSize((float)this.textDescSize);
                paint.setColor(Color.rgb((int)157, (int)157, (int)157));
                mTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
                mTextPaint.setTextSize((float)this.textDescSize);
                Paint.FontMetrics textDescFm = mTextPaint.getFontMetrics();
                int textDescHeight = (int)Math.ceil(textDescFm.descent - textDescFm.ascent) + 2;
                int textDescWidth = (int)AbGraphicUtil.getStringWidth(this.textDesc, mTextPaint);
                canvas.drawText(this.textDesc, center - (float)(textDescWidth / 2), (float)(topDesc + 20 + (this.mRenderer.getTextRectHeight() - textDescHeight) / 2), paint);
                paint.setColor(this.color[i]);
            }
            canvas.drawRoundRect(mLevelRectPart, 1.0f, 1.0f, paint);
            if (this.partValue != null && this.partValue.length == this.color.length) {
                paint.setTextSize((float)this.partTextSize);
                mTextPaint.setTextSize((float)this.partTextSize);
                int partValueWidth = (int)AbGraphicUtil.getStringWidth(String.valueOf(this.partValue[i]), mTextPaint);
                canvas.drawText(String.valueOf(this.partValue[i]), mLevelRectPart.left - (float)(partValueWidth / 2), mLevelRectPart.top + (float)this.levelHeight + 15.0f, paint);
            }
            ++i;
        }
    }

    public int getWidth() {
        return this.measureWidth;
    }

    public int getHeight() {
        return this.measureHeight;
    }
}

