/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.cropimage;

import android.graphics.Bitmap;
import android.graphics.Matrix;

public class RotateBitmap {
    public static final String TAG = "RotateBitmap";
    private Bitmap mBitmap;
    private int mRotation;

    public RotateBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mRotation = 0;
    }

    public RotateBitmap(Bitmap bitmap, int rotation) {
        this.mBitmap = bitmap;
        this.mRotation = rotation % 360;
    }

    public void setRotation(int rotation) {
        this.mRotation = rotation;
    }

    public int getRotation() {
        return this.mRotation;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
    }

    public Matrix getRotateMatrix() {
        Matrix matrix = new Matrix();
        if (this.mRotation != 0) {
            int cx = this.mBitmap.getWidth() / 2;
            int cy = this.mBitmap.getHeight() / 2;
            matrix.preTranslate((float)(-cx), (float)(-cy));
            matrix.postRotate((float)this.mRotation);
            matrix.postTranslate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        }
        return matrix;
    }

    public boolean isOrientationChanged() {
        return this.mRotation / 90 % 2 != 0;
    }

    public int getHeight() {
        if (this.isOrientationChanged()) {
            return this.mBitmap.getWidth();
        }
        return this.mBitmap.getHeight();
    }

    public int getWidth() {
        if (this.isOrientationChanged()) {
            return this.mBitmap.getHeight();
        }
        return this.mBitmap.getWidth();
    }

    public void recycle() {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }
}

