/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.cropimage;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.ImageView;
import com.ab.view.cropimage.RotateBitmap;

public abstract class CropViewBase
extends ImageView {
    private static final String TAG = "ImageViewTouchBase";
    protected Matrix mBaseMatrix = new Matrix();
    protected Matrix mSuppMatrix = new Matrix();
    private final Matrix mDisplayMatrix = new Matrix();
    private final float[] mMatrixValues = new float[9];
    public final RotateBitmap mBitmapDisplayed = new RotateBitmap(null);
    int mThisWidth = -1;
    int mThisHeight = -1;
    float mMaxZoom;
    public static final int STATE_HIGHLIGHT = 0;
    public static final int STATE_DOODLE = 1;
    public static final int STATE_NONE = 2;
    protected int mState = 0;
    private Recycler mRecycler;
    protected Handler mHandler = new Handler();
    protected int mLastXTouchPos;
    protected int mLastYTouchPos;
    private Runnable mOnLayoutRunnable = null;
    static final float SCALE_RATE = 1.25f;

    public void setRecycler(Recycler r) {
        this.mRecycler = r;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mThisWidth = right - left;
        this.mThisHeight = bottom - top;
        Runnable r = this.mOnLayoutRunnable;
        if (r != null) {
            this.mOnLayoutRunnable = null;
            r.run();
        }
        if (this.mBitmapDisplayed.getBitmap() != null) {
            this.getProperBaseMatrix(this.mBitmapDisplayed, this.mBaseMatrix);
            this.setImageMatrix(this.getImageViewMatrix());
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.getScale() > 1.0f) {
            this.zoomTo(1.0f);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageBitmap(bitmap, 0);
    }

    private void setImageBitmap(Bitmap bitmap, int rotation) {
        super.setImageBitmap(bitmap);
        Drawable d = this.getDrawable();
        if (d != null) {
            d.setDither(true);
        }
        Bitmap old = this.mBitmapDisplayed.getBitmap();
        this.mBitmapDisplayed.setBitmap(bitmap);
        this.mBitmapDisplayed.setRotation(rotation);
        if (old != null && old != bitmap && this.mRecycler != null) {
            this.mRecycler.recycle(old);
        }
    }

    public void clear() {
        this.setImageBitmapResetBase(null, true);
    }

    public void setImageBitmapResetBase(Bitmap bitmap, boolean resetSupp) {
        this.setImageRotateBitmapResetBase(new RotateBitmap(bitmap), resetSupp);
    }

    public void setImageRotateBitmapResetBase(final RotateBitmap bitmap, final boolean resetSupp) {
        int viewWidth = this.getWidth();
        if (viewWidth <= 0) {
            this.mOnLayoutRunnable = new Runnable(){

                @Override
                public void run() {
                    CropViewBase.this.setImageRotateBitmapResetBase(bitmap, resetSupp);
                }
            };
            return;
        }
        if (bitmap.getBitmap() != null) {
            this.getProperBaseMatrix(bitmap, this.mBaseMatrix);
            this.setImageBitmap(bitmap.getBitmap(), bitmap.getRotation());
        } else {
            this.mBaseMatrix.reset();
            this.setImageBitmap(null);
        }
        if (resetSupp) {
            this.mSuppMatrix.reset();
        }
        this.setImageMatrix(this.getImageViewMatrix());
        this.mMaxZoom = this.maxZoom();
    }

    public void center(boolean horizontal, boolean vertical) {
        if (this.mBitmapDisplayed.getBitmap() == null) {
            return;
        }
        Matrix m = this.getImageViewMatrix();
        RectF rect = new RectF(0.0f, 0.0f, (float)this.mBitmapDisplayed.getBitmap().getWidth(), (float)this.mBitmapDisplayed.getBitmap().getHeight());
        m.mapRect(rect);
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (vertical) {
            int viewHeight = this.getHeight();
            if (height < (float)viewHeight) {
                deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
            } else if (rect.top > 0.0f) {
                deltaY = -rect.top;
            } else if (rect.bottom < (float)viewHeight) {
                deltaY = (float)this.getHeight() - rect.bottom;
            }
        }
        if (horizontal) {
            int viewWidth = this.getWidth();
            if (width < (float)viewWidth) {
                deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
            } else if (rect.left > 0.0f) {
                deltaX = -rect.left;
            } else if (rect.right < (float)viewWidth) {
                deltaX = (float)viewWidth - rect.right;
            }
        }
        this.postTranslate(deltaX, deltaY);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    public CropViewBase(Context context) {
        super(context);
        this.init();
    }

    public CropViewBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    protected float getScale(Matrix matrix) {
        return this.getValue(matrix, 0);
    }

    public float getScale() {
        return this.getScale(this.mSuppMatrix);
    }

    private void getProperBaseMatrix(RotateBitmap bitmap, Matrix matrix) {
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        float w = bitmap.getWidth();
        float h = bitmap.getHeight();
        matrix.reset();
        float widthScale = Math.min(viewWidth / w, 2.0f);
        float heightScale = Math.min(viewHeight / h, 2.0f);
        float scale = Math.min(widthScale, heightScale);
        matrix.postConcat(bitmap.getRotateMatrix());
        matrix.postScale(scale, scale);
        matrix.postTranslate((viewWidth - w * scale) / 2.0f, (viewHeight - h * scale) / 2.0f);
    }

    protected Matrix getImageViewMatrix() {
        this.mDisplayMatrix.set(this.mBaseMatrix);
        this.mDisplayMatrix.postConcat(this.mSuppMatrix);
        return this.mDisplayMatrix;
    }

    protected float maxZoom() {
        float fh;
        if (this.mBitmapDisplayed.getBitmap() == null) {
            return 1.0f;
        }
        float fw = (float)this.mBitmapDisplayed.getWidth() / (float)this.mThisWidth;
        float max = Math.max(fw, fh = (float)this.mBitmapDisplayed.getHeight() / (float)this.mThisHeight) * 4.0f;
        max = max < 1.0f ? 1.0f : max;
        return max;
    }

    protected void zoomTo(float scale, float centerX, float centerY) {
        if (scale > this.mMaxZoom) {
            scale = this.mMaxZoom;
        }
        float oldScale = this.getScale();
        float deltaScale = scale / oldScale;
        this.mSuppMatrix.postScale(deltaScale, deltaScale, centerX, centerY);
        this.setImageMatrix(this.getImageViewMatrix());
        this.center(true, true);
    }

    protected void zoomTo(float scale, final float centerX, final float centerY, final float durationMs) {
        final float incrementPerMs = (scale - this.getScale()) / durationMs;
        final float oldScale = this.getScale();
        final long startTime = System.currentTimeMillis();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                float currentMs = Math.min(durationMs, (float)(now - startTime));
                float target = oldScale + incrementPerMs * currentMs;
                CropViewBase.this.zoomTo(target, centerX, centerY);
                if (currentMs < durationMs) {
                    CropViewBase.this.mHandler.post((Runnable)this);
                }
            }
        });
    }

    protected void zoomTo(float scale) {
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        this.zoomTo(scale, cx, cy);
    }

    protected void zoomIn() {
        this.zoomIn(1.25f);
    }

    protected void zoomOut() {
        this.zoomOut(1.25f);
    }

    protected void zoomIn(float rate) {
        if (this.getScale() >= this.mMaxZoom) {
            return;
        }
        if (this.mBitmapDisplayed.getBitmap() == null) {
            return;
        }
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        this.mSuppMatrix.postScale(rate, rate, cx, cy);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    protected void zoomOut(float rate) {
        if (this.mBitmapDisplayed.getBitmap() == null) {
            return;
        }
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        Matrix tmp = new Matrix(this.mSuppMatrix);
        tmp.postScale(1.0f / rate, 1.0f / rate, cx, cy);
        if (this.getScale(tmp) < 1.0f) {
            this.mSuppMatrix.setScale(1.0f, 1.0f, cx, cy);
        } else {
            this.mSuppMatrix.postScale(1.0f / rate, 1.0f / rate, cx, cy);
        }
        this.setImageMatrix(this.getImageViewMatrix());
        this.center(true, true);
    }

    protected void postTranslate(float dx, float dy) {
        this.mSuppMatrix.postTranslate(dx, dy);
    }

    protected void panBy(float dx, float dy) {
        this.postTranslate(dx, dy);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    public static interface Recycler {
        public void recycle(Bitmap var1);
    }
}

