/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import com.ab.view.chart.XYSeries;
import java.util.ArrayList;
import java.util.List;

public class XYValueSeries
extends XYSeries {
    private List<Double> mValue = new ArrayList<Double>();
    private double mMinValue = Double.MAX_VALUE;
    private double mMaxValue = -1.7976931348623157E308;

    public XYValueSeries(String title) {
        super(title);
    }

    public synchronized void add(double x, double y, double value) {
        super.add(x, y);
        this.mValue.add(value);
        this.updateRange(value);
    }

    private void initRange() {
        this.mMinValue = Double.MAX_VALUE;
        this.mMaxValue = Double.MAX_VALUE;
        int length = this.getItemCount();
        int k = 0;
        while (k < length) {
            this.updateRange(this.getValue(k));
            ++k;
        }
    }

    private void updateRange(double value) {
        this.mMinValue = Math.min(this.mMinValue, value);
        this.mMaxValue = Math.max(this.mMaxValue, value);
    }

    @Override
    public synchronized void add(double x, double y) {
        this.add(x, y, 0.0);
    }

    @Override
    public synchronized void remove(int index) {
        super.remove(index);
        double removedValue = this.mValue.remove(index);
        if (removedValue == this.mMinValue || removedValue == this.mMaxValue) {
            this.initRange();
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.mValue.clear();
        this.initRange();
    }

    public synchronized double getValue(int index) {
        return this.mValue.get(index);
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }
}

