/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import android.content.Context;
import android.util.Log;
import com.ab.view.chart.AreaChart;
import com.ab.view.chart.BarChart;
import com.ab.view.chart.CategorySeries;
import com.ab.view.chart.DefaultRenderer;
import com.ab.view.chart.GraphicalView;
import com.ab.view.chart.LineChart;
import com.ab.view.chart.MultipleCategorySeries;
import com.ab.view.chart.PieChart;
import com.ab.view.chart.TimeChart;
import com.ab.view.chart.XYMultipleSeriesDataset;
import com.ab.view.chart.XYMultipleSeriesRenderer;

public class ChartFactory {
    public static final String CHART = "chart";
    public static final String TITLE = "title";

    private ChartFactory() {
    }

    public static final GraphicalView getLineChartView(Context context, XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        ChartFactory.checkParameters(dataset, renderer);
        LineChart chart = new LineChart(dataset, renderer);
        return new GraphicalView(context, chart);
    }

    public static final GraphicalView getBarChartView(Context context, XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, BarChart.Type type) {
        ChartFactory.checkParameters(dataset, renderer);
        BarChart chart = new BarChart(dataset, renderer, type);
        return new GraphicalView(context, chart);
    }

    public static final GraphicalView getPieChartView(Context context, CategorySeries dataset, DefaultRenderer renderer) {
        ChartFactory.checkParameters(dataset, renderer);
        PieChart chart = new PieChart(dataset, renderer);
        return new GraphicalView(context, chart);
    }

    public static final GraphicalView getTimeChartView(Context context, XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, String format) {
        ChartFactory.checkParameters(dataset, renderer);
        TimeChart chart = new TimeChart(dataset, renderer);
        Log.d((String)"ChartFactory", (String)("TimeChart:" + chart.mDataset));
        chart.setDateFormat(format);
        return new GraphicalView(context, chart);
    }

    public static final GraphicalView getAreaChartView(Context context, XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, float smoothness) {
        ChartFactory.checkParameters(dataset, renderer);
        AreaChart chart = new AreaChart(dataset, renderer, smoothness);
        return new GraphicalView(context, chart);
    }

    private static void checkParameters(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        if (dataset == null || renderer == null || dataset.getSeriesCount() != renderer.getSeriesRendererCount()) {
            throw new IllegalArgumentException("Dataset and renderer should be not null and should have the same number of series");
        }
    }

    private static void checkParameters(CategorySeries dataset, DefaultRenderer renderer) {
        if (dataset == null || renderer == null || dataset.getItemCount() != renderer.getSeriesRendererCount()) {
            throw new IllegalArgumentException("Dataset and renderer should be not null and the dataset number of items should be equal to the number of series renderers");
        }
    }

    private static void checkParameters(MultipleCategorySeries dataset, DefaultRenderer renderer) {
        if (dataset == null || renderer == null || !ChartFactory.checkMultipleSeriesItems(dataset, renderer.getSeriesRendererCount())) {
            throw new IllegalArgumentException("Titles and values should be not null and the dataset number of items should be equal to the number of series renderers");
        }
    }

    private static boolean checkMultipleSeriesItems(MultipleCategorySeries dataset, int value) {
        int count = dataset.getCategoriesCount();
        boolean equal = true;
        int k = 0;
        while (k < count && equal) {
            equal = dataset.getValues(k).length == dataset.getTitles(k).length;
            ++k;
        }
        return equal;
    }
}

