/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.carousel;

import android.content.Context;
import android.view.animation.AnimationUtils;

public class Rotator {
    private int mMode;
    private float mStartAngle;
    private float mCurrAngle;
    private long mStartTime;
    private long mDuration;
    private float mDeltaAngle;
    private boolean mFinished = true;
    private float mCoeffVelocity = 0.05f;
    private float mVelocity;
    private static final int DEFAULT_DURATION = 250;
    private static final int SCROLL_MODE = 0;
    private static final int FLING_MODE = 1;
    private final float mDeceleration = 240.0f;

    public Rotator(Context context) {
    }

    public final boolean isFinished() {
        return this.mFinished;
    }

    public final void forceFinished(boolean finished) {
        this.mFinished = finished;
    }

    public final long getDuration() {
        return this.mDuration;
    }

    public final float getCurrAngle() {
        return this.mCurrAngle;
    }

    public float getCurrVelocity() {
        return this.mCoeffVelocity * this.mVelocity - 240.0f * (float)this.timePassed();
    }

    public final float getStartAngle() {
        return this.mStartAngle;
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    public void extendDuration(int extend) {
        int passed = this.timePassed();
        this.mDuration = passed + extend;
        this.mFinished = false;
    }

    public void abortAnimation() {
        this.mFinished = true;
    }

    public boolean computeAngleOffset() {
        if (this.mFinished) {
            return false;
        }
        long systemClock = AnimationUtils.currentAnimationTimeMillis();
        long timePassed = systemClock - this.mStartTime;
        if (timePassed < this.mDuration) {
            switch (this.mMode) {
                case 0: {
                    float sc = (float)timePassed / (float)this.mDuration;
                    this.mCurrAngle = this.mStartAngle + (float)Math.round(this.mDeltaAngle * sc);
                    break;
                }
                case 1: {
                    float timePassedSeconds = (float)timePassed / 1000.0f;
                    float distance = this.mVelocity < 0.0f ? this.mCoeffVelocity * this.mVelocity * timePassedSeconds - 240.0f * timePassedSeconds * timePassedSeconds / 2.0f : -this.mCoeffVelocity * this.mVelocity * timePassedSeconds - 240.0f * timePassedSeconds * timePassedSeconds / 2.0f;
                    this.mCurrAngle = this.mStartAngle - Math.signum(this.mVelocity) * (float)Math.round(distance);
                }
            }
            return true;
        }
        this.mFinished = true;
        return false;
    }

    public void startRotate(float startAngle, float dAngle, int duration) {
        this.mMode = 0;
        this.mFinished = false;
        this.mDuration = duration;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartAngle = startAngle;
        this.mDeltaAngle = dAngle;
    }

    public void startRotate(float startAngle, float dAngle) {
        this.startRotate(startAngle, dAngle, 250);
    }

    public void fling(float velocityAngle) {
        float velocity;
        this.mMode = 1;
        this.mFinished = false;
        this.mVelocity = velocity = velocityAngle;
        this.mDuration = (int)(1000.0 * Math.sqrt(2.0f * this.mCoeffVelocity * Math.abs(velocity) / 240.0f));
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
    }
}

