/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.calendar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.ab.util.AbGraphicUtil;

public class CalendarHeader
extends View {
    private String TAG = "CalendarHeader";
    private final Paint mPaint;
    private RectF rect = new RectF();
    private int weekDay = 1;
    private String[] dayName = new String[10];
    private int width = 320;
    private int height = 480;
    private int cellWidth = 40;
    private int defaultTextColor = Color.rgb((int)86, (int)86, (int)86);
    private int specialTextColor = Color.rgb((int)240, (int)140, (int)26);
    private int defaultTextSize = 25;
    private boolean defaultTextBold = false;
    private boolean hasBg = false;

    public CalendarHeader(Context context) {
        this(context, null);
    }

    public CalendarHeader(Context context, AttributeSet attributeset) {
        super(context);
        this.dayName[1] = "\u5468\u65e5";
        this.dayName[2] = "\u5468\u4e00";
        this.dayName[3] = "\u5468\u4e8c";
        this.dayName[4] = "\u5468\u4e09";
        this.dayName[5] = "\u5468\u56db";
        this.dayName[6] = "\u5468\u4e94";
        this.dayName[7] = "\u5468\u516d";
        this.mPaint = new Paint();
        this.mPaint.setColor(this.defaultTextColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTypeface(Typeface.DEFAULT);
        this.mPaint.setTextSize((float)this.defaultTextSize);
        WindowManager wManager = (WindowManager)context.getSystemService("window");
        Display display = wManager.getDefaultDisplay();
        this.width = display.getWidth();
        this.height = display.getHeight();
        this.cellWidth = (this.width - 20) / 7;
    }

    public void setHeaderBackgroundResource(int resid) {
        this.setBackgroundResource(resid);
        this.hasBg = true;
    }

    public int getTextSize() {
        return this.defaultTextSize;
    }

    public void setTextSize(int mTextSize) {
        this.defaultTextSize = mTextSize;
        this.mPaint.setTextSize((float)this.defaultTextSize);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.hasBg) {
            canvas.drawColor(-1);
            this.rect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.rect.inset(0.5f, 0.5f);
        }
        this.drawDayHeader(canvas);
    }

    private void drawDayHeader(Canvas canvas) {
        if (!this.hasBg) {
            this.mPaint.setColor(Color.rgb((int)150, (int)195, (int)70));
            canvas.drawRect(this.rect, this.mPaint);
        }
        if (this.defaultTextBold) {
            this.mPaint.setFakeBoldText(true);
        }
        this.mPaint.setColor(this.defaultTextColor);
        int iDay = 1;
        while (iDay < 8) {
            if (iDay == 1 || iDay == 7) {
                this.mPaint.setColor(this.specialTextColor);
            }
            String sDayName = this.getWeekDayName(iDay);
            TextPaint mTextPaint = new TextPaint(1);
            mTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
            mTextPaint.setTextSize((float)this.defaultTextSize);
            Paint.FontMetrics fm = mTextPaint.getFontMetrics();
            int textHeight = (int)Math.ceil(fm.descent - fm.ascent);
            int textWidth = (int)AbGraphicUtil.getStringWidth(sDayName, mTextPaint);
            int iPosX = (int)this.rect.left + this.cellWidth * (iDay - 1) + (this.cellWidth - textWidth) / 2;
            int iPosY = (int)((float)(this.getHeight() - (this.getHeight() - textHeight) / 2) - this.mPaint.getFontMetrics().bottom);
            canvas.drawText(sDayName, (float)iPosX, (float)iPosY, this.mPaint);
            this.mPaint.setColor(this.defaultTextColor);
            ++iDay;
        }
    }

    public String getWeekDayName(int calendarDay) {
        return this.dayName[calendarDay];
    }
}

