/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import java.util.HashMap;
import java.util.Map;

public class AbPopoverView
extends RelativeLayout
implements View.OnTouchListener {
    public static final int PopoverArrowDirectionUp = 1;
    public static final int PopoverArrowDirectionDown = 2;
    public static final int PopoverArrowDirectionLeft = 4;
    public static final int PopoverArrowDirectionRight = 8;
    public static final int PopoverArrowDirectionAny = 15;
    private PopoverViewListener popoverViewListener;
    private RelativeLayout popoverView;
    private ViewGroup superview;
    private Point contentSizeForViewInPopover = new Point(0, 0);
    private Point realContentSize = new Point(0, 0);
    private Map<Integer, Rect> possibleRects;
    private boolean isAnimating = false;
    private int fadeAnimationTime = 300;
    private Rect popoverLayoutRect;
    private Drawable backgroundDrawable;
    private Drawable arrowUpDrawable;
    private Drawable arrowDownDrawable;
    private Drawable arrowLeftDrawable;
    private Drawable arrowRightDrawable;
    private ImageView arrowImageView = null;
    private View popoverContentView = null;

    public AbPopoverView(Context context) {
        super(context);
        this.initPopoverView();
    }

    public AbPopoverView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPopoverView();
    }

    public AbPopoverView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initPopoverView();
    }

    private void initPopoverView() {
        this.popoverView = new RelativeLayout(this.getContext());
        this.setBackgroundColor(-1);
        this.setOnTouchListener(this);
    }

    public static Rect getFrameForView(View v) {
        int[] location = new int[2];
        v.getLocationOnScreen(location);
        Rect viewRect = new Rect(location[0], location[1], location[0] + v.getWidth(), location[1] + v.getHeight());
        return viewRect;
    }

    private void addPopoverInRect(Rect insertRect) {
        RelativeLayout.LayoutParams insertParams = new RelativeLayout.LayoutParams(insertRect.width(), insertRect.height());
        insertParams.leftMargin = insertRect.left;
        insertParams.topMargin = insertRect.top;
        this.addView((View)this.popoverView, (ViewGroup.LayoutParams)insertParams);
    }

    private void initArrow(Rect originRect, Integer arrowDirection) {
        if (this.arrowImageView != null) {
            this.removeView((View)this.arrowImageView);
        }
        this.arrowImageView = new ImageView(this.getContext());
        Drawable arrowDrawable = null;
        int xPos = 0;
        int arrowWidth = 0;
        int yPos = 0;
        int arrowHeight = 0;
        if (arrowDirection == 1) {
            arrowDrawable = this.arrowUpDrawable;
            arrowWidth = arrowDrawable.getIntrinsicWidth();
            arrowHeight = arrowDrawable.getIntrinsicHeight();
            xPos = originRect.centerX() - arrowWidth / 2 - this.popoverLayoutRect.left;
            yPos = originRect.bottom - this.popoverLayoutRect.top;
        } else if (arrowDirection == 2) {
            arrowDrawable = this.arrowDownDrawable;
            arrowWidth = arrowDrawable.getIntrinsicWidth();
            arrowHeight = arrowDrawable.getIntrinsicHeight();
            xPos = originRect.centerX() - arrowWidth / 2 - this.popoverLayoutRect.left;
            yPos = originRect.top - arrowHeight - this.popoverLayoutRect.top;
        } else if (arrowDirection == 4) {
            arrowDrawable = this.arrowLeftDrawable;
            arrowWidth = arrowDrawable.getIntrinsicWidth();
            arrowHeight = arrowDrawable.getIntrinsicHeight();
            xPos = originRect.right - this.popoverLayoutRect.left;
            yPos = originRect.centerY() - arrowHeight / 2 - this.popoverLayoutRect.top;
        } else if (arrowDirection == 8) {
            arrowDrawable = this.arrowRightDrawable;
            arrowWidth = arrowDrawable.getIntrinsicWidth();
            arrowHeight = arrowDrawable.getIntrinsicHeight();
            xPos = originRect.left - arrowWidth - this.popoverLayoutRect.left;
            yPos = originRect.centerY() - arrowHeight / 2 - this.popoverLayoutRect.top;
        }
        this.arrowImageView.setImageDrawable(arrowDrawable);
        RelativeLayout.LayoutParams arrowParams = new RelativeLayout.LayoutParams(arrowWidth, arrowHeight);
        arrowParams.leftMargin = xPos;
        arrowParams.topMargin = yPos;
        this.addView((View)this.arrowImageView, (ViewGroup.LayoutParams)arrowParams);
    }

    private Rect getRectForArrowUp(Rect originRect) {
        int originX;
        int yAvailable;
        int xAvailable = this.popoverLayoutRect.width();
        if (xAvailable < 0) {
            xAvailable = 0;
        }
        if ((yAvailable = this.popoverLayoutRect.height() - (originRect.bottom - this.popoverLayoutRect.top)) < 0) {
            yAvailable = 0;
        }
        int finalX = xAvailable;
        if (this.realContentSize.x > 0 && this.realContentSize.x < finalX) {
            finalX = this.realContentSize.x;
        }
        int finalY = yAvailable;
        if (this.realContentSize.y > 0 && this.realContentSize.y < finalY) {
            finalY = this.realContentSize.y;
        }
        if ((originX = originRect.centerX() - this.popoverLayoutRect.left - finalX / 2) < 0) {
            originX = 0;
        } else if (originX + finalX > this.popoverLayoutRect.width()) {
            originX = this.popoverLayoutRect.width() - finalX;
        }
        int originY = originRect.bottom - this.popoverLayoutRect.top;
        Rect finalRect = new Rect(originX, originY, originX + finalX, originY + finalY);
        return finalRect;
    }

    private Rect getRectForArrowDown(Rect originRect) {
        int originX;
        int yAvailable;
        int xAvailable = this.popoverLayoutRect.width();
        if (xAvailable < 0) {
            xAvailable = 0;
        }
        if ((yAvailable = originRect.top - this.popoverLayoutRect.top) < 0) {
            yAvailable = 0;
        }
        int finalX = xAvailable;
        if (this.realContentSize.x > 0 && this.realContentSize.x < finalX) {
            finalX = this.realContentSize.x;
        }
        int finalY = yAvailable;
        if (this.realContentSize.y > 0 && this.realContentSize.y < finalY) {
            finalY = this.realContentSize.y;
        }
        if ((originX = originRect.centerX() - this.popoverLayoutRect.left - finalX / 2) < 0) {
            originX = 0;
        } else if (originX + finalX > this.popoverLayoutRect.width()) {
            originX = this.popoverLayoutRect.width() - finalX;
        }
        int originY = originRect.top - this.popoverLayoutRect.top - finalY;
        Rect finalRect = new Rect(originX, originY, originX + finalX, originY + finalY);
        return finalRect;
    }

    private Rect getRectForArrowRight(Rect originRect) {
        int yAvailable;
        int xAvailable = originRect.left - this.popoverLayoutRect.left;
        if (xAvailable < 0) {
            xAvailable = 0;
        }
        if ((yAvailable = this.popoverLayoutRect.height()) < 0) {
            yAvailable = 0;
        }
        int finalX = xAvailable;
        if (this.realContentSize.x > 0 && this.realContentSize.x < finalX) {
            finalX = this.realContentSize.x;
        }
        int finalY = yAvailable;
        if (this.realContentSize.y > 0 && this.realContentSize.y < finalY) {
            finalY = this.realContentSize.y;
        }
        int originX = originRect.left - this.popoverLayoutRect.left - finalX;
        int originY = originRect.centerY() - this.popoverLayoutRect.top - finalY / 2;
        if (originY < 0) {
            originY = 0;
        } else if (originY + finalY > this.popoverLayoutRect.height()) {
            originY = this.popoverLayoutRect.height() - finalY;
        }
        Rect finalRect = new Rect(originX, originY, originX + finalX, originY + finalY);
        return finalRect;
    }

    private Rect getRectForArrowLeft(Rect originRect) {
        int yAvailable;
        int xAvailable = this.popoverLayoutRect.width() - (originRect.right - this.popoverLayoutRect.left);
        if (xAvailable < 0) {
            xAvailable = 0;
        }
        if ((yAvailable = this.popoverLayoutRect.height()) < 0) {
            yAvailable = 0;
        }
        int finalX = xAvailable;
        if (this.realContentSize.x > 0 && this.realContentSize.x < finalX) {
            finalX = this.realContentSize.x;
        }
        int finalY = yAvailable;
        if (this.realContentSize.y > 0 && this.realContentSize.y < finalY) {
            finalY = this.realContentSize.y;
        }
        int originX = originRect.right - this.popoverLayoutRect.left;
        int originY = originRect.centerY() - this.popoverLayoutRect.top - finalY / 2;
        if (originY < 0) {
            originY = 0;
        } else if (originY + finalY > this.popoverLayoutRect.height()) {
            originY = this.popoverLayoutRect.height() - finalY;
        }
        Rect finalRect = new Rect(originX, originY, originX + finalX, originY + finalY);
        return finalRect;
    }

    private void addAvailableRects(Rect originRect, int arrowDirections) {
        this.possibleRects = new HashMap<Integer, Rect>();
        if ((arrowDirections & 1) != 0) {
            this.possibleRects.put(1, this.getRectForArrowUp(originRect));
        }
        if ((arrowDirections & 2) != 0) {
            this.possibleRects.put(2, this.getRectForArrowDown(originRect));
        }
        if ((arrowDirections & 8) != 0) {
            this.possibleRects.put(8, this.getRectForArrowRight(originRect));
        }
        if ((arrowDirections & 4) != 0) {
            this.possibleRects.put(4, this.getRectForArrowLeft(originRect));
        }
    }

    private Integer getBestRect() {
        Integer best = null;
        for (Integer arrowDir : this.possibleRects.keySet()) {
            if (best == null) {
                best = arrowDir;
                continue;
            }
            Rect bestRect = this.possibleRects.get(best);
            Rect checkRect = this.possibleRects.get(arrowDir);
            if (bestRect.width() * bestRect.height() >= checkRect.width() * checkRect.height()) continue;
            best = arrowDir;
        }
        return best;
    }

    public int getFadeAnimationTime() {
        return this.fadeAnimationTime;
    }

    public void setFadeAnimationTime(int fadeAnimationTime) {
        this.fadeAnimationTime = fadeAnimationTime;
    }

    public Point getContentSizeForViewInPopover() {
        return this.contentSizeForViewInPopover;
    }

    public void setContentSizeForViewInPopover(Point contentSizeForViewInPopover) {
        this.contentSizeForViewInPopover = contentSizeForViewInPopover;
        this.realContentSize = new Point(contentSizeForViewInPopover);
        this.realContentSize.x += this.popoverView.getPaddingLeft() + this.popoverView.getPaddingRight();
        this.realContentSize.y += this.popoverView.getPaddingTop() + this.popoverView.getPaddingBottom();
    }

    public PopoverViewListener getPopoverViewListener() {
        return this.popoverViewListener;
    }

    public void setPopoverViewListener(PopoverViewListener popoverViewListener) {
        this.popoverViewListener = popoverViewListener;
    }

    public void showPopoverFromRectInViewGroup(ViewGroup group, Rect originRect, int arrowDirections, boolean animated) {
        if (this.popoverViewListener != null) {
            this.popoverViewListener.popoverViewWillShow(this);
        }
        this.superview = group;
        ViewGroup.LayoutParams insertParams = new ViewGroup.LayoutParams(-1, -1);
        group.addView((View)this, insertParams);
        this.popoverLayoutRect = AbPopoverView.getFrameForView((View)this.superview);
        this.addAvailableRects(originRect, arrowDirections);
        Integer best = this.getBestRect();
        Rect bestRect = this.possibleRects.get(best);
        this.addPopoverInRect(bestRect);
        this.initArrow(originRect, best);
        if (!animated) {
            if (this.popoverViewListener != null) {
                this.popoverViewListener.popoverViewDidShow(this);
            }
        } else if (!this.isAnimating) {
            AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
            animation.setDuration((long)this.fadeAnimationTime);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    AbPopoverView.this.isAnimating = false;
                    if (AbPopoverView.this.popoverViewListener != null) {
                        AbPopoverView.this.popoverViewListener.popoverViewDidShow(AbPopoverView.this);
                    }
                }
            });
            this.isAnimating = true;
            this.startAnimation((Animation)animation);
        }
    }

    public void dissmissPopover(boolean animated) {
        if (this.popoverViewListener != null) {
            this.popoverViewListener.popoverViewWillDismiss(this);
        }
        if (!animated) {
            this.popoverView.removeAllViews();
            this.removeAllViews();
            this.superview.removeView((View)this);
            if (this.popoverViewListener != null) {
                this.popoverViewListener.popoverViewDidDismiss(this);
            }
        } else if (!this.isAnimating) {
            AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
            animation.setDuration((long)this.fadeAnimationTime);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    AbPopoverView.this.popoverView.removeAllViews();
                    AbPopoverView.this.removeAllViews();
                    AbPopoverView.this.superview.removeView((View)AbPopoverView.this);
                    AbPopoverView.this.isAnimating = false;
                    if (AbPopoverView.this.popoverViewListener != null) {
                        AbPopoverView.this.popoverViewListener.popoverViewDidDismiss(AbPopoverView.this);
                    }
                }
            });
            this.isAnimating = true;
            this.startAnimation((Animation)animation);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.isAnimating && v == this) {
            this.dissmissPopover(true);
        }
        return true;
    }

    public Drawable getBackgroundDrawable() {
        return this.backgroundDrawable;
    }

    public void setBackgroundDrawable(Drawable backgroundDrawable) {
        this.backgroundDrawable = backgroundDrawable;
        this.popoverView.setBackgroundDrawable(backgroundDrawable);
    }

    public Drawable getArrowUpDrawable() {
        return this.arrowUpDrawable;
    }

    public void setArrowUpDrawable(Drawable arrowUpDrawable) {
        this.arrowUpDrawable = arrowUpDrawable;
    }

    public Drawable getArrowDownDrawable() {
        return this.arrowDownDrawable;
    }

    public void setArrowDownDrawable(Drawable arrowDownDrawable) {
        this.arrowDownDrawable = arrowDownDrawable;
    }

    public Drawable getArrowLeftDrawable() {
        return this.arrowLeftDrawable;
    }

    public void setArrowLeftDrawable(Drawable arrowLeftDrawable) {
        this.arrowLeftDrawable = arrowLeftDrawable;
    }

    public Drawable getArrowRightDrawable() {
        return this.arrowRightDrawable;
    }

    public void setArrowRightDrawable(Drawable arrowRightDrawable) {
        this.arrowRightDrawable = arrowRightDrawable;
    }

    public View getPopoverContentView() {
        return this.popoverContentView;
    }

    public void setPopoverContentView(View popoverContentView) {
        this.popoverContentView = popoverContentView;
        this.popoverView.removeAllViews();
        this.popoverView.addView(popoverContentView, -1, -1);
    }

    public static interface PopoverViewListener {
        public void popoverViewWillShow(AbPopoverView var1);

        public void popoverViewDidShow(AbPopoverView var1);

        public void popoverViewWillDismiss(AbPopoverView var1);

        public void popoverViewDidDismiss(AbPopoverView var1);
    }
}

