/*
 * Decompiled with CFR 0.152.
 */
package com.ab.http;

import android.os.Handler;
import android.os.Message;

public abstract class AbHttpResponseListener {
    private Handler mHandler;

    public abstract void onStart();

    public abstract void onFinish();

    public void onRetry() {
    }

    public abstract void onFailure(int var1, String var2, Throwable var3);

    public void onProgress(int bytesWritten, int totalSize) {
    }

    public void sendStartMessage() {
        this.sendMessage(this.obtainMessage(4, null));
    }

    public void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(5, null));
    }

    public void sendProgressMessage(int bytesWritten, int totalSize) {
        this.sendMessage(this.obtainMessage(6, new Object[]{bytesWritten, totalSize}));
    }

    public void sendFailureMessage(int statusCode, String content, Throwable error) {
        this.sendMessage(this.obtainMessage(1, new Object[]{statusCode, content, error}));
    }

    public void sendRetryMessage() {
        this.sendMessage(this.obtainMessage(7, null));
    }

    public void sendMessage(Message msg) {
        if (msg != null) {
            msg.sendToTarget();
        }
    }

    protected Message obtainMessage(int responseMessage, Object response) {
        Message msg;
        if (this.mHandler != null) {
            msg = this.mHandler.obtainMessage(responseMessage, response);
        } else {
            msg = Message.obtain();
            if (msg != null) {
                msg.what = responseMessage;
                msg.obj = response;
            }
        }
        return msg;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }
}

