/*
 * Decompiled with CFR 0.152.
 */
package com.ab.download;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ab.db.AbBasicDBDao;
import com.ab.db.MyDBHelper;
import com.ab.download.DownFile;

public class DownFileDao
extends AbBasicDBDao {
    private MyDBHelper openHelper;
    public static Context mContext = null;
    public static DownFileDao mDownFileDao = null;

    public DownFileDao(Context context) {
        this.openHelper = new MyDBHelper(context);
    }

    public static DownFileDao getInstance(Context context) {
        mContext = context;
        if (mDownFileDao == null) {
            mDownFileDao = new DownFileDao(context);
        }
        return mDownFileDao;
    }

    public DownFile getDownFile(String path) {
        SQLiteDatabase db = null;
        Cursor cursor = null;
        DownFile mDownFile = null;
        try {
            try {
                db = this.openHelper.getReadableDatabase();
                String where = "DOWNURL = ?";
                String[] whereValue = new String[]{path};
                cursor = db.query("FILEDOWN", null, where, whereValue, null, null, null);
                if (cursor.moveToFirst()) {
                    mDownFile = new DownFile();
                    mDownFile.set_ID(this.getIntColumnValue("_ID", cursor));
                    mDownFile.setName(this.getStringColumnValue("NAME", cursor));
                    mDownFile.setDescription(this.getStringColumnValue("DESCRIPTION", cursor));
                    mDownFile.setPakageName(this.getStringColumnValue("PAKAGENAME", cursor));
                    mDownFile.setDownUrl(this.getStringColumnValue("DOWNURL", cursor));
                    mDownFile.setDownPath(this.getStringColumnValue("DOWNPATH", cursor));
                    mDownFile.setState(this.getIntColumnValue("STATE", cursor));
                    mDownFile.setDownLength(this.getIntColumnValue("DOWNLENGTH", cursor));
                    mDownFile.setTotalLength(this.getIntColumnValue("TOTALLENGTH", cursor));
                    mDownFile.setSuffix(this.getStringColumnValue("DOWNSUFFIX", cursor));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeDatabase(cursor, db);
                return null;
            }
        }
        catch (Throwable throwable) {
            this.closeDatabase(cursor, db);
            throw throwable;
        }
        this.closeDatabase(cursor, db);
        return mDownFile;
    }

    public synchronized long save(DownFile mDownFile) {
        SQLiteDatabase db = null;
        long row = 0L;
        try {
            try {
                db = this.openHelper.getWritableDatabase();
                ContentValues cv = new ContentValues();
                cv.put("NAME", mDownFile.getName());
                cv.put("DESCRIPTION", mDownFile.getDescription());
                cv.put("PAKAGENAME", mDownFile.getPakageName());
                cv.put("DOWNURL", mDownFile.getDownUrl());
                cv.put("DOWNPATH", mDownFile.getDownPath());
                cv.put("STATE", Integer.valueOf(mDownFile.getState()));
                cv.put("DOWNLENGTH", Long.valueOf(mDownFile.getDownLength()));
                cv.put("TOTALLENGTH", Long.valueOf(mDownFile.getTotalLength()));
                cv.put("DOWNSUFFIX", mDownFile.getSuffix());
                row = db.insert("FILEDOWN", null, cv);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeDatabase(null, db);
            }
        }
        finally {
            this.closeDatabase(null, db);
        }
        return row;
    }

    public synchronized long update(DownFile mDownFile) {
        long row = -1L;
        SQLiteDatabase db = null;
        try {
            try {
                db = this.openHelper.getWritableDatabase();
                String where = "DOWNURL = ? ";
                String[] whereValue = new String[]{mDownFile.getDownUrl()};
                ContentValues cv = new ContentValues();
                cv.put("STATE", Integer.valueOf(mDownFile.getState()));
                cv.put("DOWNLENGTH", Long.valueOf(mDownFile.getDownLength()));
                cv.put("TOTALLENGTH", Long.valueOf(mDownFile.getTotalLength()));
                row = db.update("FILEDOWN", cv, where, whereValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeDatabase(null, db);
            }
        }
        finally {
            this.closeDatabase(null, db);
        }
        return row;
    }

    public synchronized long delete(String path) {
        long row = -1L;
        SQLiteDatabase db = null;
        try {
            try {
                db = this.openHelper.getWritableDatabase();
                String where = "DOWNURL = ? ";
                String[] whereValue = new String[]{path};
                row = db.delete("FILEDOWN", where, whereValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.closeDatabase(null, db);
            }
        }
        finally {
            this.closeDatabase(null, db);
        }
        return row;
    }
}

