/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.opencv.android.CameraBridgeViewBase;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

@TargetApi(value=21)
public class JavaCamera2View
extends CameraBridgeViewBase {
    private static final String LOGTAG = "JavaCamera2View";
    protected ImageReader mImageReader;
    protected int mPreviewFormat = 35;
    protected CameraDevice mCameraDevice;
    protected CameraCaptureSession mCaptureSession;
    protected CaptureRequest.Builder mPreviewRequestBuilder;
    protected String mCameraID;
    protected android.util.Size mPreviewSize = new android.util.Size(-1, -1);
    private HandlerThread mBackgroundThread;
    protected Handler mBackgroundHandler;
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            JavaCamera2View.this.mCameraDevice = cameraDevice;
            JavaCamera2View.this.createCameraPreviewSession();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            JavaCamera2View.this.mCameraDevice = null;
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            JavaCamera2View.this.mCameraDevice = null;
        }
    };

    public JavaCamera2View(Context context, int cameraId) {
        super(context, cameraId);
    }

    public JavaCamera2View(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private void startBackgroundThread() {
        Log.i((String)LOGTAG, (String)"startBackgroundThread");
        this.stopBackgroundThread();
        this.mBackgroundThread = new HandlerThread("OpenCVCameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        Log.i((String)LOGTAG, (String)"stopBackgroundThread");
        if (this.mBackgroundThread == null) {
            return;
        }
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"stopBackgroundThread", (Throwable)e);
        }
    }

    protected boolean initializeCamera() {
        Log.i((String)LOGTAG, (String)"initializeCamera");
        CameraManager manager = (CameraManager)this.getContext().getSystemService("camera");
        try {
            String[] camList = manager.getCameraIdList();
            if (camList.length == 0) {
                Log.e((String)LOGTAG, (String)"Error: camera isn't detected.");
                return false;
            }
            if (this.mCameraIndex == -1) {
                this.mCameraID = camList[0];
            } else {
                for (String cameraID : camList) {
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraID);
                    if ((this.mCameraIndex != 99 || (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != 1) && (this.mCameraIndex != 98 || (Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != 0)) continue;
                    this.mCameraID = cameraID;
                    break;
                }
            }
            if (this.mCameraID != null) {
                Log.i((String)LOGTAG, (String)("Opening camera: " + this.mCameraID));
                manager.openCamera(this.mCameraID, this.mStateCallback, this.mBackgroundHandler);
            } else {
                Log.i((String)LOGTAG, (String)("Trying to open camera with the value (" + this.mCameraIndex + ")"));
                if (this.mCameraIndex < camList.length) {
                    this.mCameraID = camList[this.mCameraIndex];
                    manager.openCamera(this.mCameraID, this.mStateCallback, this.mBackgroundHandler);
                } else {
                    throw new CameraAccessException(2);
                }
            }
            return true;
        }
        catch (CameraAccessException e) {
            Log.e((String)LOGTAG, (String)"OpenCamera - Camera Access Exception", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOGTAG, (String)"OpenCamera - Illegal Argument Exception", (Throwable)e);
        }
        catch (SecurityException e) {
            Log.e((String)LOGTAG, (String)"OpenCamera - Security Exception", (Throwable)e);
        }
        return false;
    }

    private void createCameraPreviewSession() {
        int w = this.mPreviewSize.getWidth();
        int h = this.mPreviewSize.getHeight();
        Log.i((String)LOGTAG, (String)("createCameraPreviewSession(" + w + "x" + h + ")"));
        if (w < 0 || h < 0) {
            return;
        }
        try {
            if (null == this.mCameraDevice) {
                Log.e((String)LOGTAG, (String)"createCameraPreviewSession: camera isn't opened");
                return;
            }
            if (null != this.mCaptureSession) {
                Log.e((String)LOGTAG, (String)"createCameraPreviewSession: mCaptureSession is already started");
                return;
            }
            this.mImageReader = ImageReader.newInstance((int)w, (int)h, (int)this.mPreviewFormat, (int)2);
            this.mImageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){

                public void onImageAvailable(ImageReader reader) {
                    Image image = reader.acquireLatestImage();
                    if (image == null) {
                        return;
                    }
                    Image.Plane[] planes = image.getPlanes();
                    assert (planes.length == 3);
                    assert (image.getFormat() == JavaCamera2View.this.mPreviewFormat);
                    JavaCamera2Frame tempFrame = new JavaCamera2Frame(image);
                    JavaCamera2View.this.deliverAndDrawFrame(tempFrame);
                    tempFrame.release();
                    image.close();
                }
            }, this.mBackgroundHandler);
            Surface surface = this.mImageReader.getSurface();
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            this.mCameraDevice.createCaptureSession(Arrays.asList(surface), new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    Log.i((String)JavaCamera2View.LOGTAG, (String)"createCaptureSession::onConfigured");
                    if (null == JavaCamera2View.this.mCameraDevice) {
                        return;
                    }
                    JavaCamera2View.this.mCaptureSession = cameraCaptureSession;
                    try {
                        JavaCamera2View.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        JavaCamera2View.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                        JavaCamera2View.this.mCaptureSession.setRepeatingRequest(JavaCamera2View.this.mPreviewRequestBuilder.build(), null, JavaCamera2View.this.mBackgroundHandler);
                        Log.i((String)JavaCamera2View.LOGTAG, (String)"CameraPreviewSession has been started");
                    }
                    catch (Exception e) {
                        Log.e((String)JavaCamera2View.LOGTAG, (String)"createCaptureSession failed", (Throwable)e);
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    Log.e((String)JavaCamera2View.LOGTAG, (String)"createCameraPreviewSession failed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            Log.e((String)LOGTAG, (String)"createCameraPreviewSession", (Throwable)e);
        }
    }

    @Override
    protected void disconnectCamera() {
        Log.i((String)LOGTAG, (String)"close camera");
        try {
            CameraDevice c = this.mCameraDevice;
            this.mCameraDevice = null;
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != c) {
                c.close();
            }
        }
        finally {
            this.stopBackgroundThread();
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        Log.i((String)LOGTAG, (String)"camera closed!");
    }

    boolean calcPreviewSize(int width, int height) {
        Log.i((String)LOGTAG, (String)("calcPreviewSize: " + width + "x" + height));
        if (this.mCameraID == null) {
            Log.e((String)LOGTAG, (String)"Camera isn't initialized!");
            return false;
        }
        CameraManager manager = (CameraManager)this.getContext().getSystemService("camera");
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.mCameraID);
            StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            android.util.Size[] sizes = map.getOutputSizes(ImageReader.class);
            List<android.util.Size> sizes_list = Arrays.asList(sizes);
            Size frameSize = this.calculateCameraFrameSize(sizes_list, new JavaCameraSizeAccessor(), width, height);
            Log.i((String)LOGTAG, (String)("Selected preview size to " + Integer.valueOf((int)frameSize.width) + "x" + Integer.valueOf((int)frameSize.height)));
            assert (frameSize.width != 0.0 && frameSize.height != 0.0);
            if ((double)this.mPreviewSize.getWidth() == frameSize.width && (double)this.mPreviewSize.getHeight() == frameSize.height) {
                return false;
            }
            this.mPreviewSize = new android.util.Size((int)frameSize.width, (int)frameSize.height);
            return true;
        }
        catch (CameraAccessException e) {
            Log.e((String)LOGTAG, (String)"calcPreviewSize - Camera Access Exception", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)LOGTAG, (String)"calcPreviewSize - Illegal Argument Exception", (Throwable)e);
        }
        catch (SecurityException e) {
            Log.e((String)LOGTAG, (String)"calcPreviewSize - Security Exception", (Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean connectCamera(int width, int height) {
        Log.i((String)LOGTAG, (String)("setCameraPreviewSize(" + width + "x" + height + ")"));
        this.startBackgroundThread();
        this.initializeCamera();
        try {
            boolean needReconfig = this.calcPreviewSize(width, height);
            this.mFrameWidth = this.mPreviewSize.getWidth();
            this.mFrameHeight = this.mPreviewSize.getHeight();
            this.mScale = this.getLayoutParams().width == -1 && this.getLayoutParams().height == -1 ? Math.min((float)height / (float)this.mFrameHeight, (float)width / (float)this.mFrameWidth) : 0.0f;
            this.AllocateCache();
            if (needReconfig) {
                if (null != this.mCaptureSession) {
                    Log.d((String)LOGTAG, (String)"closing existing previewSession");
                    this.mCaptureSession.close();
                    this.mCaptureSession = null;
                }
                this.createCameraPreviewSession();
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Interrupted while setCameraPreviewSize.", e);
        }
        return true;
    }

    private class JavaCamera2Frame
    implements CameraBridgeViewBase.CvCameraViewFrame {
        private Image mImage;
        private Mat mRgba;
        private Mat mGray;

        @Override
        public Mat gray() {
            Image.Plane[] planes = this.mImage.getPlanes();
            int w = this.mImage.getWidth();
            int h = this.mImage.getHeight();
            assert (planes[0].getPixelStride() == 1);
            ByteBuffer y_plane = planes[0].getBuffer();
            int y_plane_step = planes[0].getRowStride();
            this.mGray = new Mat(h, w, CvType.CV_8UC1, y_plane, y_plane_step);
            return this.mGray;
        }

        @Override
        public Mat rgba() {
            Image.Plane[] planes = this.mImage.getPlanes();
            int w = this.mImage.getWidth();
            int h = this.mImage.getHeight();
            int chromaPixelStride = planes[1].getPixelStride();
            if (chromaPixelStride == 2) {
                assert (planes[0].getPixelStride() == 1);
                assert (planes[2].getPixelStride() == 2);
                ByteBuffer y_plane = planes[0].getBuffer();
                int y_plane_step = planes[0].getRowStride();
                ByteBuffer uv_plane1 = planes[1].getBuffer();
                int uv_plane1_step = planes[1].getRowStride();
                ByteBuffer uv_plane2 = planes[2].getBuffer();
                int uv_plane2_step = planes[2].getRowStride();
                Mat y_mat = new Mat(h, w, CvType.CV_8UC1, y_plane, y_plane_step);
                Mat uv_mat1 = new Mat(h / 2, w / 2, CvType.CV_8UC2, uv_plane1, uv_plane1_step);
                Mat uv_mat2 = new Mat(h / 2, w / 2, CvType.CV_8UC2, uv_plane2, uv_plane2_step);
                long addr_diff = uv_mat2.dataAddr() - uv_mat1.dataAddr();
                if (addr_diff > 0L) {
                    assert (addr_diff == 1L);
                    Imgproc.cvtColorTwoPlane(y_mat, uv_mat1, this.mRgba, 94);
                } else {
                    assert (addr_diff == -1L);
                    Imgproc.cvtColorTwoPlane(y_mat, uv_mat2, this.mRgba, 96);
                }
                return this.mRgba;
            }
            byte[] yuv_bytes = new byte[w * (h + h / 2)];
            ByteBuffer y_plane = planes[0].getBuffer();
            ByteBuffer u_plane = planes[1].getBuffer();
            ByteBuffer v_plane = planes[2].getBuffer();
            int yuv_bytes_offset = 0;
            int y_plane_step = planes[0].getRowStride();
            if (y_plane_step == w) {
                y_plane.get(yuv_bytes, 0, w * h);
                yuv_bytes_offset = w * h;
            } else {
                int padding = y_plane_step - w;
                for (int i = 0; i < h; ++i) {
                    y_plane.get(yuv_bytes, yuv_bytes_offset, w);
                    yuv_bytes_offset += w;
                    if (i >= h - 1) continue;
                    y_plane.position(y_plane.position() + padding);
                }
                assert (yuv_bytes_offset == w * h);
            }
            int chromaRowStride = planes[1].getRowStride();
            int chromaRowPadding = chromaRowStride - w / 2;
            if (chromaRowPadding == 0) {
                u_plane.get(yuv_bytes, yuv_bytes_offset, w * h / 4);
                v_plane.get(yuv_bytes, yuv_bytes_offset += w * h / 4, w * h / 4);
            } else {
                int i;
                for (i = 0; i < h / 2; ++i) {
                    u_plane.get(yuv_bytes, yuv_bytes_offset, w / 2);
                    yuv_bytes_offset += w / 2;
                    if (i >= h / 2 - 1) continue;
                    u_plane.position(u_plane.position() + chromaRowPadding);
                }
                for (i = 0; i < h / 2; ++i) {
                    v_plane.get(yuv_bytes, yuv_bytes_offset, w / 2);
                    yuv_bytes_offset += w / 2;
                    if (i >= h / 2 - 1) continue;
                    v_plane.position(v_plane.position() + chromaRowPadding);
                }
            }
            Mat yuv_mat = new Mat(h + h / 2, w, CvType.CV_8UC1);
            yuv_mat.put(0, 0, yuv_bytes);
            Imgproc.cvtColor(yuv_mat, this.mRgba, 104, 4);
            return this.mRgba;
        }

        public JavaCamera2Frame(Image image) {
            this.mImage = image;
            this.mRgba = new Mat();
            this.mGray = new Mat();
        }

        public void release() {
            this.mRgba.release();
            this.mGray.release();
        }
    }

    public static class JavaCameraSizeAccessor
    implements CameraBridgeViewBase.ListItemAccessor {
        @Override
        public int getWidth(Object obj) {
            android.util.Size size = (android.util.Size)obj;
            return size.getWidth();
        }

        @Override
        public int getHeight(Object obj) {
            android.util.Size size = (android.util.Size)obj;
            return size.getHeight();
        }
    }
}

