/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.msg;

import com.zgkxzx.modbus4And.ProcessImage;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.msg.ReadHoldingRegistersResponse;
import com.zgkxzx.modbus4And.msg.ReadNumericRequest;

public class ReadHoldingRegistersRequest
extends ReadNumericRequest {
    public ReadHoldingRegistersRequest(int slaveId, int startOffset, int numberOfRegisters) throws ModbusTransportException {
        super(slaveId, startOffset, numberOfRegisters);
    }

    ReadHoldingRegistersRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    @Override
    public byte getFunctionCode() {
        return 3;
    }

    @Override
    ModbusResponse handleImpl(ProcessImage processImage) throws ModbusTransportException {
        return new ReadHoldingRegistersResponse(this.slaveId, this.getData(processImage));
    }

    @Override
    protected short getNumeric(ProcessImage processImage, int index) throws ModbusTransportException {
        return processImage.getHoldingRegister(index);
    }

    @Override
    ModbusResponse getResponseInstance(int slaveId) throws ModbusTransportException {
        return new ReadHoldingRegistersResponse(slaveId);
    }

    @Override
    public String toString() {
        return "ReadHoldingRegistersRequest [slaveId=" + this.slaveId + ", getFunctionCode()=" + this.getFunctionCode() + ", toString()=" + super.toString() + "]";
    }
}

