/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And;

import com.zgkxzx.modbus4And.ModbusMaster;
import com.zgkxzx.modbus4And.ModbusSlaveSet;
import com.zgkxzx.modbus4And.base.ModbusUtils;
import com.zgkxzx.modbus4And.exception.ModbusIdException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.ip.IpParameters;
import com.zgkxzx.modbus4And.ip.listener.TcpListener;
import com.zgkxzx.modbus4And.ip.tcp.TcpMaster;
import com.zgkxzx.modbus4And.ip.tcp.TcpSlave;
import com.zgkxzx.modbus4And.ip.udp.UdpMaster;
import com.zgkxzx.modbus4And.ip.udp.UdpSlave;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ReadCoilsRequest;
import com.zgkxzx.modbus4And.msg.ReadDiscreteInputsRequest;
import com.zgkxzx.modbus4And.msg.ReadHoldingRegistersRequest;
import com.zgkxzx.modbus4And.msg.ReadInputRegistersRequest;
import com.zgkxzx.modbus4And.serial.SerialPortWrapper;
import com.zgkxzx.modbus4And.serial.ascii.AsciiMaster;
import com.zgkxzx.modbus4And.serial.ascii.AsciiSlave;
import com.zgkxzx.modbus4And.serial.rtu.RtuMaster;
import com.zgkxzx.modbus4And.serial.rtu.RtuSlave;

public class ModbusFactory {
    public ModbusMaster createRtuMaster(SerialPortWrapper wrapper) {
        return new RtuMaster(wrapper);
    }

    public ModbusMaster createRtuMaster(SerialPortWrapper wrapper, long characterSpacingNs, long messageFrameSpacingNs) {
        return new RtuMaster(wrapper, characterSpacingNs, messageFrameSpacingNs);
    }

    public ModbusMaster createAsciiMaster(SerialPortWrapper wrapper) {
        return new AsciiMaster(wrapper);
    }

    public ModbusMaster createTcpMaster(IpParameters params, boolean keepAlive) {
        return new TcpMaster(params, keepAlive);
    }

    public ModbusMaster createUdpMaster(IpParameters params) {
        return new UdpMaster(params);
    }

    public ModbusMaster createTcpListener(IpParameters params) {
        return new TcpListener(params);
    }

    public ModbusSlaveSet createRtuSlave(SerialPortWrapper wrapper) {
        return new RtuSlave(wrapper);
    }

    public ModbusSlaveSet createAsciiSlave(SerialPortWrapper wrapper) {
        return new AsciiSlave(wrapper);
    }

    public ModbusSlaveSet createTcpSlave(boolean encapsulated) {
        return new TcpSlave(encapsulated);
    }

    public ModbusSlaveSet createUdpSlave(boolean encapsulated) {
        return new UdpSlave(encapsulated);
    }

    public ModbusRequest createReadRequest(int slaveId, int range, int offset, int length) throws ModbusTransportException, ModbusIdException {
        ModbusUtils.validateRegisterRange(range);
        if (range == 1) {
            return new ReadCoilsRequest(slaveId, offset, length);
        }
        if (range == 2) {
            return new ReadDiscreteInputsRequest(slaveId, offset, length);
        }
        if (range == 4) {
            return new ReadInputRegistersRequest(slaveId, offset, length);
        }
        return new ReadHoldingRegistersRequest(slaveId, offset, length);
    }
}

