/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facesdk;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.os.Environment;
import android.util.Log;
import com.baidu.idl.face.authority.AlgorithmOnMainThreadException;
import com.baidu.idl.face.authority.IDLAuthorityException;
import com.baidu.idl.face.license.License;
import com.baidu.idl.face.statistics.Statistics;
import com.baidu.idl.face.util.UIThread;
import com.baidu.idl.facesdk.FaceInfo;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class FaceSDK {
    private static String mApiKey;
    private static int mAuthorityStatus;
    private static final String tag = "FaceSDK";
    private static String sdm_alignmodel_path;
    private static String sdm_7pts_model_path;
    private static String sdm_15pts_model_path;
    private static String cdnn_alignmodel_path;
    private static String cdnn_alignmean_path;
    private static String cdnn_parsingmodel_path1;
    private static String cdnn_parsingparam_path1;
    private static String cdnn_parsingmodel_path2;
    private static String cdnn_parsingparam_path2;
    private static String blur_model;
    private static String occlusion_model;
    private static FaceSDK mInstance;

    static {
        mAuthorityStatus = 256;
        sdm_alignmodel_path = "facialLandmarksModel2.bin";
        sdm_7pts_model_path = "7pts.bin";
        sdm_15pts_model_path = "15pts.bin";
        cdnn_alignmodel_path = "align_model.binary";
        cdnn_alignmean_path = "";
        cdnn_parsingmodel_path1 = "3_class_model";
        cdnn_parsingparam_path1 = "";
        cdnn_parsingmodel_path2 = "7_class_model";
        cdnn_parsingparam_path2 = "";
        blur_model = "blur.binary";
        occlusion_model = "occlu.binary";
    }

    public static boolean copyFileFromAssets(Context context, String fileName, String path) {
        boolean copyIsFinish = false;
        try {
            InputStream is = context.getAssets().open(fileName);
            File file = new File(path);
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = is.read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            is.close();
            copyIsFinish = true;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.e((String)tag, (String)("[copyFileFromAssets] IOException " + e.toString()));
        }
        return copyIsFinish;
    }

    public static synchronized void getInstance(AssetManager asset, final Context context, final String apiKey, final String token, AlignMethodType alignMethodType, ParsMethodType parsing_method_type) {
        File dir = context.getDir("FaceSDKLibs", 0);
        File face_sdk_lib = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + "libFaceSDK.so");
        File face_sdk_license_lib = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + "libidl_face_license.so");
        if (face_sdk_lib.exists() && face_sdk_license_lib.exists()) {
            Log.e((String)tag, (String)"Load lib from private space...");
            System.load(face_sdk_license_lib.getAbsolutePath());
            System.load(face_sdk_lib.getAbsolutePath());
            Log.e((String)tag, (String)"Load lib from app private space succeed!");
        } else {
            Log.e((String)tag, (String)"Load lib from default space!");
            System.loadLibrary("idl_face_license");
            Log.e((String)tag, (String)"Load lib  idl_face_license succeed!");
            System.loadLibrary(tag);
            Log.e((String)tag, (String)"Load lib  FaceSDK succeed!");
        }
        if (mAuthorityStatus > 48) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (token != null && token.length() > 0) {
                            Log.e((String)FaceSDK.tag, (String)"init via token!");
                            FaceSDK.init(context, apiKey, token);
                        } else {
                            Log.e((String)FaceSDK.tag, (String)"init via license!");
                            FaceSDK.init(context, apiKey);
                        }
                    }
                    catch (AlgorithmOnMainThreadException e) {
                        e.printStackTrace();
                    }
                    catch (IDLAuthorityException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        if (mInstance == null) {
            mInstance = new FaceSDK();
        }
        if (alignMethodType == AlignMethodType.SDM) {
            FaceSDK.AlignModelInit(asset, sdm_alignmodel_path, "", AlignMethodType.SDM.ordinal());
        } else if (alignMethodType == AlignMethodType.CDNN) {
            FaceSDK.AlignModelInit(asset, cdnn_alignmodel_path, cdnn_alignmean_path, AlignMethodType.CDNN.ordinal());
        } else if (alignMethodType == AlignMethodType.SDM_7PTS) {
            FaceSDK.AlignModelInit(asset, sdm_7pts_model_path, "", AlignMethodType.SDM_7PTS.ordinal());
        } else if (alignMethodType == AlignMethodType.SDM_15PTS) {
            FaceSDK.AlignModelInit(asset, sdm_15pts_model_path, "", AlignMethodType.SDM_15PTS.ordinal());
        }
        if (parsing_method_type == ParsMethodType.CLASS_NUM_3) {
            FaceSDK.ParsingModelInit(asset, cdnn_parsingmodel_path1, cdnn_parsingparam_path1, ParsMethodType.CLASS_NUM_3.ordinal());
        } else if (parsing_method_type == ParsMethodType.CLASS_NUM_7) {
            FaceSDK.ParsingModelInit(asset, cdnn_parsingmodel_path2, cdnn_parsingparam_path2, ParsMethodType.CLASS_NUM_7.ordinal());
        } else if (parsing_method_type == ParsMethodType.CLASS_NUM_10) {
            FaceSDK.ParsingModelInit(asset, cdnn_parsingmodel_path1, cdnn_parsingparam_path1, ParsMethodType.CLASS_NUM_3.ordinal());
            FaceSDK.ParsingModelInit(asset, cdnn_parsingmodel_path2, cdnn_parsingparam_path2, ParsMethodType.CLASS_NUM_7.ordinal());
        }
        FaceSDK.imgQualityModelInit(asset, blur_model, "", QualityModelType.QUALITY_BLUR.ordinal());
        FaceSDK.imgQualityModelInit(asset, occlusion_model, "", QualityModelType.QUALITY_OCCLUSION.ordinal());
        int numOfCpuCore = FaceSDK.getNumCores();
        int numOfThreads = numOfCpuCore > 1 ? numOfCpuCore / 2 : 1;
        FaceSDK.setNumberOfThreads(numOfThreads);
    }

    public static synchronized int init(Context context, String apikey) throws AlgorithmOnMainThreadException, IDLAuthorityException {
        if (UIThread.isUITread()) {
            throw new AlgorithmOnMainThreadException();
        }
        mApiKey = apikey;
        mAuthorityStatus = License.getInstance().init(context, mApiKey);
        return mAuthorityStatus;
    }

    public static synchronized int init(Context context, String apikey, String token) throws AlgorithmOnMainThreadException, IDLAuthorityException {
        if (UIThread.isUITread()) {
            throw new AlgorithmOnMainThreadException();
        }
        mApiKey = apikey;
        mAuthorityStatus = License.getInstance().init(token);
        return mAuthorityStatus;
    }

    public static boolean isAuthoritySucceeded() {
        return mAuthorityStatus < 48;
    }

    private static native int AlignModelInit(AssetManager var0, String var1, String var2, int var3);

    private static native int ParsingModelInit(AssetManager var0, String var1, String var2, int var3);

    private static native int imgQualityModelInit(AssetManager var0, String var1, String var2, int var3);

    public static native int setNumberOfThreads(int var0);

    private static native FaceInfo[] detect(int[] var0, int var1, int var2, int var3, int var4, int var5);

    private static native int align(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int[] var6, int[] var7, float[] var8);

    private static native int fineAlign(int[] var0, int var1, int var2, int var3, int[] var4, int[] var5);

    private static native int tracking(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int[] var6, float[] var7);

    private static native int liveness(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int[] var6, int var7, int[] var8);

    private static native int parsing(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int var6, byte[] var7);

    private static native int HeadPoseEstimation(int[] var0, int var1, double[] var2);

    private static native int CropFaceImg(int[] var0, int var1, int var2, int var3, int[] var4, int var5, int var6, int var7, int[] var8, int[] var9);

    private static native int imgQuality(int[] var0, int var1, int var2, int var3, int[] var4, int var5, float[] var6, int[] var7, float[] var8, int[] var9);

    public static native int getARGBFromYUVimg(byte[] var0, int[] var1, int var2, int var3, int var4, int var5);

    public static FaceInfo[] run_detect(int[] Img, int rows, int cols, ImgType imgType, DetectMethodType methodType, int min_face_size) {
        if (mAuthorityStatus > 48) {
            Log.i((String)"FaceSDK: ", (String)"You need to apply for the authorization for using the facesdk");
            throw new IDLAuthorityException();
        }
        FaceInfo[] info = FaceSDK.detect(Img, rows, cols, imgType.ordinal(), methodType.ordinal(), min_face_size);
        Statistics.getInstance().triggerEvent("face_detection");
        return info;
    }

    public static int run_align(int[] Img, int rows, int cols, ImgType imgType, AlignMethodType methodType, int[] face, int[] shape, int[] nPoint, float[] score) {
        if (mAuthorityStatus > 48) {
            throw new IDLAuthorityException();
        }
        int result = FaceSDK.align(Img, rows, cols, imgType.ordinal(), methodType.ordinal(), face, shape, nPoint, score);
        Statistics.getInstance().triggerEvent("face_alignment");
        return result;
    }

    public static int run_fineAlign(int[] Img, int rows, int cols, ImgType imgType, int[] shape, int[] nPoint) {
        if (mAuthorityStatus > 48) {
            throw new IDLAuthorityException();
        }
        int result = FaceSDK.fineAlign(Img, rows, cols, imgType.ordinal(), shape, nPoint);
        Statistics.getInstance().triggerEvent("face_alignment");
        return result;
    }

    public static int run_tracking(int[] Img, int rows, int cols, ImgType imgType, AlignMethodType methodType, int[] shape, int[] nPoint, float[] score) {
        if (mAuthorityStatus > 48) {
            throw new IDLAuthorityException();
        }
        int result = FaceSDK.tracking(Img, rows, cols, imgType.ordinal(), methodType.ordinal(), shape, nPoint, score);
        Statistics.getInstance().triggerEvent("face_tracking");
        return result;
    }

    public static int run_liveness(int[] Img, int rows, int cols, ImgType imgType, LivenessMethodType methodType, int[] shape, int[] nPoint, LivenessAction flag, int[] status) {
        if (mAuthorityStatus > 48) {
            throw new IDLAuthorityException();
        }
        int result = FaceSDK.liveness(Img, rows, cols, imgType.ordinal(), methodType.ordinal(), shape, nPoint, flag.ordinal(), status);
        Statistics.getInstance().triggerEvent("face_liveness");
        return result;
    }

    public static int run_parsing(int[] Img, int rows, int cols, ImgType imgType, ParsMethodType methodType, int[] shape, int nPoint, byte[] classMap) {
        if (mAuthorityStatus > 48) {
            throw new IDLAuthorityException();
        }
        int result = FaceSDK.parsing(Img, rows, cols, imgType.ordinal(), methodType.ordinal(), shape, nPoint, classMap);
        Statistics.getInstance().triggerEvent("face_parsing");
        return result;
    }

    public static void run_HeadPoseEstimation(int[] shape, int rows, int cols, int[] nPoint, double[] pose) throws AlgorithmOnMainThreadException, IDLAuthorityException {
        if (mAuthorityStatus > 48) {
            throw new IDLAuthorityException();
        }
        FaceSDK.HeadPoseEstimation(shape, nPoint[0], pose);
        Statistics.getInstance().triggerEvent("headpose_estimation");
    }

    public static int run_CropFaceImg(int[] Img, int rows, int cols, ImgType imgType, int[] shape, int nPoint, int face_rows, int face_cols, int[] face_img, int[] face_shape) {
        if (mAuthorityStatus > 48) {
            throw new IDLAuthorityException();
        }
        int result = FaceSDK.CropFaceImg(Img, rows, cols, imgType.ordinal(), shape, nPoint, face_rows, face_cols, face_img, face_shape);
        Statistics.getInstance().triggerEvent("face_CropFaceImg");
        return result;
    }

    public static void savePic(Bitmap b) {
        FileOutputStream fos = null;
        try {
            Log.e((String)tag, (String)"start savePic");
            File root = Environment.getExternalStorageDirectory();
            File dir = new File(String.valueOf(root.getAbsolutePath()) + "/awe/");
            Log.i((String)"sdcard_dir=", (String)(String.valueOf(root.getAbsolutePath()) + "/awe/"));
            dir.mkdirs();
            String file = String.format("%d.png", System.currentTimeMillis());
            File f = new File(dir, file);
            if (f.exists()) {
                f.delete();
            }
            fos = new FileOutputStream(f);
            Log.e((String)tag, (String)("strFileName 1= " + f.getPath()));
            if (fos != null) {
                b.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                fos.flush();
                fos.close();
                Log.i((String)tag, (String)"save pic OK!");
            }
        }
        catch (FileNotFoundException e) {
            Log.i((String)tag, (String)"FileNotFoundException");
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.i((String)tag, (String)"IOException");
            e.printStackTrace();
        }
    }

    private static int getNumCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]+", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            return files.length;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static enum AlignMethodType {
        SDM,
        CDNN,
        SDM_7PTS,
        SDM_15PTS;

    }

    public static enum DetectMethodType {
        BOOST;

    }

    public static enum ImgType {
        ARGB;

    }

    public static enum LivenessAction {
        RESET,
        ADD_ONE_FRAME;

    }

    public static enum LivenessMethodType {
        EYE_BLINK,
        MOUTH_MOTION,
        HEAD_POSE,
        ALL;

    }

    public static enum ParsMethodType {
        NOT_USE,
        CLASS_NUM_3,
        CLASS_NUM_7,
        CLASS_NUM_10;

    }

    public static enum QualityModelType {
        QUALITY_NOT_USE,
        QUALITY_BLUR,
        QUALITY_OCCLUSION;

    }
}

