/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ai.edge.core.base;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.baidu.ai.edge.core.base.BaseException;
import com.baidu.ai.edge.core.base.CallException;
import com.baidu.ai.edge.core.base.IBaseConfig;
import com.baidu.ai.edge.core.base.JniParam;
import com.baidu.ai.edge.core.ddk.DDKJni;
import com.baidu.ai.edge.core.ddk.DavinciJni;
import com.baidu.ai.edge.core.infer.InferLiteJni;
import com.baidu.ai.edge.core.snpe.SnpeJni;
import com.baidu.ai.edge.core.util.HttpUtil;
import com.baidu.ai.edge.core.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public final class ActivateManager {
    public static final int JNILIB_TYPE_ARM = 100;
    public static final int JNILIB_TYPE_SNPE = 101;
    public static final int JNILIB_TYPE_DDK = 102;
    public static final int JNILIB_TYPE_XEYE = 103;
    public static final int JNILIB_TYPE_DAVINCI = 104;
    private static final String URL_DEVICE_ACTIVATE = "/offline-auth/v2/key/activate/edge";
    private static final String URL_GENERATE_KEY = "/instance-auth/v1/key/generate";
    private static final String URL_INSTANCE_ACTIVATE = "/instance-auth/v1/key/activate/edge";
    private static final String URL_INSTANCE_DEACTIVATE = "/instance-auth/v1/key/deactivate/edge";
    private static String domain = "https://verify.baidubce.com";
    private static String deviceActivateUri = "/offline-auth/v2/key/activate/edge";
    private static final String TAG = "ActivateManager";
    private static volatile ScheduledThreadPoolExecutor instanceActivateExecutor;
    private Context context;
    private IBaseConfig config;

    public ActivateManager(Context context, IBaseConfig iBaseConfig) {
        this.context = context.getApplicationContext();
        this.config = iBaseConfig;
        if (!TextUtils.isEmpty((CharSequence)iBaseConfig.getAuthDomain())) {
            domain = iBaseConfig.getAuthDomain();
        }
        if (!TextUtils.isEmpty((CharSequence)iBaseConfig.getDeviceLicenseUri())) {
            deviceActivateUri = iBaseConfig.getDeviceLicenseUri();
        }
        Log.i((String)TAG, (String)("domain: " + domain + ", deviceLicenseUri: " + deviceActivateUri));
    }

    static byte[] generateKeyByHTTP(Context context, String string) throws BaseException, IOException {
        return ActivateManager.requestByHttp(context, domain + URL_GENERATE_KEY, string);
    }

    static byte[] instanceActivateByHttp(Context context, String string, String string2) throws BaseException, IOException {
        return ActivateManager.requestByHttp(context, domain + URL_INSTANCE_ACTIVATE + "?ak=" + string2, string);
    }

    static byte[] deactivateInstanceByHttp(Context context, String string, String string2) throws BaseException, IOException {
        return ActivateManager.requestByHttp(context, domain + URL_INSTANCE_DEACTIVATE + "?ak=" + string2, string);
    }

    static byte[] deviceActivateByHttp(Context context, String string) throws BaseException, IOException {
        return ActivateManager.requestByHttp(context, domain + deviceActivateUri, string);
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] requestByHttp(Context var0, final String var1_3, final String var2_5) throws BaseException, IOException {
        Log.i((String)"ActivateManager", (String)("request body: " + var1_3 + " | " + var2_5));
        var3_6 = v0;
        v0 = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return HttpUtil.postPlain(var1_3, var2_5);
            }
        });
        new Thread(var3_6, "task").start();
        var0 = v0.get();
        if (var0 == null) ** GOTO lbl29
        if (var0.isEmpty()) ** GOTO lbl29
        var1_3 = v1;
        if (new JSONObject((String)var0).getInt("status") != 0) ** GOTO lbl23
        v2 = var1_3;
        Log.i((String)"ActivateManager", (String)"Server activation success");
        return Base64.decode((String)v2.getString("result"), (int)2);
lbl23:
        // 1 sources

        var0 = var1_3.getString("message");
        Log.e((String)"ActivateManager", (String)("Response " + var1_3.getInt("status") + ": " + (String)var0));
        throw new BaseException(1900, "server activation failed: " + (String)var0);
lbl29:
        // 2 sources

        throw new BaseException(1900, "server return empty result");
        {
            catch (Exception var1_4) {
                if (HttpUtil.isOnline((Context)var0)) ** GOTO lbl35
                try {
                    throw new IOException("NETWORK STATUS IS CHECKED, NO NETWORK");
lbl35:
                    // 1 sources

                    var1_4.printStackTrace();
                    throw new IOException("Request failed, check logcat please", var1_4);
                }
                catch (Throwable var0_1) {
                    throw new BaseException(1900, var0_1.getMessage(), var0_1);
                }
                catch (JSONException var0_2) {
                    throw new BaseException(1900, var0_2.getMessage(), var0_2);
                }
            }
        }
    }

    private JSONObject mergeActiveJSON(IBaseConfig iBaseConfig, String string) {
        ActivateManager activateManager = Util.getBaseInfoJson(iBaseConfig, true, null);
        if (activateManager != null) {
            ActivateManager activateManager2 = activateManager;
            activateManager2.put("authMode", iBaseConfig.getAuthMode());
            try {
                activateManager2.put("serialKey", string);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return activateManager;
    }

    private JSONObject mergeKeyJSON(String string) {
        JSONObject jSONObject;
        ActivateManager activateManager = jSONObject;
        try {
            new JSONObject().put("serialKey", (Object)string);
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)jSONException.getMessage());
        }
        return activateManager;
    }

    static String getBase64(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)2);
    }

    private String activateInternal(String string, int n, boolean bl) throws IOException, CallException, BaseException {
        ActivateManager activateManager = this;
        ActivateManager activateManager2 = this;
        AssetManager assetManager = activateManager2.context.getAssets();
        JSONObject jSONObject = activateManager2.mergeActiveJSON(activateManager2.config, string);
        JniParam jniParam = activateManager.fillCommonAuthParam(string);
        JSONObject jSONObject2 = jSONObject;
        try {
            jniParam.put("isSkipDecrypt", bl);
            jSONObject2.put("isSkipDecrypt", bl);
        }
        catch (JSONException jSONException) {
            Log.e((String)TAG, (String)("json error:" + jSONException.getMessage()), (Throwable)jSONException);
            throw new CallException(1900, "json error:" + jSONException.getMessage(), jSONException);
        }
        jniParam.put("activate_json_body", jSONObject2.toString());
        jniParam.put("authMode", this.config.getAuthMode());
        if (activateManager.config.getAuthMode().equals("instance")) {
            jniParam.put("key_json_body", this.mergeKeyJSON(string).toString());
        }
        jniParam.put("deviceActivateURI", deviceActivateUri);
        string = null;
        switch (n) {
            default: {
                break;
            }
            case 104: {
                string = DavinciJni.activate(this.context, assetManager, jniParam);
                break;
            }
            case 102: {
                string = DDKJni.activate(this.context, assetManager, jniParam);
                break;
            }
            case 101: {
                string = SnpeJni.activate(this.context, assetManager, jniParam);
                break;
            }
            case 100: {
                string = InferLiteJni.activate(this.context, assetManager, jniParam);
            }
        }
        Log.i((String)TAG, (String)("Activation succeed: " + this.config.getAuthMode()));
        return string;
    }

    private void scheduleInstanceActivation(String string, int n, boolean bl) throws BaseException {
        instanceActivateExecutor = new ScheduledThreadPoolExecutor(1);
        instanceActivateExecutor.scheduleAtFixedRate(new c(string, n, bl), this.config.getAuthInterval(), this.config.getAuthInterval(), TimeUnit.SECONDS);
    }

    public void terminate() {
        new Thread(new Runnable(this){

            @Override
            public void run() {
                if (instanceActivateExecutor != null) {
                    instanceActivateExecutor.shutdownNow();
                    instanceActivateExecutor = null;
                    Log.i((String)ActivateManager.TAG, (String)"executor terminated");
                }
            }
        }).start();
    }

    public JniParam fillCommonAuthParam(String stringArray) {
        JniParam jniParam;
        JniParam jniParam2 = jniParam;
        jniParam = new JniParam();
        if (stringArray == null) {
            stringArray = "";
        }
        JniParam jniParam3 = jniParam2;
        jniParam3.put("serial", stringArray);
        jniParam3.put("serialNo", stringArray);
        String[] stringArray2 = new String[3];
        stringArray = stringArray2;
        stringArray2[0] = this.context.getFilesDir() + "/.baidu/easyedge";
        stringArray2[1] = this.context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/.baidu/easyedge";
        stringArray2[2] = Environment.getExternalStorageDirectory() + "/.baidu/easyedge";
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            File file;
            String string = stringArray[i];
            File file2 = file;
            if (new File(string + "/licenses").exists()) continue;
            if (file2.mkdirs()) {
                Log.i((String)TAG, (String)("mkdir success :" + file2.getAbsolutePath()));
                continue;
            }
            Log.e((String)TAG, (String)("mkdir error :" + file2.getAbsolutePath()));
        }
        jniParam2.put("isAcceleration", this.config.isAcceleration());
        jniParam2.put("fileDir", stringArray[0]);
        if (stringArray.length > 1) {
            jniParam2.put("externalFileDir", stringArray[1]);
            jniParam2.put("externalStorageDir", stringArray[2]);
        }
        JniParam jniParam4 = jniParam2;
        jniParam4.put("authRequireSDCard", true);
        return jniParam4;
    }

    public String activate(String string, int n, boolean bl) throws IOException, CallException, BaseException {
        ActivateManager activateManager = this;
        String string2 = activateManager.activateInternal(string, n, bl);
        if (activateManager.config.getAuthMode().equals("instance")) {
            this.scheduleInstanceActivation(string, n, bl);
        }
        return string2;
    }

    private class c
    implements Runnable {
        private final String a;
        private final int b;
        private final boolean c;

        public c(String string, int n, boolean bl) {
            this.a = string;
            this.b = n;
            this.c = bl;
        }

        @Override
        public void run() {
            try {
                ActivateManager.this.activateInternal(this.a, this.b, this.c);
            }
            catch (Exception exception) {
                Log.e((String)ActivateManager.TAG, (String)("Scheduled activation failed: " + exception.getClass() + "|" + exception.getMessage()));
            }
        }
    }
}

