/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.util;

import android.text.TextUtils;
import com.yanzhenjie.andserver.RequestMethod;
import com.yanzhenjie.andserver.upload.HttpUploadContext;
import com.yanzhenjie.andserver.util.DateUtils;
import com.yanzhenjie.andserver.util.UrlCoder;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.RequestContext;
import org.apache.httpcore.Header;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.HttpEntityEnclosingRequest;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.util.EntityUtils;

public class HttpRequestParser {
    public static final String CHARSET_UTF8 = "utf-8";

    public static Map<String, String> parseParams(HttpRequest request) throws IOException {
        return HttpRequestParser.parseParams(request, false);
    }

    public static Map<String, String> parseParams(HttpRequest request, boolean lowerCaseNames) throws IOException {
        String content = HttpRequestParser.getContent(request);
        return HttpRequestParser.splitHttpParams(content, lowerCaseNames);
    }

    public static Map<String, String> splitHttpParams(String content, boolean lowerCaseNames) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(content, "&");
        while (tokenizer.hasMoreElements()) {
            String keyValue = tokenizer.nextToken();
            int index = keyValue.indexOf("=");
            if (index <= 0) continue;
            String key = keyValue.substring(0, index);
            if (lowerCaseNames) {
                key = key.toLowerCase(Locale.ENGLISH);
            }
            paramMap.put(key, UrlCoder.urlDecode(keyValue.substring(index + 1), CHARSET_UTF8));
        }
        return paramMap;
    }

    public static String getContent(HttpRequest request) throws IOException {
        if (HttpRequestParser.isAllowRequestBody(request)) {
            return HttpRequestParser.getContentFromBody(request);
        }
        return HttpRequestParser.getContentFromUri(request);
    }

    public static String getContentFromBody(HttpRequest request) throws IOException {
        HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
        String charset = HttpRequestParser.parseHeadValue(entity.getContentType().getValue(), "charset", CHARSET_UTF8);
        return EntityUtils.toString((HttpEntity)entity, (String)charset);
    }

    public static String getContentFromUri(HttpRequest request) {
        String uri = request.getRequestLine().getUri();
        int index = uri.indexOf(63);
        return index == -1 || index + 1 >= uri.length() ? "" : uri.substring(index + 1);
    }

    public static String getRequestPath(HttpRequest request) {
        String uriPath = request.getRequestLine().getUri();
        int index = uriPath.indexOf("?");
        if (index != -1) {
            uriPath = uriPath.substring(0, index);
        } else {
            index = uriPath.indexOf("#");
            if (index != -1) {
                uriPath = uriPath.substring(0, index);
            }
        }
        String[] pathArray = uriPath.split("/");
        if (pathArray.length > 1) {
            ArrayList<String> pathList = new ArrayList<String>();
            for (String path : pathArray) {
                path = UrlCoder.urlDecode(path, CHARSET_UTF8);
                pathList.add(path);
            }
            uriPath = TextUtils.join((CharSequence)"/", pathList);
        }
        return uriPath;
    }

    public static boolean isAllowRequestBody(HttpRequest request) {
        return HttpRequestParser.getRequestMethod(request).allowRequestBody();
    }

    public static RequestMethod getRequestMethod(HttpRequest request) {
        String method = request.getRequestLine().getMethod();
        return RequestMethod.reverse(method);
    }

    public static boolean isMultipartContentRequest(HttpRequest request) {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            return false;
        }
        HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
        return HttpRequestParser.isAllowRequestBody(request) && FileUploadBase.isMultipartContent((RequestContext)new HttpUploadContext(enclosingRequest));
    }

    public static long parseDateHeader(HttpRequest request, String headerName) {
        block5: {
            Header header = request.getFirstHeader(headerName);
            if (header != null) {
                String dateValue = header.getValue();
                try {
                    return DateUtils.parseGMTToMillis(dateValue);
                }
                catch (ParseException ex) {
                    int separatorIndex = dateValue.indexOf(59);
                    if (separatorIndex == -1) break block5;
                    String datePart = dateValue.substring(0, separatorIndex);
                    try {
                        return DateUtils.parseGMTToMillis(datePart);
                    }
                    catch (ParseException ignored) {
                        // empty catch block
                    }
                }
            }
        }
        return -1L;
    }

    public static String parseHeadValue(String content, String key, String defaultValue) {
        if (!TextUtils.isEmpty((CharSequence)content) && !TextUtils.isEmpty((CharSequence)key)) {
            StringTokenizer stringTokenizer = new StringTokenizer(content, ";");
            while (stringTokenizer.hasMoreElements()) {
                String name;
                String valuePair = stringTokenizer.nextToken();
                int index = valuePair.indexOf(61);
                if (index <= 0 || !key.equalsIgnoreCase(name = valuePair.substring(0, index).trim())) continue;
                defaultValue = valuePair.substring(index + 1).trim();
                break;
            }
        }
        return defaultValue;
    }
}

