/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.filter;

import com.yanzhenjie.andserver.RequestHandler;
import com.yanzhenjie.andserver.filter.Filter;
import com.yanzhenjie.andserver.protocol.ETag;
import com.yanzhenjie.andserver.protocol.LastModified;
import com.yanzhenjie.andserver.util.DateUtils;
import com.yanzhenjie.andserver.util.DigestUtils;
import com.yanzhenjie.andserver.util.HttpRequestParser;
import java.io.IOException;
import org.apache.httpcore.Header;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.HttpResponse;
import org.apache.httpcore.protocol.HttpContext;

public class HttpCacheFilter
implements Filter {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String E_TAG = "ETag";
    private static final String IF_NONE_MATCH = "If-None-Match";

    @Override
    public void doFilter(RequestHandler handler, HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        long sourceLastModified = -1L;
        boolean isLastModified = handler instanceof LastModified;
        if (isLastModified) {
            sourceLastModified = ((LastModified)((Object)handler)).getLastModified(request);
        }
        String sourceETag = null;
        boolean isETag = handler instanceof ETag;
        if (isETag) {
            sourceETag = ((ETag)((Object)handler)).getETag(request);
        }
        Header ifUnmodifiedSinceHeader = request.getFirstHeader(IF_UNMODIFIED_SINCE);
        if (isLastModified && ifUnmodifiedSinceHeader != null && !this.validateIfUnmodifiedSince(request, sourceLastModified)) {
            response.setStatusCode(412);
            return;
        }
        Header ifModifiedSinceHeader = request.getFirstHeader(IF_MODIFIED_SINCE);
        Header ifNoneMatchHeader = request.getFirstHeader(IF_NONE_MATCH);
        if (isLastModified && isETag && ifModifiedSinceHeader != null && ifNoneMatchHeader != null && this.validateIfModifiedSince(request, sourceLastModified) && this.validateIfNoneMatch(request, sourceETag)) {
            response.setStatusCode(304);
            response.addHeader(CACHE_CONTROL, "public");
            response.addHeader(LAST_MODIFIED, this.generateLastModified(sourceLastModified));
            response.addHeader(E_TAG, this.generateETag(sourceETag));
            return;
        }
        if (isLastModified && ifModifiedSinceHeader != null && this.validateIfModifiedSince(request, sourceLastModified)) {
            response.setStatusCode(304);
            response.addHeader(CACHE_CONTROL, "public");
            response.addHeader(LAST_MODIFIED, this.generateLastModified(sourceLastModified));
            return;
        }
        handler.handle(request, response, context);
        if (isLastModified && sourceLastModified >= 0L) {
            response.addHeader(LAST_MODIFIED, this.generateLastModified(sourceLastModified));
        }
        if (isETag && sourceETag != null) {
            response.addHeader(E_TAG, this.generateETag(sourceETag));
        }
        if (isLastModified) {
            response.addHeader(CACHE_CONTROL, "public");
        }
    }

    protected String generateETag(String tag) throws IOException {
        return "\"0" + DigestUtils.md5DigestAsHex(tag) + '\"';
    }

    protected boolean validateIfNoneMatch(HttpRequest request, String sourceETag) {
        Header eTagHeader = request.getFirstHeader(IF_NONE_MATCH);
        if (sourceETag == null && eTagHeader == null) {
            return true;
        }
        if (sourceETag != null && eTagHeader != null) {
            String ifNoneMatch = eTagHeader.getValue();
            return sourceETag.equalsIgnoreCase(ifNoneMatch);
        }
        return false;
    }

    protected String generateLastModified(long lastModified) throws IOException {
        return DateUtils.formatMillisToGMT(lastModified);
    }

    protected boolean validateIfModifiedSince(HttpRequest request, long sourceLastModify) {
        if (sourceLastModify < 0L) {
            return false;
        }
        long ifModifiedSince = HttpRequestParser.parseDateHeader(request, IF_MODIFIED_SINCE);
        if (ifModifiedSince < 0L) {
            return false;
        }
        return ifModifiedSince >= sourceLastModify / 1000L * 1000L;
    }

    protected boolean validateIfUnmodifiedSince(HttpRequest request, long sourceLastModify) {
        if (sourceLastModify < 0L) {
            return false;
        }
        long ifUnmodifiedSince = HttpRequestParser.parseDateHeader(request, IF_UNMODIFIED_SINCE);
        if (ifUnmodifiedSince < 0L) {
            return false;
        }
        return ifUnmodifiedSince < sourceLastModify / 1000L * 1000L;
    }
}

