/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Handler;
import android.text.TextPaint;
import android.view.MotionEvent;
import android.view.View;
import com.ab.util.AbFileUtil;
import com.ab.util.AbGraphicUtil;
import com.ab.util.AbViewUtil;
import com.ab.view.chart.AbstractChart;
import com.ab.view.chart.DefaultRenderer;
import com.ab.view.chart.FitZoom;
import com.ab.view.chart.ITouchHandler;
import com.ab.view.chart.PanListener;
import com.ab.view.chart.Point;
import com.ab.view.chart.RoundChart;
import com.ab.view.chart.SeriesSelection;
import com.ab.view.chart.SimpleSeriesRenderer;
import com.ab.view.chart.TouchHandler;
import com.ab.view.chart.XYChart;
import com.ab.view.chart.XYMultipleSeriesRenderer;
import com.ab.view.chart.Zoom;
import com.ab.view.chart.ZoomListener;
import java.util.List;
import java.util.Map;

public class GraphicalView
extends View {
    private Context mContext;
    private AbstractChart mChart;
    private DefaultRenderer mRenderer;
    private Rect mRect = new Rect();
    private Handler mHandler;
    private RectF mZoomR = new RectF();
    private Bitmap zoomInImage;
    private Bitmap zoomOutImage;
    private Bitmap fitZoomImage;
    private static final int ZOOM_BUTTONS_COLOR = Color.argb((int)175, (int)150, (int)150, (int)150);
    private Zoom mZoomIn;
    private Zoom mZoomOut;
    private FitZoom mFitZoom;
    private Paint mPaint = new Paint();
    private ITouchHandler mTouchHandler;
    private float oldX;
    private float oldY;

    public GraphicalView(Context context, AbstractChart chart) {
        super(context);
        this.mContext = context;
        this.mChart = chart;
        this.mHandler = new Handler();
        this.mRenderer = this.mChart instanceof XYChart ? ((XYChart)this.mChart).getRenderer() : ((RoundChart)this.mChart).getRenderer();
        if (this.mRenderer.isZoomButtonsVisible()) {
            this.zoomInImage = AbFileUtil.getBitmapFromSrc("image/zoom_in.png");
            this.zoomOutImage = AbFileUtil.getBitmapFromSrc("image/zoom_out.png");
            this.fitZoomImage = AbFileUtil.getBitmapFromSrc("image/zoom-1.png");
        }
        if (this.mRenderer instanceof XYMultipleSeriesRenderer && ((XYMultipleSeriesRenderer)this.mRenderer).getMarginsColor() == 0) {
            ((XYMultipleSeriesRenderer)this.mRenderer).setMarginsColor(this.mPaint.getColor());
        }
        if (this.mRenderer.isZoomEnabled() && this.mRenderer.isZoomButtonsVisible() || this.mRenderer.isExternalZoomEnabled()) {
            this.mZoomIn = new Zoom(this.mChart, true, this.mRenderer.getZoomRate());
            this.mZoomOut = new Zoom(this.mChart, false, this.mRenderer.getZoomRate());
            this.mFitZoom = new FitZoom(this.mChart);
        }
        this.mTouchHandler = new TouchHandler(this, this.mChart);
        if (this.mChart instanceof XYChart) {
            XYMultipleSeriesRenderer mXYMultipleSeriesRenderer = ((XYChart)this.mChart).getRenderer();
            int explainTextSize1 = mXYMultipleSeriesRenderer.getExplainTextSize1();
            int explainTextSize2 = mXYMultipleSeriesRenderer.getExplainTextSize2();
            int scaleCircleRadius = mXYMultipleSeriesRenderer.getScaleCircleRadius();
            int scaleRectWidth = mXYMultipleSeriesRenderer.getScaleRectWidth();
            int scaleRectHeight = mXYMultipleSeriesRenderer.getScaleRectHeight();
            mXYMultipleSeriesRenderer.setExplainTextSize1(AbViewUtil.scale(this.mContext, explainTextSize1));
            mXYMultipleSeriesRenderer.setExplainTextSize2(AbViewUtil.scale(this.mContext, explainTextSize2));
            mXYMultipleSeriesRenderer.setScaleCircleRadius(AbViewUtil.scale(this.mContext, scaleCircleRadius));
            mXYMultipleSeriesRenderer.setScaleRectWidth(AbViewUtil.scale(this.mContext, scaleRectWidth));
            mXYMultipleSeriesRenderer.setScaleRectHeight(AbViewUtil.scale(this.mContext, scaleRectHeight));
            SimpleSeriesRenderer[] mSimpleSeriesRenderers = this.mRenderer.getSeriesRenderers();
            if (mSimpleSeriesRenderers != null && mSimpleSeriesRenderers.length > 0) {
                int i = 0;
                while (i < mSimpleSeriesRenderers.length) {
                    SimpleSeriesRenderer mSimpleSeriesRenderer = mSimpleSeriesRenderers[i];
                    int mChartValuesTextSize = (int)mSimpleSeriesRenderer.getChartValuesTextSize();
                    mSimpleSeriesRenderer.setChartValuesTextSize(AbViewUtil.scale(this.mContext, mChartValuesTextSize));
                    ++i;
                }
            }
        }
        int chartTitleTextSize = (int)this.mRenderer.getChartTitleTextSize();
        this.mRenderer.setChartTitleTextSize(AbViewUtil.scale(this.mContext, chartTitleTextSize));
        int mLabelsTextSize = (int)this.mRenderer.getLabelsTextSize();
        this.mRenderer.setLabelsTextSize(AbViewUtil.scale(this.mContext, mLabelsTextSize));
        int mLegendTextSize = (int)this.mRenderer.getLegendTextSize();
        this.mRenderer.setLegendTextSize(AbViewUtil.scale(this.mContext, mLegendTextSize));
    }

    public SeriesSelection getCurrentSeriesAndPoint() {
        return this.mChart.getSeriesAndPointForScreenCoordinate(new Point(this.oldX, this.oldY));
    }

    public double[] toRealPoint(int scale) {
        if (this.mChart instanceof XYChart) {
            XYChart chart = (XYChart)this.mChart;
            return chart.toRealPoint(this.oldX, this.oldY, scale);
        }
        return null;
    }

    protected void onDraw(Canvas canvas) {
        XYMultipleSeriesRenderer mXYMultipleSeriesRenderer;
        super.onDraw(canvas);
        canvas.getClipBounds(this.mRect);
        int top = this.mRect.top;
        int left = this.mRect.left;
        int width = this.mRect.width();
        int height = this.mRect.height();
        if (this.mRenderer.isInScroll()) {
            top = 0;
            left = 0;
            width = this.getMeasuredWidth();
            height = this.getMeasuredHeight();
        }
        this.mChart.draw(canvas, left, top, width, height, this.mPaint);
        if (this.mRenderer != null && this.mRenderer.isZoomEnabled() && this.mRenderer.isZoomButtonsVisible()) {
            this.mPaint.setColor(ZOOM_BUTTONS_COLOR);
            int bitmapWidth = this.zoomInImage.getWidth();
            int bitmapHeight = this.zoomInImage.getHeight();
            int rectMargin = 10;
            int topPadding = 15;
            int leftPadding = 20;
            int leftRect = width - bitmapWidth * 3 - rectMargin - 4 * leftPadding;
            int topRect = height - bitmapHeight - rectMargin - 2 * topPadding;
            int rightRect = width - rectMargin;
            int bottomRect = height - rectMargin;
            this.mZoomR.set((float)leftRect, (float)topRect, (float)rightRect, (float)bottomRect);
            canvas.drawRoundRect(this.mZoomR, (float)(bitmapWidth / 2), (float)(bitmapWidth / 2), this.mPaint);
            float buttonY = height - bitmapHeight - rectMargin - topPadding;
            canvas.drawBitmap(this.zoomInImage, (float)(width - rectMargin - bitmapWidth * 3 - 3 * leftPadding), buttonY, null);
            canvas.drawBitmap(this.zoomOutImage, (float)(width - rectMargin - bitmapWidth * 2 - 2 * leftPadding), buttonY, null);
            canvas.drawBitmap(this.fitZoomImage, (float)(width - rectMargin - bitmapWidth - leftPadding), buttonY, null);
        }
        if (this.mChart instanceof XYChart && (mXYMultipleSeriesRenderer = ((XYChart)this.mChart).getRenderer()).isScaleLineEnabled()) {
            this.oldX = ((TouchHandler)this.mTouchHandler).getOldX();
            int scaleTopPadding = 50;
            int scaleBottomPadding = 20;
            int explainTextSize1 = mXYMultipleSeriesRenderer.getExplainTextSize1();
            int explainTextSize2 = mXYMultipleSeriesRenderer.getExplainTextSize2();
            int scaleCircleRadius = mXYMultipleSeriesRenderer.getScaleCircleRadius();
            scaleTopPadding = AbViewUtil.scale(this.mContext, scaleTopPadding);
            scaleBottomPadding = AbViewUtil.scale(this.mContext, scaleBottomPadding);
            int bottomY = 0;
            int topY = 0;
            if (this.mChart instanceof XYChart) {
                Rect mScreenR = ((XYChart)this.mChart).getScreenR();
                bottomY = mScreenR.bottom;
                topY = mScreenR.top;
                if (this.oldX == 0.0f) {
                    this.oldX = mScreenR.right;
                }
            }
            this.mPaint.setColor(mXYMultipleSeriesRenderer.getScaleLineColor());
            canvas.drawLine(this.oldX, (float)scaleTopPadding, this.oldX, (float)(bottomY + scaleBottomPadding), this.mPaint);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(ZOOM_BUTTONS_COLOR);
            canvas.drawCircle(this.oldX, (float)(bottomY + scaleBottomPadding + scaleCircleRadius), (float)scaleCircleRadius, this.mPaint);
            if (this.mChart instanceof XYChart) {
                List<Float> mPoints = null;
                List<Double> mValues = null;
                List<String> mExplains = null;
                float minValue = -1.0f;
                int minIndex = -1;
                String showValue = "";
                String showExplain = "";
                Map<Integer, List<Float>> points = ((XYChart)this.mChart).getPoints();
                Map<Integer, List<Double>> values = ((XYChart)this.mChart).getValues();
                Map<Integer, List<String>> explains = ((XYChart)this.mChart).getExplains();
                for (Map.Entry<Integer, List<Float>> value : points.entrySet()) {
                    String showExplainT;
                    int index = value.getKey();
                    mPoints = value.getValue();
                    mValues = values.get(value.getKey());
                    mExplains = explains.get(value.getKey());
                    minValue = 1000.0f;
                    minIndex = -1;
                    int i = 0;
                    while (i < mPoints.size()) {
                        Float f = mPoints.get(i);
                        if (Math.abs(f.floatValue() - this.oldX) < minValue) {
                            minValue = Math.abs(f.floatValue() - this.oldX);
                            minIndex = i;
                        }
                        i += 2;
                    }
                    if (index == 0) {
                        showValue = String.valueOf(mValues.get(minIndex + 1)).replace(".0", "");
                        showExplainT = mExplains.get(minIndex / 2);
                        if (showExplainT == null || "".equals(showExplainT.trim())) continue;
                        showExplain = mExplains.get(minIndex / 2);
                        continue;
                    }
                    showValue = String.valueOf(showValue) + "/" + String.valueOf(mValues.get(minIndex + 1)).replace(".0", "");
                    showExplainT = mExplains.get(minIndex / 2);
                    if (showExplainT == null || "".equals(showExplainT.trim())) continue;
                    showExplain = showExplain != null && !"".equals(showExplain.trim()) ? String.valueOf(showExplain) + "/" + mExplains.get(minIndex / 2) : mExplains.get(minIndex / 2);
                }
                if (minValue < 5.0f) {
                    boolean showRect = false;
                    showRect = mXYMultipleSeriesRenderer.isDisplayValue0() ? true : !"0".equals(showValue) && !"0/0".equals(showValue);
                    if (showRect) {
                        TextPaint mTextPaint1 = new TextPaint(1);
                        mTextPaint1.setColor(-1);
                        mTextPaint1.setTypeface(Typeface.DEFAULT);
                        mTextPaint1.setTextSize((float)explainTextSize1);
                        TextPaint mTextPaint2 = new TextPaint(1);
                        mTextPaint2.setColor(-1);
                        mTextPaint2.setTypeface(Typeface.DEFAULT);
                        mTextPaint2.setTextSize((float)explainTextSize2);
                        float hSize1 = AbGraphicUtil.getDesiredHeight(mTextPaint1);
                        float hSize2 = AbGraphicUtil.getDesiredHeight(mTextPaint2);
                        int textPadding = 8;
                        textPadding = AbViewUtil.scale(this.mContext, textPadding);
                        int row1 = AbGraphicUtil.getDrawRowCount(showValue, mXYMultipleSeriesRenderer.getScaleRectWidth() - 10, mTextPaint1);
                        int row2 = AbGraphicUtil.getDrawRowCount(showExplain, mXYMultipleSeriesRenderer.getScaleRectWidth() - 10, mTextPaint2);
                        RectF mRectF = null;
                        int textHeight = (int)((float)row1 * hSize1 + (float)row2 * hSize2 + (float)textPadding);
                        int realScaleRectWidth = mXYMultipleSeriesRenderer.getScaleRectWidth();
                        int realScaleRectHeight = mXYMultipleSeriesRenderer.getScaleRectHeight();
                        this.mPaint.setStyle(Paint.Style.FILL);
                        this.mPaint.setColor(mXYMultipleSeriesRenderer.getScaleRectColor());
                        this.mPaint.setAntiAlias(true);
                        int mRectLeft = (int)mPoints.get(minIndex).floatValue();
                        int mRectTop = (int)mPoints.get(minIndex + 1).floatValue();
                        int mRectRight = mRectLeft + realScaleRectWidth;
                        int mRectBottom = mRectTop + realScaleRectHeight;
                        if (textHeight > realScaleRectHeight) {
                            realScaleRectHeight = textHeight;
                            mRectBottom = mRectTop + realScaleRectHeight;
                        }
                        if (mRectRight > width) {
                            mRectLeft = (int)mPoints.get(minIndex).floatValue() - 5 - mXYMultipleSeriesRenderer.getScaleRectWidth();
                            mRectRight = (int)mPoints.get(minIndex).floatValue() - 5;
                        }
                        if (mRectBottom > bottomY) {
                            mRectTop = (int)mPoints.get(minIndex + 1).floatValue() - 5 - realScaleRectHeight;
                            mRectBottom = (int)mPoints.get(minIndex + 1).floatValue() - 5;
                            if (mRectTop < topY) {
                                mRectTop += realScaleRectHeight / 2;
                                mRectBottom += realScaleRectHeight / 2;
                            }
                        }
                        mRectF = new RectF((float)mRectLeft, (float)mRectTop, (float)mRectRight, (float)mRectBottom);
                        canvas.drawRoundRect(mRectF, 5.0f, 5.0f, this.mPaint);
                        AbGraphicUtil.drawText(canvas, showValue, mXYMultipleSeriesRenderer.getScaleRectWidth(), mTextPaint1, mRectLeft + textPadding, mRectTop + textPadding);
                        AbGraphicUtil.drawText(canvas, showExplain, mXYMultipleSeriesRenderer.getScaleRectWidth(), mTextPaint2, mRectLeft + textPadding, (int)((float)(mRectTop + textPadding) + (float)row1 * hSize1));
                    }
                }
            }
        }
    }

    public void setZoomRate(float rate) {
        if (this.mZoomIn != null && this.mZoomOut != null) {
            this.mZoomIn.setZoomRate(rate);
            this.mZoomOut.setZoomRate(rate);
        }
    }

    public void zoomIn() {
        if (this.mZoomIn != null) {
            this.mZoomIn.apply(0);
            this.repaint();
        }
    }

    public void zoomOut() {
        if (this.mZoomOut != null) {
            this.mZoomOut.apply(0);
            this.repaint();
        }
    }

    public void zoomReset() {
        if (this.mFitZoom != null) {
            this.mFitZoom.apply();
            this.mZoomIn.notifyZoomResetListeners();
            this.repaint();
        }
    }

    public void addZoomListener(ZoomListener listener, boolean onButtons, boolean onPinch) {
        if (onButtons) {
            if (this.mZoomIn != null) {
                this.mZoomIn.addZoomListener(listener);
                this.mZoomOut.addZoomListener(listener);
            }
            if (onPinch) {
                this.mTouchHandler.addZoomListener(listener);
            }
        }
    }

    public synchronized void removeZoomListener(ZoomListener listener) {
        if (this.mZoomIn != null) {
            this.mZoomIn.removeZoomListener(listener);
            this.mZoomOut.removeZoomListener(listener);
        }
        this.mTouchHandler.removeZoomListener(listener);
    }

    public void addPanListener(PanListener listener) {
        this.mTouchHandler.addPanListener(listener);
    }

    public void removePanListener(PanListener listener) {
        this.mTouchHandler.removePanListener(listener);
    }

    protected RectF getZoomRectangle() {
        return this.mZoomR;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mRenderer != null) {
            float newX = event.getX();
            float newY = event.getY();
            int bottom = 0;
            if (this.mChart instanceof XYChart) {
                Rect mScreenR = ((XYChart)this.mChart).getScreenR();
                bottom = mScreenR.bottom;
            }
            if (newY >= (float)(bottom - 10) ? this.mTouchHandler.handleTouchControl(event) : (this.mRenderer.isPanEnabled() || this.mRenderer.isZoomEnabled()) && this.mTouchHandler.handleTouch(event)) {
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.invalidate();
            }
        });
    }

    public void repaint(final int left, final int top, final int right, final int bottom) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.invalidate(left, top, right, bottom);
            }
        });
    }

    public Bitmap toBitmap() {
        this.setDrawingCacheEnabled(false);
        if (!this.isDrawingCacheEnabled()) {
            this.setDrawingCacheEnabled(true);
        }
        if (this.mRenderer.isApplyBackgroundColor()) {
            this.setDrawingCacheBackgroundColor(this.mRenderer.getBackgroundColor());
        }
        this.setDrawingCacheQuality(0x100000);
        return this.getDrawingCache(true);
    }
}

