/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.carousel;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.ab.util.AbImageUtil;
import com.ab.util.AbViewUtil;
import com.ab.view.carousel.CarouselItemView;
import java.util.List;

public class CarouselViewAdapter
extends BaseAdapter {
    private Context mContext;
    private List<View> mViews;
    private boolean mReflected = true;
    private CarouselItemView[] mCarouselItemViews = null;

    public CarouselViewAdapter(Context c, List<View> views, boolean reflected) {
        this.mContext = c;
        this.mViews = views;
        this.mReflected = reflected;
        this.setImages();
    }

    public int getCount() {
        if (this.mViews == null) {
            return 0;
        }
        return this.mViews.size();
    }

    public Object getItem(int position) {
        return position;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        convertView = this.mCarouselItemViews[position];
        return convertView;
    }

    public void setImages() {
        this.mCarouselItemViews = new CarouselItemView[this.mViews.size()];
        int i = 0;
        while (i < this.mViews.size()) {
            int index = i;
            View view = this.mViews.get(i);
            CarouselItemView itemView = new CarouselItemView(this.mContext);
            itemView.setIndex(i);
            if (this.mReflected) {
                Bitmap originalImage = AbImageUtil.view2Bitmap(view);
                ImageView imageView = new ImageView(this.mContext);
                LinearLayout.LayoutParams mLayoutParams = new LinearLayout.LayoutParams(-2, -2);
                mLayoutParams.gravity = 1;
                imageView.setScaleType(ImageView.ScaleType.CENTER);
                imageView.setImageBitmap(AbImageUtil.toReflectionBitmap(originalImage));
                itemView.addView((View)imageView, (ViewGroup.LayoutParams)mLayoutParams);
                imageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View arg0) {
                    }
                });
            } else {
                AbViewUtil.measureView(view);
                LinearLayout.LayoutParams mLayoutParams = new LinearLayout.LayoutParams(-2, -2);
                mLayoutParams.gravity = 1;
                itemView.addView(view, (ViewGroup.LayoutParams)mLayoutParams);
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View arg0) {
                    }
                });
            }
            this.mCarouselItemViews[i] = itemView;
            ++i;
        }
    }
}

