/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.SystemClock;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.ab.util.AbGraphicUtil;
import com.ab.util.AbViewUtil;

public class AbMonitorView
extends View {
    private long mStartTime = -1L;
    private int mCounter;
    private int mFps;
    private final Paint mPaint = new Paint();

    public AbMonitorView(Context context) {
        this(context, null);
    }

    public AbMonitorView(Context context, AttributeSet attributeset) {
        super(context);
        this.mPaint.setColor(-1);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTypeface(Typeface.DEFAULT);
        this.mPaint.setTextSize(16.0f);
    }

    protected void onDraw(Canvas canvas) {
        long now;
        long delay;
        canvas.drawColor(Color.argb((int)80, (int)0, (int)0, (int)0));
        if (this.mStartTime == -1L) {
            this.mStartTime = SystemClock.elapsedRealtime();
            this.mCounter = 0;
        }
        if ((delay = (now = SystemClock.elapsedRealtime()) - this.mStartTime) != 0L) {
            this.mFps = (int)((long)(this.mCounter * 1000) / delay);
        }
        String text = String.valueOf(this.mFps) + " fps";
        TextPaint mTextPaint = new TextPaint(1);
        mTextPaint.setTypeface(Typeface.DEFAULT);
        AbViewUtil.setTextSize(this.getContext(), mTextPaint, 30.0f);
        AbViewUtil.setTextSize(this.getContext(), this.mPaint, 30.0f);
        Paint.FontMetrics fm = mTextPaint.getFontMetrics();
        int textHeight = (int)Math.ceil(fm.descent - fm.ascent) + 2;
        int textWidth = (int)AbGraphicUtil.getStringWidth(text, mTextPaint);
        canvas.drawText(text, (float)((this.getWidth() - textWidth) / 2), (float)textHeight, this.mPaint);
        if (delay > 1000L) {
            this.mStartTime = now;
            this.mFps = this.mCounter;
            this.mCounter = 0;
        }
        ++this.mCounter;
        super.onDraw(canvas);
    }
}

