/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import java.util.List;

public class AbWifiUtil {
    public static void setWifiEnabled(Context context, boolean enabled) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (enabled) {
            wifiManager.setWifiEnabled(true);
        } else {
            wifiManager.setWifiEnabled(false);
        }
    }

    public static boolean isConnectivity(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return connectivityManager.getActiveNetworkInfo() != null && connectivityManager.getActiveNetworkInfo().getState() == NetworkInfo.State.CONNECTED || telephonyManager.getNetworkType() == 3;
    }

    public static boolean isWifiConnectivity(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static List<ScanResult> getScanResults(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        List list = null;
        boolean f = wifiManager.startScan();
        if (!f) {
            AbWifiUtil.getScanResults(context);
        } else {
            list = wifiManager.getScanResults();
        }
        return list;
    }

    public static ScanResult getScanResultsByBSSID(Context context, String bssid) {
        List list;
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        ScanResult scanResult = null;
        boolean f = wifiManager.startScan();
        if (!f) {
            AbWifiUtil.getScanResultsByBSSID(context, bssid);
        }
        if ((list = wifiManager.getScanResults()) != null) {
            int i = 0;
            while (i < list.size()) {
                scanResult = (ScanResult)list.get(i);
                if (scanResult.BSSID.equals(bssid)) break;
                ++i;
            }
        }
        return scanResult;
    }

    public static WifiInfo getConnectionInfo(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        return wifiInfo;
    }
}

