/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import java.math.BigDecimal;

public class AbMathUtil {
    public static BigDecimal round(double number, int decimal) {
        return new BigDecimal(number).setScale(decimal, 4);
    }

    public static String byte2HexStr(byte[] b, int length) {
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            hs = String.valueOf(hs) + ",";
            ++n;
        }
        return hs.toUpperCase();
    }

    public static char binaryToHex(int binary) {
        char ch = ' ';
        switch (binary) {
            case 0: {
                ch = '0';
                break;
            }
            case 1: {
                ch = '1';
                break;
            }
            case 2: {
                ch = '2';
                break;
            }
            case 3: {
                ch = '3';
                break;
            }
            case 4: {
                ch = '4';
                break;
            }
            case 5: {
                ch = '5';
                break;
            }
            case 6: {
                ch = '6';
                break;
            }
            case 7: {
                ch = '7';
                break;
            }
            case 8: {
                ch = '8';
                break;
            }
            case 9: {
                ch = '9';
                break;
            }
            case 10: {
                ch = 'a';
                break;
            }
            case 11: {
                ch = 'b';
                break;
            }
            case 12: {
                ch = 'c';
                break;
            }
            case 13: {
                ch = 'd';
                break;
            }
            case 14: {
                ch = 'e';
                break;
            }
            case 15: {
                ch = 'f';
                break;
            }
            default: {
                ch = ' ';
            }
        }
        return ch;
    }

    public static int[][] arrayToMatrix(int[] m, int width, int height) {
        int[][] result = new int[height][width];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int p = j * height + i;
                result[i][j] = m[p];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] matrixToArray(double[][] m) {
        int p = m.length * m[0].length;
        double[] result = new double[p];
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[i].length) {
                int q = j * m.length + i;
                result[q] = m[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] intToDoubleArray(int[] input) {
        int length = input.length;
        double[] output = new double[length];
        int i = 0;
        while (i < length) {
            output[i] = Double.valueOf(String.valueOf(input[i]));
            ++i;
        }
        return output;
    }

    public static double[][] intToDoubleMatrix(int[][] input) {
        int height = input.length;
        int width = input[0].length;
        double[][] output = new double[height][width];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                output[i][j] = Double.valueOf(String.valueOf(input[i][j]));
                ++j;
            }
            ++i;
        }
        return output;
    }

    public static int average(int[] pixels) {
        float m = 0.0f;
        int i = 0;
        while (i < pixels.length) {
            m += (float)pixels[i];
            ++i;
        }
        return (int)(m /= (float)pixels.length);
    }

    public static int average(double[] pixels) {
        float m = 0.0f;
        int i = 0;
        while (i < pixels.length) {
            m = (float)((double)m + pixels[i]);
            ++i;
        }
        return (int)(m /= (float)pixels.length);
    }

    public boolean pointAtSLine(double x, double y, double x1, double y1, double x2, double y2) {
        double result = (x - x1) * (y2 - y1) - (y - y1) * (x2 - x1);
        return result == 0.0;
    }

    public static boolean pointAtELine(double x, double y, double x1, double y1, double x2, double y2) {
        double result = (x - x1) * (y2 - y1) - (y - y1) * (x2 - x1);
        if (result == 0.0) {
            return x >= Math.min(x1, x2) && x <= Math.max(x1, x2) && y >= Math.min(y1, y2) && y <= Math.max(y1, y2);
        }
        return false;
    }

    public static boolean LineAtLine(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double k1 = (y2 - y1) / (x2 - x1);
        double k2 = (y4 - y3) / (x4 - x3);
        if (k1 == k2) {
            return false;
        }
        double x = ((x1 * y2 - y1 * x2) * (x3 - x4) - (x3 * y4 - y3 * x4) * (x1 - x2)) / ((y2 - y1) * (x3 - x4) - (y4 - y3) * (x1 - x2));
        double y = (x1 * y2 - y1 * x2 - x * (y2 - y1)) / (x1 - x2);
        return true;
    }

    public static boolean eLineAtELine(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double k1 = (y2 - y1) / (x2 - x1);
        double k2 = (y4 - y3) / (x4 - x3);
        if (k1 == k2) {
            return false;
        }
        double x = ((x1 * y2 - y1 * x2) * (x3 - x4) - (x3 * y4 - y3 * x4) * (x1 - x2)) / ((y2 - y1) * (x3 - x4) - (y4 - y3) * (x1 - x2));
        double y = (x1 * y2 - y1 * x2 - x * (y2 - y1)) / (x1 - x2);
        return x >= Math.min(x1, x2) && x <= Math.max(x1, x2) && y >= Math.min(y1, y2) && y <= Math.max(y1, y2) && x >= Math.min(x3, x4) && x <= Math.max(x3, x4) && y >= Math.min(y3, y4) && y <= Math.max(y3, y4);
    }

    public static boolean eLineAtLine(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double k1 = (y2 - y1) / (x2 - x1);
        double k2 = (y4 - y3) / (x4 - x3);
        if (k1 == k2) {
            return false;
        }
        double x = ((x1 * y2 - y1 * x2) * (x3 - x4) - (x3 * y4 - y3 * x4) * (x1 - x2)) / ((y2 - y1) * (x3 - x4) - (y4 - y3) * (x1 - x2));
        double y = (x1 * y2 - y1 * x2 - x * (y2 - y1)) / (x1 - x2);
        return x >= Math.min(x1, x2) && x <= Math.max(x1, x2) && y >= Math.min(y1, y2) && y <= Math.max(y1, y2);
    }

    public static boolean pointAtRect(double x, double y, double x1, double y1, double x2, double y2) {
        return x >= Math.min(x1, x2) && x <= Math.max(x1, x2) && y >= Math.min(y1, y2) && y <= Math.max(y1, y2);
    }

    public static boolean rectAtRect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return x1 >= Math.min(x3, x4) && x1 <= Math.max(x3, x4) && y1 >= Math.min(y3, y4) && y1 <= Math.max(y3, y4) && x2 >= Math.min(x3, x4) && x2 <= Math.max(x3, x4) && y2 >= Math.min(y3, y4) && y2 <= Math.max(y3, y4);
    }

    public static boolean circleAtRect(double x, double y, double r, double x1, double y1, double x2, double y2) {
        if (x >= Math.min(x1, x2) && x <= Math.max(x1, x2) && y >= Math.min(y1, y2) && y <= Math.max(y1, y2)) {
            double l1 = Math.abs(x - x1);
            double l2 = Math.abs(y - y2);
            double l3 = Math.abs(x - x2);
            double l4 = Math.abs(y - y2);
            return r <= l1 && r <= l2 && r <= l3 && r <= l4;
        }
        return false;
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double x = x1 - x2;
        double y = y1 - y2;
        return Math.sqrt(x * x + y * y);
    }

    public static boolean isRectCollision(float x1, float y1, float w1, float h1, float x2, float y2, float w2, float h2) {
        if (x2 > x1 && x2 > x1 + w1) {
            return false;
        }
        if (x2 < x1 && x2 < x1 - w2) {
            return false;
        }
        if (y2 > y1 && y2 > y1 + h1) {
            return false;
        }
        return !(y2 < y1) || !(y2 < y1 - h2);
    }
}

