/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.StatFs;
import com.ab.global.AbAppConfig;
import com.ab.util.AbAppUtil;
import com.ab.util.AbImageUtil;
import com.ab.util.AbLogUtil;
import com.ab.util.AbMd5;
import com.ab.util.AbStrUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class AbFileUtil {
    private static String downloadRootDir = null;
    private static String imageDownloadDir = null;
    private static String fileDownloadDir = null;
    private static String cacheDownloadDir = null;
    private static String dbDownloadDir = null;
    private static int freeSdSpaceNeededToCache = 0xC800000;

    public static Bitmap getBitmapFromSD(String url, int type, int desiredWidth, int desiredHeight) {
        Bitmap bitmap;
        block5: {
            bitmap = null;
            try {
                if (!AbStrUtil.isEmpty(url)) break block5;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return bitmap;
            }
        }
        if (!AbFileUtil.isCanUseSD() || freeSdSpaceNeededToCache < AbFileUtil.freeSpaceOnSD()) {
            bitmap = AbFileUtil.getBitmapFromURL(url, type, desiredWidth, desiredHeight);
            return bitmap;
        }
        String downFilePath = AbFileUtil.downloadFile(url, imageDownloadDir);
        if (downFilePath != null) {
            return AbFileUtil.getBitmapFromSD(new File(downFilePath), type, desiredWidth, desiredHeight);
        }
        return null;
    }

    public static Bitmap getBitmapFromSD(File file, int type, int desiredWidth, int desiredHeight) {
        Bitmap bitmap;
        block5: {
            block4: {
                bitmap = null;
                if (AbFileUtil.isCanUseSD()) break block4;
                return null;
            }
            if (file.exists()) break block5;
            return null;
        }
        try {
            bitmap = type == 0 ? AbImageUtil.getCutBitmap(file, desiredWidth, desiredHeight) : (type == 1 ? AbImageUtil.getScaleBitmap(file, desiredWidth, desiredHeight) : AbImageUtil.getBitmap(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromSD(File file) {
        Bitmap bitmap;
        block5: {
            block4: {
                bitmap = null;
                if (AbFileUtil.isCanUseSD()) break block4;
                return null;
            }
            if (file.exists()) break block5;
            return null;
        }
        try {
            bitmap = AbImageUtil.getBitmap(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromByte(byte[] imgByte, String fileName, int type, int desiredWidth, int desiredHeight) {
        Bitmap bitmap;
        block33: {
            FileOutputStream fos = null;
            FilterInputStream dis = null;
            ByteArrayInputStream bis = null;
            bitmap = null;
            File file = null;
            try {
                try {
                    if (imgByte != null) {
                        file = new File(String.valueOf(imageDownloadDir) + fileName);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        fos = new FileOutputStream(file);
                        int readLength = 0;
                        bis = new ByteArrayInputStream(imgByte);
                        dis = new DataInputStream(bis);
                        byte[] buffer = new byte[1024];
                        while ((readLength = ((DataInputStream)dis).read(buffer)) != -1) {
                            fos.write(buffer, 0, readLength);
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        fos.flush();
                        bitmap = AbFileUtil.getBitmapFromSD(file, type, desiredWidth, desiredHeight);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fos == null) break block33;
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (Exception exception) {}
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromURL(String url, int type, int desiredWidth, int desiredHeight) {
        Bitmap bit = null;
        try {
            bit = AbImageUtil.getBitmap(url, type, desiredWidth, desiredHeight);
        }
        catch (Exception e) {
            AbLogUtil.d(AbFileUtil.class, "\u4e0b\u8f7d\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return bit;
    }

    public static Bitmap getBitmapFromSrc(String src) {
        Bitmap bit = null;
        try {
            bit = BitmapFactory.decodeStream((InputStream)AbFileUtil.class.getResourceAsStream(src));
        }
        catch (Exception e) {
            AbLogUtil.d(AbFileUtil.class, "\u83b7\u53d6\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return bit;
    }

    public static Bitmap getBitmapFromAsset(Context context, String fileName) {
        Bitmap bit = null;
        try {
            AssetManager assetManager = context.getAssets();
            InputStream is = assetManager.open(fileName);
            bit = BitmapFactory.decodeStream((InputStream)is);
        }
        catch (Exception e) {
            AbLogUtil.d(AbFileUtil.class, "\u83b7\u53d6\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return bit;
    }

    public static Drawable getDrawableFromAsset(Context context, String fileName) {
        Drawable drawable = null;
        try {
            AssetManager assetManager = context.getAssets();
            InputStream is = assetManager.open(fileName);
            drawable = Drawable.createFromStream((InputStream)is, null);
        }
        catch (Exception e) {
            AbLogUtil.d(AbFileUtil.class, "\u83b7\u53d6\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return drawable;
    }

    public static String downloadFile(String url, String dirPath) {
        InputStream in = null;
        FileOutputStream fileOutputStream = null;
        HttpURLConnection connection = null;
        String downFilePath = null;
        File file = null;
        try {
            String fileName;
            if (!AbFileUtil.isCanUseSD()) {
                return null;
            }
            String fileNameNoMIME = AbFileUtil.getCacheFileNameFromUrl(url);
            File parentFile = new File(imageDownloadDir);
            File[] files = parentFile.listFiles();
            int i = 0;
            while (i < files.length) {
                fileName = files[i].getName();
                String name = fileName.substring(0, fileName.lastIndexOf("."));
                if (name.equals(fileNameNoMIME)) {
                    String string = files[i].getPath();
                    return string;
                }
                ++i;
            }
            URL mUrl = new URL(url);
            connection = (HttpURLConnection)mUrl.openConnection();
            connection.connect();
            fileName = AbFileUtil.getCacheFileNameFromUrl(url, connection);
            file = new File(imageDownloadDir, fileName);
            downFilePath = file.getPath();
            if (file.exists()) {
                String string = file.getPath();
                return string;
            }
            file.createNewFile();
            try {
                in = connection.getInputStream();
                fileOutputStream = new FileOutputStream(file);
                byte[] b = new byte[1024];
                int temp = 0;
                while ((temp = in.read(b)) != -1) {
                    fileOutputStream.write(b, 0, temp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AbLogUtil.e(AbFileUtil.class, "\u6709\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519\u4e86,\u5df2\u5220\u9664");
                if (file != null) {
                    file.delete();
                }
                file = null;
                downFilePath = null;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return downFilePath;
    }

    public static int getContentLengthFromUrl(String Url) {
        int mContentLength = 0;
        try {
            URL url = new URL(Url);
            HttpURLConnection mHttpURLConnection = (HttpURLConnection)url.openConnection();
            mHttpURLConnection.setConnectTimeout(5000);
            mHttpURLConnection.setRequestMethod("GET");
            mHttpURLConnection.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            mHttpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
            mHttpURLConnection.setRequestProperty("Referer", Url);
            mHttpURLConnection.setRequestProperty("Charset", "UTF-8");
            mHttpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
            mHttpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            mHttpURLConnection.connect();
            if (mHttpURLConnection.getResponseCode() == 200) {
                mContentLength = mHttpURLConnection.getContentLength();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbLogUtil.d(AbFileUtil.class, "\u83b7\u53d6\u957f\u5ea6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return mContentLength;
    }

    public static String getRealFileNameFromUrl(String url) {
        String name = null;
        try {
            if (AbStrUtil.isEmpty(url)) {
                return name;
            }
            URL mUrl = new URL(url);
            HttpURLConnection mHttpURLConnection = (HttpURLConnection)mUrl.openConnection();
            mHttpURLConnection.setConnectTimeout(5000);
            mHttpURLConnection.setRequestMethod("GET");
            mHttpURLConnection.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            mHttpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
            mHttpURLConnection.setRequestProperty("Referer", url);
            mHttpURLConnection.setRequestProperty("Charset", "UTF-8");
            mHttpURLConnection.setRequestProperty("User-Agent", "");
            mHttpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            mHttpURLConnection.connect();
            if (mHttpURLConnection.getResponseCode() == 200) {
                String mine;
                int i = 0;
                while ((mine = mHttpURLConnection.getHeaderField(i)) != null) {
                    Matcher m;
                    if ("content-disposition".equals(mHttpURLConnection.getHeaderFieldKey(i).toLowerCase()) && (m = Pattern.compile(".*filename=(.*)").matcher(mine.toLowerCase())).find()) {
                        return m.group(1).replace("\"", "");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbLogUtil.e(AbFileUtil.class, "\u7f51\u7edc\u4e0a\u83b7\u53d6\u6587\u4ef6\u540d\u5931\u8d25");
        }
        return name;
    }

    public static String getRealFileName(HttpURLConnection connection) {
        String name = null;
        try {
            if (connection == null) {
                return name;
            }
            if (connection.getResponseCode() == 200) {
                String mime;
                int i = 0;
                while ((mime = connection.getHeaderField(i)) != null) {
                    Matcher m;
                    if ("content-disposition".equals(connection.getHeaderFieldKey(i).toLowerCase()) && (m = Pattern.compile(".*filename=(.*)").matcher(mime.toLowerCase())).find()) {
                        return m.group(1).replace("\"", "");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbLogUtil.e(AbFileUtil.class, "\u7f51\u7edc\u4e0a\u83b7\u53d6\u6587\u4ef6\u540d\u5931\u8d25");
        }
        return name;
    }

    public static String getRealFileName(HttpResponse response) {
        String name = null;
        try {
            if (response == null) {
                return name;
            }
            Header[] headers = response.getHeaders("content-disposition");
            int i = 0;
            while (i < headers.length) {
                Matcher m = Pattern.compile(".*filename=(.*)").matcher(headers[i].getValue());
                if (m.find()) {
                    name = m.group(1).replace("\"", "");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbLogUtil.e(AbFileUtil.class, "\u7f51\u7edc\u4e0a\u83b7\u53d6\u6587\u4ef6\u540d\u5931\u8d25");
        }
        return name;
    }

    public static String getCacheFileNameFromUrl(String url) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String name = null;
        try {
            name = AbMd5.MD5(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getCacheFileNameFromUrl(String url, HttpResponse response) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String name = null;
        try {
            String suffix = AbFileUtil.getMIMEFromUrl(url, response);
            if (AbStrUtil.isEmpty(suffix)) {
                suffix = ".ab";
            }
            name = String.valueOf(AbMd5.MD5(url)) + suffix;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getCacheFileNameFromUrl(String url, HttpURLConnection connection) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String name = null;
        try {
            String suffix = AbFileUtil.getMIMEFromUrl(url, connection);
            if (AbStrUtil.isEmpty(suffix)) {
                suffix = ".ab";
            }
            name = String.valueOf(AbMd5.MD5(url)) + suffix;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getMIMEFromUrl(String url, HttpURLConnection connection) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String suffix = null;
        try {
            String fileName;
            if (url.lastIndexOf(".") != -1 && ((suffix = url.substring(url.lastIndexOf("."))).indexOf("/") != -1 || suffix.indexOf("?") != -1 || suffix.indexOf("&") != -1)) {
                suffix = null;
            }
            if (AbStrUtil.isEmpty(suffix) && (fileName = AbFileUtil.getRealFileName(connection)) != null && fileName.lastIndexOf(".") != -1) {
                suffix = fileName.substring(fileName.lastIndexOf("."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return suffix;
    }

    public static String getMIMEFromUrl(String url, HttpResponse response) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String mime = null;
        try {
            String fileName;
            if (url.lastIndexOf(".") != -1 && ((mime = url.substring(url.lastIndexOf("."))).indexOf("/") != -1 || mime.indexOf("?") != -1 || mime.indexOf("&") != -1)) {
                mime = null;
            }
            if (AbStrUtil.isEmpty(mime) && (fileName = AbFileUtil.getRealFileName(response)) != null && fileName.lastIndexOf(".") != -1) {
                mime = fileName.substring(fileName.lastIndexOf("."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getByteArrayFromSD(String path) {
        byte[] bytes = null;
        ByteArrayOutputStream out = null;
        try {
            File file = new File(path);
            if (!AbFileUtil.isCanUseSD()) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                return null;
            }
            FileInputStream in = new FileInputStream(path);
            out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            int size = 0;
            while (true) {
                if ((size = in.read(buffer)) == -1) {
                    in.close();
                    bytes = out.toByteArray();
                    return bytes;
                }
                out.write(buffer, 0, size);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return bytes;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeByteArrayToSD(String path, byte[] content, boolean create) {
        FileOutputStream fos = null;
        try {
            File file = new File(path);
            if (!AbFileUtil.isCanUseSD()) {
                return;
            }
            if (!file.exists()) {
                if (!create) return;
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                    file.createNewFile();
                }
            }
            fos = new FileOutputStream(path);
            fos.write(content);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isCanUseSD() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void initFileDir(Context context) {
        PackageInfo info = AbAppUtil.getPackageInfo(context);
        String downloadRootPath = String.valueOf(File.separator) + AbAppConfig.DOWNLOAD_ROOT_DIR + File.separator + info.packageName + File.separator;
        String imageDownloadPath = String.valueOf(downloadRootPath) + AbAppConfig.DOWNLOAD_IMAGE_DIR + File.separator;
        String fileDownloadPath = String.valueOf(downloadRootPath) + AbAppConfig.DOWNLOAD_FILE_DIR + File.separator;
        String cacheDownloadPath = String.valueOf(downloadRootPath) + AbAppConfig.CACHE_DIR + File.separator;
        String dbDownloadPath = String.valueOf(downloadRootPath) + AbAppConfig.DB_DIR + File.separator;
        try {
            if (!AbFileUtil.isCanUseSD()) {
                return;
            }
            File root = Environment.getExternalStorageDirectory();
            File downloadDir = new File(String.valueOf(root.getAbsolutePath()) + downloadRootPath);
            if (!downloadDir.exists()) {
                downloadDir.mkdirs();
            }
            downloadRootDir = downloadDir.getPath();
            File cacheDownloadDirFile = new File(String.valueOf(root.getAbsolutePath()) + cacheDownloadPath);
            if (!cacheDownloadDirFile.exists()) {
                cacheDownloadDirFile.mkdirs();
            }
            cacheDownloadDir = cacheDownloadDirFile.getPath();
            File imageDownloadDirFile = new File(String.valueOf(root.getAbsolutePath()) + imageDownloadPath);
            if (!imageDownloadDirFile.exists()) {
                imageDownloadDirFile.mkdirs();
            }
            imageDownloadDir = imageDownloadDirFile.getPath();
            File fileDownloadDirFile = new File(String.valueOf(root.getAbsolutePath()) + fileDownloadPath);
            if (!fileDownloadDirFile.exists()) {
                fileDownloadDirFile.mkdirs();
            }
            fileDownloadDir = fileDownloadDirFile.getPath();
            File dbDownloadDirFile = new File(String.valueOf(root.getAbsolutePath()) + dbDownloadPath);
            if (!dbDownloadDirFile.exists()) {
                dbDownloadDirFile.mkdirs();
            }
            dbDownloadDir = dbDownloadDirFile.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int freeSpaceOnSD() {
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        double sdFreeMB = (double)stat.getAvailableBlocks() * (double)stat.getBlockSize() / 1024.0 * 1024.0;
        return (int)sdFreeMB;
    }

    public static boolean clearDownloadFile() {
        try {
            File fileDirectory = new File(downloadRootDir);
            AbFileUtil.deleteFile(fileDirectory);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean deleteFile(File file) {
        block8: {
            block7: {
                if (AbFileUtil.isCanUseSD()) break block7;
                return false;
            }
            if (file != null) break block8;
            return true;
        }
        try {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    AbFileUtil.deleteFile(files[i]);
                    ++i;
                }
            } else {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String readAssetsByName(Context context, String name, String encoding) {
        String text = null;
        InputStreamReader inputReader = null;
        BufferedReader bufReader = null;
        try {
            try {
                inputReader = new InputStreamReader(context.getAssets().open(name));
                bufReader = new BufferedReader(inputReader);
                String line = null;
                StringBuffer buffer = new StringBuffer();
                while ((line = bufReader.readLine()) != null) {
                    buffer.append(line);
                }
                text = new String(buffer.toString().getBytes(), encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bufReader != null) {
                        bufReader.close();
                    }
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public static String readRawByName(Context context, int id, String encoding) {
        String text = null;
        InputStreamReader inputReader = null;
        BufferedReader bufReader = null;
        try {
            try {
                inputReader = new InputStreamReader(context.getResources().openRawResource(id));
                bufReader = new BufferedReader(inputReader);
                String line = null;
                StringBuffer buffer = new StringBuffer();
                while ((line = bufReader.readLine()) != null) {
                    buffer.append(line);
                }
                text = new String(buffer.toString().getBytes(), encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bufReader != null) {
                        bufReader.close();
                    }
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public static String getDownloadRootDir(Context context) {
        if (downloadRootDir == null) {
            AbFileUtil.initFileDir(context);
        }
        return downloadRootDir;
    }

    public static String getImageDownloadDir(Context context) {
        if (downloadRootDir == null) {
            AbFileUtil.initFileDir(context);
        }
        return imageDownloadDir;
    }

    public static String getFileDownloadDir(Context context) {
        if (downloadRootDir == null) {
            AbFileUtil.initFileDir(context);
        }
        return fileDownloadDir;
    }

    public static String getCacheDownloadDir(Context context) {
        if (downloadRootDir == null) {
            AbFileUtil.initFileDir(context);
        }
        return cacheDownloadDir;
    }

    public static String getDbDownloadDir(Context context) {
        if (downloadRootDir == null) {
            AbFileUtil.initFileDir(context);
        }
        return dbDownloadDir;
    }

    public static int getFreeSdSpaceNeededToCache() {
        return freeSdSpaceNeededToCache;
    }

    public static class FileLastModifSort
    implements Comparator<File> {
        @Override
        public int compare(File arg0, File arg1) {
            if (arg0.lastModified() > arg1.lastModified()) {
                return 1;
            }
            if (arg0.lastModified() == arg1.lastModified()) {
                return 0;
            }
            return -1;
        }
    }
}

