/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import com.ab.util.AbLogUtil;
import com.ab.util.AbStrUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class AbDateUtil {
    public static final String dateFormatYMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String dateFormatYMD = "yyyy-MM-dd";
    public static final String dateFormatYM = "yyyy-MM";
    public static final String dateFormatYMDHM = "yyyy-MM-dd HH:mm";
    public static final String dateFormatMD = "MM/dd";
    public static final String dateFormatHMS = "HH:mm:ss";
    public static final String dateFormatHM = "HH:mm";
    public static final String AM = "AM";
    public static final String PM = "PM";

    public static Date getDateByFormat(String strDate, String format) {
        SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = mSimpleDateFormat.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public Date getDateByOffset(Date date, int calendarField, int offset) {
        GregorianCalendar c = new GregorianCalendar();
        try {
            c.setTime(date);
            ((Calendar)c).add(calendarField, offset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c.getTime();
    }

    public static String getStringByOffset(String strDate, String format, int calendarField, int offset) {
        String mDateTime = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.setTime(mSimpleDateFormat.parse(strDate));
            ((Calendar)c).add(calendarField, offset);
            mDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static String getStringByOffset(Date date, String format, int calendarField, int offset) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.setTime(date);
            ((Calendar)c).add(calendarField, offset);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getStringByFormat(Date date, String format) {
        SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
        String strDate = null;
        try {
            strDate = mSimpleDateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getStringByFormat(String strDate, String format) {
        String mDateTime = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(dateFormatYMDHMS);
            c.setTime(mSimpleDateFormat.parse(strDate));
            SimpleDateFormat mSimpleDateFormat2 = new SimpleDateFormat(format);
            mDateTime = mSimpleDateFormat2.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static String getStringByFormat(long milliseconds, String format) {
        String thisDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            thisDateTime = mSimpleDateFormat.format(milliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thisDateTime;
    }

    public static String getCurrentDate(String format) {
        AbLogUtil.d(AbDateUtil.class, "getCurrentDate:" + format);
        String curDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            curDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curDateTime;
    }

    public static String getCurrentDateByOffset(String format, int calendarField, int offset) {
        String mDateTime = null;
        try {
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            GregorianCalendar c = new GregorianCalendar();
            ((Calendar)c).add(calendarField, offset);
            mDateTime = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mDateTime;
    }

    public static int getOffectDay(long milliseconds1, long milliseconds2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(milliseconds1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(milliseconds2);
        int y1 = calendar1.get(1);
        int y2 = calendar2.get(1);
        int d1 = calendar1.get(6);
        int d2 = calendar2.get(6);
        int maxDays = 0;
        int day = 0;
        if (y1 - y2 > 0) {
            maxDays = calendar2.getActualMaximum(6);
            day = d1 - d2 + maxDays;
        } else if (y1 - y2 < 0) {
            maxDays = calendar1.getActualMaximum(6);
            day = d1 - d2 - maxDays;
        } else {
            day = d1 - d2;
        }
        return day;
    }

    public static int getOffectHour(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int h1 = calendar1.get(11);
        int h2 = calendar2.get(11);
        int h = 0;
        int day = AbDateUtil.getOffectDay(date1, date2);
        h = h1 - h2 + day * 24;
        return h;
    }

    public static int getOffectMinutes(long date1, long date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int m1 = calendar1.get(12);
        int m2 = calendar2.get(12);
        int h = AbDateUtil.getOffectHour(date1, date2);
        int m = 0;
        m = m1 - m2 + h * 60;
        return m;
    }

    public static String getFirstDayOfWeek(String format) {
        return AbDateUtil.getDayOfWeek(format, 2);
    }

    public static String getLastDayOfWeek(String format) {
        return AbDateUtil.getDayOfWeek(format, 1);
    }

    private static String getDayOfWeek(String format, int calendarField) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            int week = c.get(7);
            if (week == calendarField) {
                strDate = mSimpleDateFormat.format(c.getTime());
            } else {
                int offectDay = calendarField - week;
                if (calendarField == 1) {
                    offectDay = 7 - Math.abs(offectDay);
                }
                ((Calendar)c).add(5, offectDay);
                strDate = mSimpleDateFormat.format(c.getTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getFirstDayOfMonth(String format) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.set(5, 1);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String getLastDayOfMonth(String format) {
        String strDate = null;
        try {
            GregorianCalendar c = new GregorianCalendar();
            SimpleDateFormat mSimpleDateFormat = new SimpleDateFormat(format);
            c.set(5, 1);
            ((Calendar)c).roll(5, -1);
            strDate = mSimpleDateFormat.format(c.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static long getFirstTimeOfDay() {
        Date date = null;
        try {
            String currentDate = AbDateUtil.getCurrentDate(dateFormatYMD);
            date = AbDateUtil.getDateByFormat(String.valueOf(currentDate) + " 00:00:00", dateFormatYMDHMS);
            return date.getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long getLastTimeOfDay() {
        Date date = null;
        try {
            String currentDate = AbDateUtil.getCurrentDate(dateFormatYMD);
            date = AbDateUtil.getDateByFormat(String.valueOf(currentDate) + " 24:00:00", dateFormatYMDHMS);
            return date.getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 400 != 0 || year % 400 == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String formatDateStr2Desc(String strDate, String outFormat) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormatYMDHMS);
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            String out;
            c2.setTime(df.parse(strDate));
            c1.setTime(new Date());
            int d = AbDateUtil.getOffectDay(c1.getTimeInMillis(), c2.getTimeInMillis());
            if (d == 0) {
                int h = AbDateUtil.getOffectHour(c1.getTimeInMillis(), c2.getTimeInMillis());
                if (h > 0) {
                    return "\u4eca\u5929" + AbDateUtil.getStringByFormat(strDate, dateFormatHM);
                }
                if (h >= 0 && h == 0) {
                    int m = AbDateUtil.getOffectMinutes(c1.getTimeInMillis(), c2.getTimeInMillis());
                    if (m > 0) {
                        return String.valueOf(m) + "\u5206\u949f\u524d";
                    }
                    if (m >= 0) {
                        return "\u521a\u521a";
                    }
                }
            } else if (d > 0 ? d != 1 : d >= 0 || d != -1) {
                // empty if block
            }
            if (AbStrUtil.isEmpty(out = AbDateUtil.getStringByFormat(strDate, outFormat))) return strDate;
            return out;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strDate;
    }

    public static String getWeekNumber(String strDate, String inFormat) {
        String week = "\u661f\u671f\u65e5";
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat df = new SimpleDateFormat(inFormat);
        try {
            calendar.setTime(df.parse(strDate));
        }
        catch (Exception e) {
            return "\u9519\u8bef";
        }
        int intTemp = calendar.get(7) - 1;
        switch (intTemp) {
            case 0: {
                week = "\u661f\u671f\u65e5";
                break;
            }
            case 1: {
                week = "\u661f\u671f\u4e00";
                break;
            }
            case 2: {
                week = "\u661f\u671f\u4e8c";
                break;
            }
            case 3: {
                week = "\u661f\u671f\u4e09";
                break;
            }
            case 4: {
                week = "\u661f\u671f\u56db";
                break;
            }
            case 5: {
                week = "\u661f\u671f\u4e94";
                break;
            }
            case 6: {
                week = "\u661f\u671f\u516d";
            }
        }
        return week;
    }

    public static String getTimeQuantum(String strDate, String format) {
        Date mDate = AbDateUtil.getDateByFormat(strDate, format);
        int hour = mDate.getHours();
        if (hour >= 12) {
            return PM;
        }
        return AM;
    }

    public static String getTimeDescription(long milliseconds) {
        if (milliseconds > 1000L) {
            if (milliseconds / 1000L / 60L > 1L) {
                long minute = milliseconds / 1000L / 60L;
                long second = milliseconds / 1000L % 60L;
                return String.valueOf(minute) + "\u5206" + second + "\u79d2";
            }
            return String.valueOf(milliseconds / 1000L) + "\u79d2";
        }
        return String.valueOf(milliseconds) + "\u6beb\u79d2";
    }

    public static void main(String[] args) {
        System.out.println(AbDateUtil.formatDateStr2Desc("2012-3-2 12:2:20", "MM\u6708dd\u65e5  HH:mm"));
    }
}

