/*
 * Decompiled with CFR 0.152.
 */
package com.ab.soap;

import android.content.Context;
import com.ab.global.AbAppConfig;
import com.ab.global.AbAppException;
import com.ab.soap.AbSoapListener;
import com.ab.soap.AbSoapParams;
import com.ab.task.AbThreadFactory;
import com.ab.util.AbAppUtil;
import com.ab.util.AbLogUtil;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransportSE;

public class AbSoapClient {
    private static Context mContext;
    public static Executor mExecutorService;
    private boolean mDotNet = true;
    private AbSoapParams mParams = null;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private int mTimeout = 10000;

    static {
        mExecutorService = null;
    }

    public AbSoapClient(Context context) {
        mContext = context;
        mExecutorService = AbThreadFactory.getExecutorService();
    }

    public void call(final String url, final String nameSpace, final String methodName, AbSoapParams Params, final AbSoapListener listener) {
        this.mParams = Params;
        if (!AbAppUtil.isNetworkAvailable(mContext)) {
            listener.sendFailureMessage(600, AbAppConfig.CONNECT_EXCEPTION, new AbAppException(AbAppConfig.CONNECT_EXCEPTION));
            return;
        }
        listener.sendStartMessage();
        mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbSoapClient.this.doCall(url, nameSpace, methodName, AbSoapClient.this.mParams, listener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void doCall(String url, String nameSpace, String methodName, AbSoapParams params, AbSoapListener listener) {
        String result = null;
        try {
            SoapObject request = new SoapObject(nameSpace, methodName);
            List<BasicNameValuePair> paramsList = params.getParamsList();
            for (NameValuePair nameValuePair : paramsList) {
                request.addProperty(nameValuePair.getName(), (Object)nameValuePair.getValue());
            }
            SoapSerializationEnvelope soapSerializationEnvelope = new SoapSerializationEnvelope(110);
            soapSerializationEnvelope.bodyOut = request;
            soapSerializationEnvelope.dotNet = this.mDotNet;
            soapSerializationEnvelope.setOutputSoapObject((Object)request);
            HttpTransportSE httpTransportSE = new HttpTransportSE(url, this.mTimeout);
            httpTransportSE.debug = true;
            AbLogUtil.d(AbSoapClient.class, "--call--");
            httpTransportSE.call(String.valueOf(nameSpace) + methodName, (SoapEnvelope)soapSerializationEnvelope);
            SoapObject bodyIn = (SoapObject)soapSerializationEnvelope.bodyIn;
            result = bodyIn.toString();
            if (result != null) {
                listener.sendSuccessMessage(200, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            listener.sendFailureMessage(900, AbAppConfig.UNTREATED_EXCEPTION, new AbAppException(AbAppConfig.UNTREATED_EXCEPTION));
        }
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public boolean isDotNet() {
        return this.mDotNet;
    }

    public void setDotNet(boolean dotNet) {
        this.mDotNet = dotNet;
    }
}

