/*
 * Decompiled with CFR 0.152.
 */
package com.ab.image.toolbox;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.ab.network.toolbox.DefaultRetryPolicy;
import com.ab.network.toolbox.HttpHeaderParser;
import com.ab.network.toolbox.NetworkResponse;
import com.ab.network.toolbox.ParseError;
import com.ab.network.toolbox.Request;
import com.ab.network.toolbox.Response;
import com.ab.network.toolbox.VolleyLog;
import com.ab.util.AbImageUtil;

public class ImageRequest
extends Request<Bitmap> {
    private static final int IMAGE_TIMEOUT_MS = 1000;
    private static final int IMAGE_MAX_RETRIES = 2;
    private static final float IMAGE_BACKOFF_MULT = 2.0f;
    private final Response.Listener<Bitmap> mListener;
    private final Bitmap.Config mDecodeConfig;
    private final int mMaxWidth;
    private final int mMaxHeight;
    private final int mExpiresTime;
    private static final Object sDecodeLock = new Object();

    public ImageRequest(String url, Response.Listener<Bitmap> listener, int maxWidth, int maxHeight, Bitmap.Config decodeConfig, Response.ErrorListener errorListener, int expiresTime) {
        super(0, url, errorListener);
        this.setRetryPolicy(new DefaultRetryPolicy(1000, 2, 2.0f));
        this.mListener = listener;
        this.mDecodeConfig = decodeConfig;
        this.mMaxWidth = maxWidth;
        this.mMaxHeight = maxHeight;
        this.mExpiresTime = expiresTime;
    }

    @Override
    public Request.Priority getPriority() {
        return Request.Priority.LOW;
    }

    private static int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        int resized = maxPrimary;
        double ratio = (double)actualSecondary / (double)actualPrimary;
        if ((double)resized * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response<Bitmap> parseNetworkResponse(NetworkResponse response) {
        Object object = sDecodeLock;
        synchronized (object) {
            try {
                return this.doParse(response);
            }
            catch (OutOfMemoryError e) {
                VolleyLog.e("Caught OOM for %d byte image, url=%s", response.data.length, this.getUrl());
                return Response.error(new ParseError(e));
            }
        }
    }

    private Response<Bitmap> doParse(NetworkResponse response) {
        byte[] data = response.data;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        Bitmap bitmap = null;
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            decodeOptions.inPreferredConfig = this.mDecodeConfig;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
        } else {
            decodeOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, actualWidth, actualHeight);
            int desiredHeight = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, actualHeight, actualWidth);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = ImageRequest.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
            bitmap = tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight) ? AbImageUtil.getScaleBitmap(tempBitmap, desiredWidth, desiredHeight) : tempBitmap;
        }
        if (bitmap == null) {
            return Response.error(new ParseError(response));
        }
        return Response.success(bitmap, HttpHeaderParser.parseCacheHeaders(response, this.mExpiresTime));
    }

    @Override
    protected void deliverResponse(Bitmap response) {
        this.mListener.onResponse(response);
    }

    static int findBestSampleSize(int actualWidth, int actualHeight, int desiredWidth, int desiredHeight) {
        double wr = (double)actualWidth / (double)desiredWidth;
        double hr = (double)actualHeight / (double)desiredHeight;
        double ratio = Math.min(wr, hr);
        float n = 1.0f;
        while ((double)(n * 2.0f) <= ratio) {
            n *= 2.0f;
        }
        return (int)n;
    }
}

