/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.serial.rtu;

import com.zgkxzx.modbus4And.exception.ModbusInitException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ModbusRequest;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.serial.SerialMaster;
import com.zgkxzx.modbus4And.serial.SerialPortWrapper;
import com.zgkxzx.modbus4And.serial.SerialWaitingRoomKeyFactory;
import com.zgkxzx.modbus4And.serial.rtu.RtuMessageParser;
import com.zgkxzx.modbus4And.serial.rtu.RtuMessageRequest;
import com.zgkxzx.modbus4And.serial.rtu.RtuMessageResponse;
import com.zgkxzx.modbus4And.sero.ShouldNeverHappenException;
import com.zgkxzx.modbus4And.sero.messaging.MessageControl;
import com.zgkxzx.modbus4And.sero.messaging.StreamTransport;
import java.io.IOException;

public class RtuMaster
extends SerialMaster {
    private MessageControl conn;
    private long lastSendTime;
    private long messageFrameSpacing;

    public RtuMaster(SerialPortWrapper wrapper) {
        this(wrapper, true);
    }

    public RtuMaster(SerialPortWrapper wrapper, long characterSpacingNs, long messageFrameSpacingNs) {
        super(wrapper);
        this.characterSpacing = characterSpacingNs;
        this.messageFrameSpacing = messageFrameSpacingNs;
    }

    public RtuMaster(SerialPortWrapper wrapper, boolean useDefaultSpacing) {
        super(wrapper);
        if (useDefaultSpacing) {
            this.messageFrameSpacing = RtuMaster.computeMessageFrameSpacing(wrapper);
            this.characterSpacing = RtuMaster.computeCharacterSpacing(wrapper);
        } else {
            this.messageFrameSpacing = 0L;
            this.characterSpacing = 0L;
        }
    }

    @Override
    public void init() throws ModbusInitException {
        super.init();
        RtuMessageParser rtuMessageParser = new RtuMessageParser(true);
        this.conn = this.getMessageControl();
        try {
            this.conn.start(this.transport, rtuMessageParser, null, new SerialWaitingRoomKeyFactory());
            if (this.getePoll() == null) {
                ((StreamTransport)this.transport).start("Modbus RTU master");
            }
        }
        catch (IOException e) {
            throw new ModbusInitException(e);
        }
        this.initialized = true;
    }

    @Override
    public void destroy() {
        this.closeMessageControl(this.conn);
        super.close();
    }

    @Override
    public ModbusResponse sendImpl(ModbusRequest request) throws ModbusTransportException {
        RtuMessageRequest rtuRequest = new RtuMessageRequest(request);
        try {
            RtuMessageResponse rtuResponse;
            long waited = System.nanoTime() - this.lastSendTime;
            if (waited < this.messageFrameSpacing) {
                Thread.sleep(this.messageFrameSpacing / 1000000L, (int)(this.messageFrameSpacing % 1000000L));
            }
            if ((rtuResponse = (RtuMessageResponse)this.conn.send(rtuRequest)) == null) {
                ModbusResponse modbusResponse = null;
                return modbusResponse;
            }
            ModbusResponse modbusResponse = rtuResponse.getModbusResponse();
            return modbusResponse;
        }
        catch (Exception e) {
            throw new ModbusTransportException(e, request.getSlaveId());
        }
        finally {
            this.lastSendTime = System.nanoTime();
        }
    }

    public static long computeMessageFrameSpacing(SerialPortWrapper wrapper) {
        if (wrapper.getBaudRate() > 19200) {
            return 1750000L;
        }
        float charTime = RtuMaster.computeCharacterTime(wrapper);
        return (long)(charTime * 3.5f);
    }

    public static long computeCharacterSpacing(SerialPortWrapper wrapper) {
        if (wrapper.getBaudRate() > 19200) {
            return 750000L;
        }
        float charTime = RtuMaster.computeCharacterTime(wrapper);
        return (long)(charTime * 1.5f);
    }

    public static float computeCharacterTime(SerialPortWrapper wrapper) {
        float charBits = wrapper.getDataBits();
        switch (wrapper.getStopBits()) {
            case 1: {
                break;
            }
            case 2: {
                charBits += 2.0f;
                break;
            }
            case 3: {
                charBits += 1.5f;
                break;
            }
            default: {
                throw new ShouldNeverHappenException("Unknown stop bit size: " + wrapper.getStopBits());
            }
        }
        if (wrapper.getParity() > 0) {
            charBits += 1.0f;
        }
        return charBits / (float)wrapper.getBaudRate() * 1.0E9f;
    }
}

