/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.msg;

import com.zgkxzx.modbus4And.Modbus;
import com.zgkxzx.modbus4And.ProcessImage;
import com.zgkxzx.modbus4And.base.ModbusUtils;
import com.zgkxzx.modbus4And.exception.IllegalDataAddressException;
import com.zgkxzx.modbus4And.exception.ModbusTransportException;
import com.zgkxzx.modbus4And.msg.ExceptionRequest;
import com.zgkxzx.modbus4And.msg.ModbusMessage;
import com.zgkxzx.modbus4And.msg.ModbusResponse;
import com.zgkxzx.modbus4And.msg.ReadCoilsRequest;
import com.zgkxzx.modbus4And.msg.ReadDiscreteInputsRequest;
import com.zgkxzx.modbus4And.msg.ReadExceptionStatusRequest;
import com.zgkxzx.modbus4And.msg.ReadHoldingRegistersRequest;
import com.zgkxzx.modbus4And.msg.ReadInputRegistersRequest;
import com.zgkxzx.modbus4And.msg.ReportSlaveIdRequest;
import com.zgkxzx.modbus4And.msg.WriteCoilRequest;
import com.zgkxzx.modbus4And.msg.WriteCoilsRequest;
import com.zgkxzx.modbus4And.msg.WriteRegisterRequest;
import com.zgkxzx.modbus4And.msg.WriteRegistersRequest;
import com.zgkxzx.modbus4And.sero.util.queue.ByteQueue;

public abstract class ModbusRequest
extends ModbusMessage {
    public static ModbusRequest createModbusRequest(ByteQueue queue) throws ModbusTransportException {
        int slaveId = ModbusUtils.popUnsignedByte(queue);
        byte functionCode = queue.pop();
        ModbusRequest request = null;
        request = functionCode == 1 ? new ReadCoilsRequest(slaveId) : (functionCode == 2 ? new ReadDiscreteInputsRequest(slaveId) : (functionCode == 3 ? new ReadHoldingRegistersRequest(slaveId) : (functionCode == 4 ? new ReadInputRegistersRequest(slaveId) : (functionCode == 5 ? new WriteCoilRequest(slaveId) : (functionCode == 6 ? new WriteRegisterRequest(slaveId) : (functionCode == 7 ? new ReadExceptionStatusRequest(slaveId) : (functionCode == 15 ? new WriteCoilsRequest(slaveId) : (functionCode == 16 ? new WriteRegistersRequest(slaveId) : (functionCode == 17 ? new ReportSlaveIdRequest(slaveId) : new ExceptionRequest(slaveId, functionCode, 1))))))))));
        ((ModbusRequest)request).readRequest(queue);
        return request;
    }

    ModbusRequest(int slaveId) throws ModbusTransportException {
        super(slaveId);
    }

    public abstract void validate(Modbus var1) throws ModbusTransportException;

    public ModbusResponse handle(ProcessImage processImage) throws ModbusTransportException {
        try {
            try {
                return this.handleImpl(processImage);
            }
            catch (IllegalDataAddressException e) {
                return this.handleException((byte)2);
            }
        }
        catch (Exception e) {
            return this.handleException((byte)4);
        }
    }

    abstract ModbusResponse handleImpl(ProcessImage var1) throws ModbusTransportException;

    protected abstract void readRequest(ByteQueue var1);

    ModbusResponse handleException(byte exceptionCode) throws ModbusTransportException {
        ModbusResponse response = this.getResponseInstance(this.slaveId);
        response.setException(exceptionCode);
        return response;
    }

    abstract ModbusResponse getResponseInstance(int var1) throws ModbusTransportException;

    @Override
    protected final void writeImpl(ByteQueue queue) {
        queue.push(this.getFunctionCode());
        this.writeRequest(queue);
    }

    protected abstract void writeRequest(ByteQueue var1);
}

