/*
 * Decompiled with CFR 0.152.
 */
package com.zgkxzx.modbus4And.base;

import com.zgkxzx.modbus4And.ExceptionResult;
import com.zgkxzx.modbus4And.base.SlaveAndRange;
import com.zgkxzx.modbus4And.locator.BaseLocator;

public class KeyedModbusLocator<K> {
    private final K key;
    private final BaseLocator<?> locator;

    public KeyedModbusLocator(K key, BaseLocator<?> locator) {
        this.key = key;
        this.locator = locator;
    }

    public K getKey() {
        return this.key;
    }

    public BaseLocator<?> getLocator() {
        return this.locator;
    }

    public String toString() {
        return "KeyedModbusLocator(key=" + this.key + ", locator=" + this.locator + ")";
    }

    public int getDataType() {
        return this.locator.getDataType();
    }

    public int getOffset() {
        return this.locator.getOffset();
    }

    public SlaveAndRange getSlaveAndRange() {
        return new SlaveAndRange(this.locator.getSlaveId(), this.locator.getRange());
    }

    public int getEndOffset() {
        return this.locator.getEndOffset();
    }

    public int getRegisterCount() {
        return this.locator.getRegisterCount();
    }

    public Object bytesToValue(byte[] data, int requestOffset) {
        try {
            return this.locator.bytesToValue(data, requestOffset);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new ExceptionResult(2);
        }
    }
}

