/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.util;

import com.baidu.idl.face.util.StuLogEx;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class FileUtil {
    private static final String TAG = "FileUtil";

    private FileUtil() {
        throw new RuntimeException("This class instance can not be created.");
    }

    public static boolean savePropertiesFile(File file, Properties properties) {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            properties.store(out, null);
            return true;
        }
        catch (Exception e) {
            StuLogEx.e(TAG, e.getMessage(), e);
            return false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean loadPropertiesFile(File file, Properties properties) {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            properties.load(in);
            return true;
        }
        catch (Exception e) {
            StuLogEx.e(TAG, e.getMessage(), e);
            return false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean createFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists() && file.length() > 0x300000L) {
            file.delete();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                StuLogEx.e(TAG, "\u9352\u6d98\u7f13\u93c2\u56e6\u6b22\u6fb6\u8fab\u89e6", e);
                return false;
            }
        }
        return true;
    }
}

