/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.statistics;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.baidu.idl.face.license.License;
import com.baidu.idl.face.util.FileUtil;
import com.baidu.idl.face.util.NetUtil;
import com.baidu.idl.face.util.StuLogEx;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class Statistics {
    private static final String TAG = "AuthenticationStatistics";
    private static final String SERVER_URL = "http://sdkss.shitu.baidu.com/cgi-bin/sdkstat.py";
    private static final String AS_FILE_NAME = "as";
    private static final int MESSAGE_INSTANT_SYNC_FILE = 1;
    private static final int MESSAGE_INTERVAL_SYNC_FILE = 2;
    private static final long SYNC_FILE_DELAY_TIME = 3000L;
    private Context app = null;
    private String appId = null;
    private String userId = null;
    private String al_version = null;
    private String au_version = null;
    private boolean isInit = false;
    private File asFile = null;
    private final Properties as = new Properties();
    private HandlerThread workerThread = null;
    private Handler workerHandler = null;

    public boolean init(Context app, String appId) {
        if (this.isInit) {
            return true;
        }
        if (app == null || appId == null || "".equals(appId)) {
            throw new IllegalArgumentException("The params is invalid!");
        }
        this.app = app;
        this.appId = appId;
        try {
            this.userId = "";
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        this.al_version = License.getAlgorithmVersion();
        this.au_version = License.getAuthorityVersion();
        this.workerThread = new HandlerThread("workerThread");
        this.workerThread.start();
        this.workerHandler = new Handler(this.workerThread.getLooper()){

            public void handleMessage(Message msg) {
                if (msg.what == 1 || msg.what == 2) {
                    FileUtil.savePropertiesFile(Statistics.this.asFile, Statistics.this.as);
                }
            }
        };
        if (!this.initFile()) {
            return false;
        }
        if (NetUtil.isConnected(app) && this.as.size() > 0) {
            final Properties asCopy = (Properties)this.as.clone();
            this.as.clear();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    NetUtil.uploadData(new NetUtil.RequestAdapter<StatisticsResult>(){

                        @Override
                        public String getURL() {
                            return Statistics.SERVER_URL;
                        }

                        @Override
                        public String getRequestString() {
                            StringBuilder sb = new StringBuilder();
                            for (Map.Entry<Object, Object> entry : asCopy.entrySet()) {
                                String[] values;
                                String key = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                String[] stringArray = values = value.split("-");
                                int n = values.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String timeStamp = stringArray[n2];
                                    sb.append(Statistics.this.appId).append(" ");
                                    sb.append(Statistics.this.userId).append(" ");
                                    sb.append(key).append(" ");
                                    sb.append(timeStamp).append(" ");
                                    sb.append(Statistics.this.au_version).append(" ");
                                    sb.append(Statistics.this.al_version);
                                    sb.append("\n");
                                    ++n2;
                                }
                            }
                            return sb.toString();
                        }

                        @Override
                        public StatisticsResult parseResponse(InputStream in) throws IOException, JSONException {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            byte[] buffer = new byte[1024];
                            int len = 0;
                            try {
                                while ((len = in.read(buffer)) > 0) {
                                    out.write(buffer, 0, len);
                                }
                                out.flush();
                                JSONObject json = new JSONObject(new String(out.toByteArray(), "UTF-8"));
                                StatisticsResult statisticsResult = new StatisticsResult(json.getInt("errno"), json.getString("errnmsg"));
                                return statisticsResult;
                            }
                            finally {
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }

                        @Override
                        public void onResponse(int code, StatisticsResult result, Exception e) {
                            if (code != 0) {
                                StuLogEx.e(Statistics.TAG, e.getMessage(), e);
                            } else if (result.errno != 0) {
                                StuLogEx.e(Statistics.TAG, result.errmsg);
                            } else {
                                asCopy.clear();
                            }
                            Statistics.this.merge(asCopy);
                        }
                    });
                }
            }).start();
        }
        this.isInit = true;
        return true;
    }

    private boolean initFile() {
        this.asFile = new File(this.app.getFilesDir(), AS_FILE_NAME);
        if (!FileUtil.createFile(this.asFile)) {
            return false;
        }
        return FileUtil.loadPropertiesFile(this.asFile, this.as);
    }

    public synchronized void triggerEvent(String eventId) {
        if (!this.isInit) {
            throw new IllegalStateException("please init first!");
        }
        if (!this.as.containsKey(eventId)) {
            this.as.setProperty(eventId, String.valueOf(System.currentTimeMillis()));
        } else {
            String timeStamp = String.format(Locale.getDefault(), "%s-%s", this.as.getProperty(eventId), System.currentTimeMillis());
            this.as.setProperty(eventId, timeStamp);
        }
        this.syncFile(false);
    }

    private synchronized void merge(Properties asCopy) {
        for (Map.Entry<Object, Object> entry : asCopy.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!this.as.containsKey(key)) {
                this.as.setProperty(key, value);
                continue;
            }
            String timeStamp = String.format(Locale.getDefault(), "%s-%s", value, this.as.getProperty(key));
            this.as.setProperty(key, timeStamp);
        }
        this.syncFile(true);
    }

    private void syncFile(boolean isInstant) {
        if (isInstant) {
            this.workerHandler.removeMessages(1);
            this.workerHandler.sendEmptyMessage(1);
        } else {
            this.workerHandler.removeMessages(2);
            this.workerHandler.sendEmptyMessageDelayed(2, 3000L);
        }
    }

    private Statistics() {
    }

    public static Statistics getInstance() {
        return Holder.instance;
    }

    /* synthetic */ Statistics(Statistics statistics) {
        this();
    }

    private static final class Holder {
        private static final Statistics instance = new Statistics(null);

        private Holder() {
        }
    }

    private static final class StatisticsResult {
        public int errno;
        public String errmsg;

        public StatisticsResult(int errno, String errmsg) {
            this.errno = errno;
            this.errmsg = errmsg;
        }
    }
}

