/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.license;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.baidu.idl.face.authority.AuthorityState;
import com.baidu.idl.face.authority.IDLAuthorityException;
import com.baidu.idl.face.util.HttpClient;
import com.baidu.idl.face.util.StuLogEx;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class License {
    private static final String URL = "http://sdkss.shitu.baidu.com/cgi-bin/queryLicense.py";
    private static final String LICENSE_FILE = "license";
    private static final String LICENSE_ASSET_FILE = "idl_license";
    private ArrayList<String> mALLicense;
    private static License mInstance = null;
    private int mAuthorityStatus = 256;

    public static synchronized License getInstance() {
        if (mInstance == null) {
            mInstance = new License();
        }
        return mInstance;
    }

    private License() {
    }

    public int init(Context context, String apiKey) {
        if (272 == this.mAuthorityStatus) {
            return this.mAuthorityStatus;
        }
        this.mAuthorityStatus = 272;
        this.mAuthorityStatus = this.verifyByLocalData(context, apiKey);
        Log.e((String)LICENSE_ASSET_FILE, (String)("Local License Authority State Is :" + AuthorityState.getStateName(this.mAuthorityStatus)));
        if (this.mAuthorityStatus > 48) {
            this.mAuthorityStatus = this.verifyByNetworkData(context, apiKey);
            Log.e((String)LICENSE_ASSET_FILE, (String)("Net License Authority State Is :" + AuthorityState.getStateName(this.mAuthorityStatus)));
        }
        if (this.mAuthorityStatus > 48) {
            throw new IDLAuthorityException(AuthorityState.getStateName(this.mAuthorityStatus));
        }
        return this.mAuthorityStatus;
    }

    public int init(String aToken) {
        if (272 == this.mAuthorityStatus) {
            return this.mAuthorityStatus;
        }
        this.mAuthorityStatus = 272;
        if (aToken != null && aToken.length() > 0) {
            this.mAuthorityStatus = this.initLicenseWithToken(aToken);
            if (this.mAuthorityStatus != 0) {
                this.mAuthorityStatus = 51;
            }
        } else {
            this.mAuthorityStatus = 51;
        }
        return this.mAuthorityStatus;
    }

    private int verifyByLocalData(final Context context, final String apiKey) {
        int state = 49;
        this.mALLicense = this.getLocalLicense(context, apiKey);
        if (this.mALLicense != null && this.mALLicense.size() > 0) {
            String[] licenses = this.mALLicense.toArray(new String[this.mALLicense.size()]);
            state = this.initLicense(context, apiKey, licenses);
            if (state == 0) {
                StuLogEx.e("FaceSDK", "license is vaild.");
            } else if (state == 16) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        License.this.getLatestLicense(context, apiKey);
                    }
                }).start();
            } else {
                this.deleteErrorLicense(context);
            }
        } else {
            Log.e((String)LICENSE_ASSET_FILE, (String)"my license is null");
        }
        return state;
    }

    private int verifyByNetworkData(Context context, String apiKey) {
        int state = 240;
        this.mALLicense = this.getLicenseByNetwork(context, apiKey);
        Log.e((String)LICENSE_ASSET_FILE, (String)("Net License:" + this.mALLicense));
        if (this.mALLicense != null && this.mALLicense.size() > 0) {
            String[] licenses = this.mALLicense.toArray(new String[this.mALLicense.size()]);
            state = this.initLicense(context, apiKey, licenses);
            if (state < 48) {
                this.WriteLicense(context, this.mALLicense);
            }
        } else {
            state = 49;
            this.deleteErrorLicense(context);
        }
        return state;
    }

    private ArrayList<String> getLocalLicense(Context context, String apiKey) {
        ArrayList<String> licenses = null;
        licenses = this.ReadLicenseFromData(context);
        if (licenses == null || licenses.size() < 1) {
            licenses = this.ReadLicenseFromAsset(context);
        }
        return licenses;
    }

    private ArrayList<String> getLicenseByNetwork(Context context, String apiKey) {
        ArrayList<String> licenses = null;
        String data = this.getPostData(context, apiKey);
        Log.e((String)"PostData", (String)data);
        String response = HttpClient.post(URL, data);
        Log.e((String)"response", (String)response);
        int errno = -1;
        String msg = null;
        if (response == null) {
            msg = "The resopnse is null";
            return licenses;
        }
        JSONObject object = null;
        try {
            object = new JSONObject(response);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (object != null) {
            errno = object.optInt("errno", -1);
            msg = object.optString("msg");
            JSONArray json_licenses = object.optJSONArray(LICENSE_FILE);
            if (json_licenses != null && json_licenses.length() > 0) {
                licenses = new ArrayList<String>();
                int i = 0;
                while (i < json_licenses.length()) {
                    String tmp = json_licenses.optString(i);
                    if (tmp != null) {
                        licenses.add(tmp);
                    }
                    ++i;
                }
            } else {
                errno = -1;
                msg = "There is no license in resopnse";
            }
            if (errno == 0 && json_licenses != null && json_licenses.length() > 0) {
                StuLogEx.e("License", "resonpse is right.");
            } else {
                licenses = null;
            }
        }
        return licenses;
    }

    private void getLatestLicense(Context context, String apiKey) {
        String[] licensesarray;
        int status;
        ArrayList<String> licenses = null;
        licenses = this.getLicenseByNetwork(context, apiKey);
        if (licenses != null && licenses.size() > 0 && (status = this.initLicense(context, apiKey, licensesarray = licenses.toArray(new String[licenses.size()]))) < 48) {
            this.WriteLicense(context, licenses);
            StuLogEx.e("LatestLicense:", " " + licenses);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean WriteLicense(Context context, ArrayList<String> licenses) {
        if (licenses == null || licenses.size() == 0 || context == null) {
            return false;
        }
        boolean isSuccess = true;
        File file = context.getDir(LICENSE_FILE, 0);
        file.delete();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                for (String license : licenses) {
                    fout.write(license.getBytes());
                    fout.write(10);
                }
                return isSuccess;
            }
            catch (FileNotFoundException e) {
                isSuccess = false;
                e.printStackTrace();
                if (fout == null) return isSuccess;
                try {
                    fout.close();
                    return isSuccess;
                }
                catch (IOException e2) {
                    isSuccess = false;
                    e2.printStackTrace();
                }
                return isSuccess;
            }
            catch (IOException e) {
                isSuccess = false;
                e.printStackTrace();
                if (fout == null) return isSuccess;
                try {
                    fout.close();
                    return isSuccess;
                }
                catch (IOException e3) {
                    isSuccess = false;
                    e3.printStackTrace();
                }
                return isSuccess;
            }
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    isSuccess = false;
                    e.printStackTrace();
                }
            }
        }
    }

    public ArrayList<String> ReadLicenseFromAsset(Context context) {
        ArrayList<String> licenses;
        block15: {
            licenses = null;
            AssetManager am = context.getAssets();
            InputStream is = null;
            try {
                try {
                    is = am.open(LICENSE_ASSET_FILE);
                    licenses = this.analyseLicense(is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (licenses != null && licenses.size() > 0) {
            this.WriteLicense(context, licenses);
        }
        return licenses;
    }

    private ArrayList<String> analyseLicense(InputStream is) throws IOException {
        String line;
        BufferedReader br = null;
        InputStreamReader reader = null;
        reader = new InputStreamReader(is);
        br = new BufferedReader(reader);
        ArrayList<String> licenses = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            licenses.add(line);
        }
        return licenses;
    }

    public ArrayList<String> ReadLicenseFromData(Context context) {
        if (context == null) {
            return null;
        }
        File file = context.getDir(LICENSE_FILE, 0);
        ArrayList<String> licenses = null;
        try {
            licenses = this.analyseLicense(new FileInputStream(file));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return licenses;
    }

    public void deleteErrorLicense(Context context) {
        if (context == null) {
            return;
        }
        File file = context.getDir(LICENSE_FILE, 0);
        if (file.exists()) {
            file.delete();
        }
    }

    public native int initLicense(Context var1, String var2, String[] var3);

    public native int initLicenseWithToken(String var1);

    public static native String getAlgorithmVersion();

    public static native String getAuthorityVersion();

    public native String getPostData(Context var1, String var2);
}

