/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facesdk;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.baidu.idl.face.authority.IDLAuthorityException;
import com.baidu.idl.facesdk.FaceInfo;
import com.baidu.idl.facesdk.FaceSDK;
import com.baidu.idl.facesdk.FaceVerifyData;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FaceTracker {
    private String http_str;

    public FaceTracker(AssetManager asset, Context context, String apiKey, String token, FaceSDK.AlignMethodType align_method_type, FaceSDK.ParsMethodType parsing_method_type) {
        FaceSDK.getInstance(asset, context, apiKey, token, align_method_type, parsing_method_type);
        this.set_AlignMethodType(align_method_type.ordinal());
    }

    private native void tracking(int[] var1, int var2, int var3, int var4, int var5);

    private native void tracking(byte[] var1, int var2, int var3, int var4, int var5);

    public void track(int[] Img, int rows, int cols, int img_type, int maxTrackObjNum) {
        if (!FaceSDK.isAuthoritySucceeded()) {
            throw new IDLAuthorityException();
        }
        this.tracking(Img, rows, cols, img_type, maxTrackObjNum);
    }

    public void track(byte[] Img, int rows, int cols, int img_type, int maxTrackObjNum) {
        if (!FaceSDK.isAuthoritySucceeded()) {
            throw new IDLAuthorityException();
        }
        this.tracking(Img, rows, cols, img_type, maxTrackObjNum);
    }

    public native int set_notFace_thr(float var1);

    public native int set_min_face_size(int var1);

    public native int set_illum_thr(float var1);

    public native int set_blur_thr(float var1);

    public native int set_occlu_thr(float var1);

    public native int set_detection_frame_interval(int var1);

    public native int set_AlignMethodType(int var1);

    public native int set_isFineAlign(boolean var1);

    public native int set_isVerifyLive(boolean var1);

    public native int set_isCheckQuality(boolean var1);

    public native int set_intervalTime(long var1);

    public native int set_eulur_angle_thr(int var1, int var2, int var3);

    public native int set_cropFaceSize(int var1);

    public native int set_max_reg_img_num(int var1);

    public native int clearTrackedFaces();

    public String get_http_str() {
        if (this.http_str == null || this.http_str.length() == 0) {
            Log.e((String)"get_http_str", (String)"http_str is null\uff01");
            return null;
        }
        return this.http_str;
    }

    public native FaceVerifyData[] get_FaceVerifyData(int var1);

    public native FaceInfo[] get_TrackedFaceInfo();

    public native int prepare_data_for_verify(int[] var1, int var2, int var3, int var4, int var5);

    public native int prepare_data_for_verify(byte[] var1, int var2, int var3, int var4, int var5);

    private static String GetHostIp() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> ipAddr = intf.getInetAddresses();
                while (ipAddr.hasMoreElements()) {
                    InetAddress inetAddress = ipAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    private void generate_http_str(ActionType action, String username, String appid, String groupid, String[] mRegImage, String[] mRegLandmarks, String[] digest_strs) throws JSONException, UnsupportedEncodingException {
        if (mRegImage == null || mRegLandmarks == null || digest_strs == null) {
            this.http_str = "";
            return;
        }
        JSONObject request = new JSONObject();
        JSONObject config = new JSONObject();
        JSONArray params = new JSONArray();
        if (action != ActionType.RECOGNIZE) {
            config.put("username", (Object)username);
        }
        String cmdid = "10000";
        if (action == ActionType.RECOGNIZE) {
            cmdid = "10000";
        } else if (action == ActionType.VERIFY) {
            cmdid = "10000";
        } else if (action == ActionType.DELETE) {
            cmdid = "10000";
        } else if (action == ActionType.REGIST) {
            cmdid = "10000";
        }
        config.put("cmdid", (Object)cmdid);
        config.put("type", (Object)"st_groupverify");
        config.put("appid", (Object)appid);
        config.put("groupid", (Object)groupid);
        config.put("clientip", (Object)FaceTracker.GetHostIp());
        config.put("versionnum", (Object)"1.0.0");
        JSONArray images = new JSONArray();
        JSONArray ldmks = new JSONArray();
        JSONArray digests = new JSONArray();
        if (action == ActionType.REGIST || action == ActionType.VERIFY || action == ActionType.RECOGNIZE) {
            if (action == ActionType.VERIFY || action == ActionType.RECOGNIZE) {
                images.put((Object)mRegImage[mRegImage.length - 1]);
                ldmks.put((Object)mRegLandmarks[mRegImage.length - 1]);
                digests.put((Object)digest_strs[digest_strs.length - 1]);
            } else if (action == ActionType.REGIST) {
                int i = 0;
                while (i < mRegImage.length) {
                    images.put((Object)mRegImage[i]);
                    ldmks.put((Object)mRegLandmarks[i]);
                    digests.put((Object)digest_strs[i]);
                    ++i;
                }
            }
            config.put("images", (Object)images);
            config.put("landmarks", (Object)ldmks);
            config.put("imgdigests", (Object)digests);
        }
        params.put((Object)config);
        request.put("params", (Object)params);
        request.put("jsonrpc", (Object)"2.0");
        String method = "";
        method = action == ActionType.DELETE ? "Delete" : (action == ActionType.REGIST ? "Register" : (action == ActionType.VERIFY ? "Verify" : (action == ActionType.RECOGNIZE ? "Verify" : "")));
        request.put("method", (Object)method);
        this.http_str = request.toString();
    }

    public ErrCode face_verification(int[] Img, int rows, int cols, FaceSDK.ImgType imgtype, ActionType action, String username, String appid, String groupid) {
        if (!FaceSDK.isAuthoritySucceeded()) {
            throw new IDLAuthorityException();
        }
        int err_code = this.prepare_data_for_verify(Img, rows, cols, imgtype.ordinal(), action.ordinal());
        if (err_code == ErrCode.OK.ordinal()) {
            return ErrCode.OK;
        }
        this.http_str = null;
        return ErrCode.values()[err_code];
    }

    public ErrCode face_verification(byte[] Img, int rows, int cols, FaceSDK.ImgType imgtype, ActionType action, String username, String appid, String groupid) {
        if (!FaceSDK.isAuthoritySucceeded()) {
            throw new IDLAuthorityException();
        }
        int err_code = this.prepare_data_for_verify(Img, rows, cols, imgtype.ordinal(), action.ordinal());
        if (err_code == ErrCode.OK.ordinal()) {
            return ErrCode.OK;
        }
        this.http_str = null;
        return ErrCode.values()[err_code];
    }

    public static enum ActionType {
        DELETE,
        REGIST,
        VERIFY,
        RECOGNIZE;

    }

    public static enum ErrCode {
        OK,
        PITCH_OUT_OF_DOWN_MAX_RANGE,
        PITCH_OUT_OF_UP_MAX_RANGE,
        YAW_OUT_OF_LEFT_MAX_RANGE,
        YAW_OUT_OF_RIGHT_MAX_RANGE,
        POOR_ILLUMINATION,
        NO_FACE_DETECTED,
        DATA_NOT_READY,
        IMG_BLURED,
        OCCLUSION_LEFT_EYE,
        OCCLUSION_RIGHT_EYE,
        OCCLUSION_NOSE,
        OCCLUSION_MOUTH,
        OCCLUSION_LEFT_CONTOUR,
        OCCLUSION_RIGHT_CONTOUR,
        OCCLUSION_CHIN_CONTOUR,
        FACE_NOT_COMPLETE,
        UNKNOW_TYPE;

    }
}

