/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.website;

import android.content.res.AssetManager;
import android.os.SystemClock;
import com.yanzhenjie.andserver.exception.NotFoundException;
import com.yanzhenjie.andserver.protocol.ETag;
import com.yanzhenjie.andserver.protocol.LastModified;
import com.yanzhenjie.andserver.util.AssetsReader;
import com.yanzhenjie.andserver.util.FileUtils;
import com.yanzhenjie.andserver.util.HttpRequestParser;
import com.yanzhenjie.andserver.view.View;
import com.yanzhenjie.andserver.website.SimpleWebsite;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.entity.ContentType;
import org.apache.httpcore.entity.InputStreamEntity;
import org.apache.httpcore.protocol.HttpContext;

public class AssetsWebsite
extends SimpleWebsite
implements LastModified,
ETag {
    private final AssetsReader mAssetsReader;
    private final String mRootPath;
    private final Map<String, String> mPatternMap;
    private boolean isScanned;

    public AssetsWebsite(AssetManager assetManager, String rootPath) {
        this.mAssetsReader = new AssetsReader(assetManager);
        this.mRootPath = rootPath;
        this.mPatternMap = new LinkedHashMap<String, String>();
    }

    @Override
    public boolean intercept(HttpRequest request, HttpContext context) {
        this.tryScanFile();
        String httpPath = HttpRequestParser.getRequestPath(request);
        return this.mPatternMap.containsKey(httpPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryScanFile() {
        if (this.isScanned) return;
        Class<AssetsWebsite> clazz = AssetsWebsite.class;
        synchronized (AssetsWebsite.class) {
            if (this.isScanned) return;
            this.onScanFile(this.mRootPath, this.mAssetsReader, this.mPatternMap);
            this.isScanned = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void onScanFile(String rootPath, AssetsReader assetsReader, Map<String, String> patternMap) {
        List<String> fileList = assetsReader.scanFile(rootPath);
        if (fileList.size() > 0) {
            for (String filePath : fileList) {
                String httpPath = this.trimStartSlash(filePath);
                httpPath = httpPath.substring(rootPath.length(), httpPath.length());
                httpPath = this.addStartSlash(httpPath);
                patternMap.put(httpPath, filePath);
                if (!filePath.endsWith("/index.html")) continue;
                httpPath = httpPath.substring(0, httpPath.indexOf("/index.html"));
                patternMap.put(httpPath, filePath);
                patternMap.put(this.addEndSlash(httpPath), filePath);
            }
        }
    }

    @Override
    public View handle(HttpRequest request) throws HttpException, IOException {
        String httpPath = HttpRequestParser.getRequestPath(request);
        String filePath = this.mPatternMap.get(httpPath);
        InputStream source = this.mAssetsReader.getInputStream(filePath);
        if (source == null) {
            throw new NotFoundException(httpPath);
        }
        int length = source.available();
        String mimeType = FileUtils.getMimeType(filePath);
        InputStreamEntity httpEntity = new InputStreamEntity(source, (long)length, ContentType.create((String)mimeType, (Charset)Charset.defaultCharset()));
        return new View(200, (HttpEntity)httpEntity);
    }

    @Override
    public long getLastModified(HttpRequest request) throws IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        String filePath = this.mPatternMap.get(httpPath);
        InputStream source = this.mAssetsReader.getInputStream(filePath);
        if (source != null) {
            return System.currentTimeMillis() - SystemClock.currentThreadTimeMillis();
        }
        return -1L;
    }

    @Override
    public String getETag(HttpRequest request) throws IOException {
        String httpPath = this.trimEndSlash(HttpRequestParser.getRequestPath(request));
        String filePath = this.mPatternMap.get(httpPath);
        InputStream source = this.mAssetsReader.getInputStream(filePath);
        if (source != null) {
            long sourceSize = source.available();
            return sourceSize + filePath;
        }
        return null;
    }
}

