/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver;

import com.yanzhenjie.andserver.RequestHandler;
import com.yanzhenjie.andserver.RequestMethod;
import com.yanzhenjie.andserver.annotation.RequestMapping;
import com.yanzhenjie.andserver.exception.BaseException;
import com.yanzhenjie.andserver.exception.MethodNotSupported;
import com.yanzhenjie.andserver.exception.NotFoundException;
import com.yanzhenjie.andserver.exception.resolver.ExceptionResolver;
import com.yanzhenjie.andserver.exception.resolver.SimpleExceptionResolver;
import com.yanzhenjie.andserver.filter.Filter;
import com.yanzhenjie.andserver.interceptor.Interceptor;
import com.yanzhenjie.andserver.util.HttpRequestParser;
import com.yanzhenjie.andserver.website.WebSite;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.HttpResponse;
import org.apache.httpcore.protocol.HttpContext;
import org.apache.httpcore.protocol.HttpRequestHandler;

class DispatchRequestHandler
implements HttpRequestHandler {
    private static ExceptionResolver sDefaultExceptionResolver = new SimpleExceptionResolver();
    private Interceptor mInterceptor;
    private WebSite mWebSite;
    private Map<String, RequestHandler> mRequestHandlerMapper = new LinkedHashMap<String, RequestHandler>();
    private Filter mFilter;
    private ExceptionResolver mExceptionResolver = sDefaultExceptionResolver;

    DispatchRequestHandler() {
    }

    void setInterceptor(Interceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    void setWebSite(WebSite webSite) {
        this.mWebSite = webSite;
    }

    void registerRequestHandler(String path, RequestHandler handler) {
        this.mRequestHandlerMapper.put(path, handler);
    }

    void setFilter(Filter filter) {
        this.mFilter = filter;
    }

    void setExceptionResolver(ExceptionResolver exceptionResolver) {
        this.mExceptionResolver = exceptionResolver;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        try {
            if (this.mInterceptor != null && this.mInterceptor.onBeforeExecute(request, response, context)) {
                return;
            }
            RequestHandler handler = this.getRequestHandler(request, context);
            if (handler == null) {
                String path = HttpRequestParser.getRequestPath(request);
                throw new NotFoundException(path);
            }
            this.handleRequest(handler, request, response, context);
            if (this.mInterceptor != null) {
                this.mInterceptor.onAfterExecute(request, response, context);
            }
        }
        catch (Exception e) {
            try {
                this.mExceptionResolver.resolveException(e, request, response, context);
            }
            catch (Exception ee) {
                sDefaultExceptionResolver.resolveException(e, request, response, context);
            }
        }
    }

    private void handleRequest(RequestHandler handler, HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        this.verifyHandler(request, handler);
        if (this.mFilter != null) {
            this.mFilter.doFilter(handler, request, response, context);
        } else {
            handler.handle(request, response, context);
        }
    }

    private RequestHandler getRequestHandler(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String path = HttpRequestParser.getRequestPath(request);
        if (this.mWebSite != null && this.mWebSite.intercept(request, context)) {
            return this.mWebSite;
        }
        return this.mRequestHandlerMapper.get(path);
    }

    private void verifyHandler(HttpRequest request, RequestHandler handler) throws BaseException {
        RequestMethod requestMethod = RequestMethod.reverse(request.getRequestLine().getMethod());
        Class<?> clazz = handler.getClass();
        try {
            RequestMethod[] requestMethods;
            List<RequestMethod> requestMethodList;
            Method handlerMethod = clazz.getMethod("handle", HttpRequest.class, HttpResponse.class, HttpContext.class);
            RequestMapping requestMapping = handlerMethod.getAnnotation(RequestMapping.class);
            if (requestMapping != null && !(requestMethodList = Arrays.asList(requestMethods = requestMapping.method())).contains((Object)requestMethod)) {
                throw new MethodNotSupported(requestMethod);
            }
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
    }
}

