/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.titlebar;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.ab.util.AbStrUtil;
import com.ab.util.AbViewUtil;

public class AbTitleBar
extends LinearLayout {
    private Activity mActivity;
    protected LinearLayout titleTextLayout = null;
    protected Button titleTextBtn = null;
    protected Button titleSmallTextBtn = null;
    protected ImageView logoView = null;
    protected ImageView logoView2 = null;
    protected ImageView logoLineView = null;
    private LinearLayout.LayoutParams titleTextLayoutParams = null;
    private LinearLayout.LayoutParams rightViewLayoutParams = null;
    protected LinearLayout rightLayout = null;
    public int mAbTitleBarID = 1;
    public LayoutInflater mInflater;
    public LinearLayout.LayoutParams layoutParamsFF = null;
    public LinearLayout.LayoutParams layoutParamsFW = null;
    public LinearLayout.LayoutParams layoutParamsWF = null;
    public LinearLayout.LayoutParams layoutParamsWW = null;
    private PopupWindow popupWindow;

    public AbTitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ininTitleBar(context);
    }

    public AbTitleBar(Context context) {
        super(context);
        this.ininTitleBar(context);
    }

    public void ininTitleBar(Context context) {
        this.mActivity = (Activity)context;
        this.setOrientation(0);
        this.setId(this.mAbTitleBarID);
        this.mInflater = LayoutInflater.from((Context)context);
        this.layoutParamsFF = new LinearLayout.LayoutParams(-1, -1);
        this.layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.layoutParamsWF = new LinearLayout.LayoutParams(-2, -1);
        this.layoutParamsWW = new LinearLayout.LayoutParams(-2, -2);
        this.layoutParamsWW.gravity = 16;
        this.titleTextLayoutParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        this.titleTextLayoutParams.gravity = 16;
        this.rightViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.rightViewLayoutParams.gravity = 16;
        this.titleTextLayout = new LinearLayout(context);
        this.titleTextLayout.setOrientation(1);
        this.titleTextLayout.setGravity(16);
        this.titleTextLayout.setPadding(0, 0, 0, 0);
        this.titleTextBtn = new Button(context);
        this.titleTextBtn.setTextColor(Color.rgb((int)255, (int)255, (int)255));
        this.titleTextBtn.setTextSize(20.0f);
        this.titleTextBtn.setPadding(5, 0, 5, 0);
        this.titleTextBtn.setGravity(16);
        this.titleTextBtn.setBackgroundDrawable(null);
        this.titleTextBtn.setSingleLine();
        this.titleTextLayout.addView((View)this.titleTextBtn, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
        this.titleSmallTextBtn = new Button(context);
        this.titleSmallTextBtn.setTextColor(Color.rgb((int)255, (int)255, (int)255));
        this.titleSmallTextBtn.setTextSize(15.0f);
        this.titleSmallTextBtn.setPadding(6, 0, 5, 0);
        this.titleSmallTextBtn.setGravity(16);
        this.titleSmallTextBtn.setBackgroundDrawable(null);
        this.titleSmallTextBtn.setSingleLine();
        this.titleTextLayout.addView((View)this.titleSmallTextBtn, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, 0));
        this.logoView = new ImageView(context);
        this.logoView.setVisibility(8);
        this.logoLineView = new ImageView(context);
        this.logoLineView.setVisibility(8);
        this.logoView2 = new ImageView(context);
        this.logoView2.setVisibility(8);
        this.addView((View)this.logoView, (ViewGroup.LayoutParams)this.layoutParamsWW);
        this.addView((View)this.logoLineView, (ViewGroup.LayoutParams)this.layoutParamsWW);
        this.addView((View)this.logoView2, (ViewGroup.LayoutParams)this.layoutParamsWW);
        this.addView((View)this.titleTextLayout, (ViewGroup.LayoutParams)this.titleTextLayoutParams);
        this.rightLayout = new LinearLayout(context);
        this.rightLayout.setOrientation(0);
        this.rightLayout.setGravity(5);
        this.rightLayout.setPadding(0, 0, 0, 0);
        this.rightLayout.setHorizontalGravity(5);
        this.rightLayout.setGravity(16);
        this.rightLayout.setVisibility(8);
        this.addView((View)this.rightLayout, (ViewGroup.LayoutParams)this.rightViewLayoutParams);
        this.logoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbTitleBar.this.mActivity.finish();
            }
        });
    }

    public void setTitleBarBackground(int res) {
        this.setBackgroundResource(res);
    }

    public void setTitleBarBackgroundDrawable(Drawable d) {
        this.setBackgroundDrawable(d);
    }

    public void setTitleBarBackgroundColor(int color) {
        this.setBackgroundColor(color);
    }

    public void setTitleTextMargin(int left, int top, int right, int bottom) {
        this.titleTextLayoutParams.setMargins(left, top, right, bottom);
    }

    public void setTitleTextSize(int titleTextSize) {
        this.titleTextBtn.setTextSize((float)titleTextSize);
    }

    public void setTitleBarGravity(int gravity1, int gravity2) {
        AbViewUtil.measureView((View)this.rightLayout);
        AbViewUtil.measureView((View)this.logoView);
        int leftWidth = this.logoView.getMeasuredWidth();
        int rightWidth = this.rightLayout.getMeasuredWidth();
        this.titleTextLayoutParams.rightMargin = 0;
        this.titleTextLayoutParams.leftMargin = 0;
        if (gravity1 == 1 || gravity1 == 17) {
            if (leftWidth == 0 && rightWidth == 0) {
                this.titleTextLayout.setGravity(1);
            } else {
                if (gravity2 == 5) {
                    if (rightWidth != 0) {
                        this.titleTextBtn.setPadding(rightWidth / 3 * 2, 0, 0, 0);
                    }
                    this.titleTextBtn.setGravity(17);
                    this.rightLayout.setHorizontalGravity(5);
                }
                if (gravity2 == 17 || gravity2 == 1) {
                    this.titleTextLayout.setGravity(1);
                    this.rightLayout.setHorizontalGravity(3);
                    this.titleTextBtn.setGravity(17);
                    int offset = leftWidth - rightWidth;
                    if (offset > 0) {
                        this.titleTextLayoutParams.rightMargin = offset;
                    } else {
                        this.titleTextLayoutParams.leftMargin = Math.abs(offset);
                    }
                }
            }
        } else if (gravity1 == 3 && gravity2 == 5) {
            this.titleTextLayout.setGravity(3);
            this.rightLayout.setHorizontalGravity(5);
        } else if (gravity1 == 5 && gravity2 == 5) {
            this.titleTextLayout.setGravity(5);
            this.rightLayout.setHorizontalGravity(5);
        } else if (gravity1 == 3 && gravity2 == 3) {
            this.titleTextLayout.setGravity(3);
            this.rightLayout.setHorizontalGravity(3);
        }
    }

    public Button getTitleTextButton() {
        return this.titleTextBtn;
    }

    public Button getTitleSmallTextButton() {
        return this.titleSmallTextBtn;
    }

    public ImageView getLogoView() {
        return this.logoView;
    }

    public ImageView getLogoView2() {
        return this.logoView2;
    }

    public void setTitleTextBold(boolean bold) {
        TextPaint paint = this.titleTextBtn.getPaint();
        if (bold) {
            paint.setFakeBoldText(true);
        } else {
            paint.setFakeBoldText(false);
        }
    }

    public void setTitleTextBackgroundResource(int resId) {
        this.titleTextBtn.setBackgroundResource(resId);
    }

    public void setTitleTextBackgroundDrawable(Drawable drawable) {
        this.titleTextBtn.setBackgroundDrawable(drawable);
    }

    public void setTitleText(String text) {
        this.titleTextBtn.setText((CharSequence)text);
    }

    public void setTitleText(int resId) {
        this.titleTextBtn.setText(resId);
    }

    public void setTitleSmallText(String text) {
        if (AbStrUtil.isEmpty(text)) {
            LinearLayout.LayoutParams titleSmallTextViewLayoutParams = new LinearLayout.LayoutParams(-2, 0);
            this.titleSmallTextBtn.setLayoutParams((ViewGroup.LayoutParams)titleSmallTextViewLayoutParams);
            this.titleSmallTextBtn.setText((CharSequence)"");
        } else {
            LinearLayout.LayoutParams titleSmallTextViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            this.titleSmallTextBtn.setLayoutParams((ViewGroup.LayoutParams)titleSmallTextViewLayoutParams);
            this.titleSmallTextBtn.setText((CharSequence)text);
        }
    }

    public void setTitleSmallText(int resId) {
        LinearLayout.LayoutParams titleSmallTextViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        this.titleSmallTextBtn.setLayoutParams((ViewGroup.LayoutParams)titleSmallTextViewLayoutParams);
        this.titleSmallTextBtn.setText(resId);
    }

    public void setLogo(Drawable drawable) {
        this.logoView.setVisibility(0);
        this.logoView.setBackgroundDrawable(drawable);
    }

    public void setLogo(int resId) {
        this.logoView.setVisibility(0);
        this.logoView.setBackgroundResource(resId);
    }

    public void setLogo2(Drawable drawable) {
        this.logoView2.setVisibility(0);
        this.logoView2.setBackgroundDrawable(drawable);
    }

    public void setLogo2(int resId) {
        this.logoView2.setVisibility(0);
        this.logoView2.setBackgroundResource(resId);
    }

    public void setLogoLine(int resId) {
        this.logoLineView.setVisibility(0);
        this.logoLineView.setBackgroundResource(resId);
    }

    public void setLogoLine(Drawable drawable) {
        this.logoLineView.setVisibility(0);
        this.logoLineView.setBackgroundDrawable(drawable);
    }

    public void addRightView(View rightView) {
        this.rightLayout.setVisibility(0);
        this.rightLayout.addView(rightView, (ViewGroup.LayoutParams)this.layoutParamsFF);
    }

    public void addRightView(int resId) {
        this.rightLayout.setVisibility(0);
        this.rightLayout.addView(this.mInflater.inflate(resId, null), (ViewGroup.LayoutParams)this.layoutParamsFF);
    }

    public void clearRightView() {
        this.rightLayout.removeAllViews();
    }

    public LinearLayout getRightLayout() {
        return this.rightLayout;
    }

    public void setLogoOnClickListener(View.OnClickListener mOnClickListener) {
        this.logoView.setOnClickListener(mOnClickListener);
    }

    public void setLogo2OnClickListener(View.OnClickListener mOnClickListener) {
        this.logoView2.setOnClickListener(mOnClickListener);
    }

    public void setTitleTextOnClickListener(View.OnClickListener mOnClickListener) {
        this.titleTextBtn.setOnClickListener(mOnClickListener);
    }

    public void showWindow(View parent, View view, boolean offsetMode) {
        AbViewUtil.measureView(view);
        int popWidth = parent.getMeasuredWidth();
        int popMargin = (this.getMeasuredHeight() - parent.getMeasuredHeight()) / 2;
        if (view.getMeasuredWidth() > parent.getMeasuredWidth()) {
            popWidth = view.getMeasuredWidth();
        }
        this.popupWindow = offsetMode ? new PopupWindow(view, popWidth + 10, -2, true) : new PopupWindow(view, -1, -2, true);
        this.popupWindow.setFocusable(true);
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(17170445));
        this.popupWindow.showAsDropDown(parent, 0, popMargin + 2);
    }

    public void hideWindow() {
        if (this.popupWindow != null) {
            this.popupWindow.dismiss();
        }
    }

    public void setTitleTextDropDown(final View view) {
        if (view == null) {
            return;
        }
        this.setTitleTextOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbTitleBar.this.showWindow((View)AbTitleBar.this.titleTextBtn, view, true);
            }
        });
    }

    public LinearLayout getTitleTextLayout() {
        return this.titleTextLayout;
    }

    public void setChildViewFillParent(boolean left) {
        if (left) {
            this.titleTextLayoutParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
            this.titleTextLayoutParams.gravity = 16;
            this.titleTextLayout.setLayoutParams((ViewGroup.LayoutParams)this.titleTextLayoutParams);
            this.rightViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            this.rightViewLayoutParams.gravity = 16;
            this.rightLayout.setLayoutParams((ViewGroup.LayoutParams)this.rightViewLayoutParams);
        } else {
            this.titleTextLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            this.titleTextLayoutParams.gravity = 16;
            this.titleTextLayout.setLayoutParams((ViewGroup.LayoutParams)this.titleTextLayoutParams);
            this.rightViewLayoutParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
            this.rightViewLayoutParams.gravity = 16;
            this.rightLayout.setLayoutParams((ViewGroup.LayoutParams)this.rightViewLayoutParams);
        }
    }
}

