/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ab.util.AbViewUtil;

public class AbTabItemView
extends LinearLayout {
    private Context mContext;
    private int mIndex;
    private TextView mTextView;

    public AbTabItemView(Context context) {
        this(context, null);
    }

    public AbTabItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(0);
        this.mContext = context;
        this.mTextView = new TextView(context);
        this.mTextView.setGravity(17);
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mTextView.setFocusable(true);
        this.mTextView.setPadding(10, 0, 10, 0);
        this.mTextView.setSingleLine();
        this.addView((View)this.mTextView);
    }

    public void init(int index, String text) {
        this.mIndex = index;
        this.mTextView.setText((CharSequence)text);
    }

    public int getIndex() {
        return this.mIndex;
    }

    public TextView getTextView() {
        return this.mTextView;
    }

    public void setTabTextSize(int tabTextSize) {
        AbViewUtil.setTextSize(this.mTextView, tabTextSize);
    }

    public void setTabTextColor(int tabColor) {
        this.mTextView.setTextColor(tabColor);
    }

    public void setTabCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (left != null) {
            left.setBounds(0, 0, AbViewUtil.scale(this.mContext, left.getIntrinsicWidth()), AbViewUtil.scale(this.mContext, left.getIntrinsicHeight()));
        }
        if (top != null) {
            top.setBounds(0, 0, AbViewUtil.scale(this.mContext, top.getIntrinsicWidth()), AbViewUtil.scale(this.mContext, top.getIntrinsicHeight()));
        }
        if (right != null) {
            right.setBounds(0, 0, AbViewUtil.scale(this.mContext, right.getIntrinsicWidth()), AbViewUtil.scale(this.mContext, right.getIntrinsicHeight()));
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, AbViewUtil.scale(this.mContext, bottom.getIntrinsicWidth()), AbViewUtil.scale(this.mContext, bottom.getIntrinsicHeight()));
        }
        this.mTextView.setCompoundDrawables(left, top, right, bottom);
    }

    public void setTabBackgroundResource(int resid) {
        this.setBackgroundResource(resid);
    }

    public void setTabBackgroundDrawable(Drawable d) {
        this.setBackgroundDrawable(d);
    }
}

