/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.Color;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ab.adapter.AbFragmentPagerAdapter;
import com.ab.util.AbLogUtil;
import com.ab.util.AbViewUtil;
import com.ab.view.sample.AbHorizontalScrollView;
import java.util.ArrayList;
import java.util.List;

public class AbSlidingSmoothTabView
extends LinearLayout {
    private Context context;
    private LinearLayout mTabLayout = null;
    private AbHorizontalScrollView mTabScrollView = null;
    private ViewPager mViewPager;
    private ArrayList<TextView> tabItemList = null;
    private ArrayList<Fragment> pagerItemList = null;
    private List<String> tabItemTextList = null;
    public LinearLayout.LayoutParams layoutParamsFF = null;
    public LinearLayout.LayoutParams layoutParamsFW = null;
    public LinearLayout.LayoutParams layoutParamsWW = null;
    private ImageView mTabImg;
    private int mSelectedTabIndex = 0;
    private AbFragmentPagerAdapter mFragmentPagerAdapter = null;
    private int tabTextSize = 16;
    private int tabColor = -16777216;
    private int tabSelectColor = -16777216;
    private int tabSlidingHeight = 5;
    private int startX = 0;
    private int scrollX = 0;

    public AbSlidingSmoothTabView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.layoutParamsFF = new LinearLayout.LayoutParams(-1, -1);
        this.layoutParamsWW = new LinearLayout.LayoutParams(-2, -2);
        this.setOrientation(1);
        this.setBackgroundColor(Color.rgb((int)255, (int)255, (int)255));
        this.mTabScrollView = new AbHorizontalScrollView(context);
        this.mTabScrollView.setHorizontalScrollBarEnabled(false);
        this.mTabLayout = new LinearLayout(context);
        this.mTabLayout.setOrientation(0);
        this.mTabLayout.setGravity(17);
        this.mTabScrollView.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
        this.tabItemList = new ArrayList();
        this.tabItemTextList = new ArrayList<String>();
        this.addView((View)this.mTabScrollView, (ViewGroup.LayoutParams)this.layoutParamsFW);
        this.mTabImg = new ImageView(context);
        this.addView((View)this.mTabImg, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, this.tabSlidingHeight));
        this.mViewPager = new ViewPager(context);
        this.mViewPager.setId(1985);
        this.pagerItemList = new ArrayList();
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)this.layoutParamsFF);
        if (!(this.context instanceof FragmentActivity)) {
            AbLogUtil.e(AbSlidingSmoothTabView.class, "\u6784\u9020AbSlidingSmoothTabView\u7684\u53c2\u6570context,\u5fc5\u987b\u662fFragmentActivity\u7684\u5b9e\u4f8b\u3002");
        }
        FragmentManager mFragmentManager = ((FragmentActivity)this.context).getFragmentManager();
        this.mFragmentPagerAdapter = new AbFragmentPagerAdapter(mFragmentManager, this.pagerItemList);
        this.mViewPager.setAdapter((PagerAdapter)this.mFragmentPagerAdapter);
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new MyOnPageChangeListener());
        this.mViewPager.setOffscreenPageLimit(3);
        this.mTabScrollView.setSmoothScrollingEnabled(true);
        this.mTabScrollView.setOnScrollListener(new AbHorizontalScrollView.AbOnScrollListener(){

            @Override
            public void onScrollToRight() {
                AbLogUtil.d(AbSlidingSmoothTabView.class, "onScrollToRight");
            }

            @Override
            public void onScrollToLeft() {
                AbLogUtil.d(AbSlidingSmoothTabView.class, "onScrollToLeft");
            }

            @Override
            public void onScrollStoped() {
                AbLogUtil.d(AbSlidingSmoothTabView.class, "onScrollStoped");
            }

            @Override
            public void onScroll(int arg1) {
                AbSlidingSmoothTabView.this.scrollX = arg1;
                View view = AbSlidingSmoothTabView.this.mTabLayout.getChildAt(AbSlidingSmoothTabView.this.mSelectedTabIndex);
                int toX = view.getLeft() - AbSlidingSmoothTabView.this.scrollX;
                AbLogUtil.d(AbSlidingSmoothTabView.class, "\u6ed1\u52a8X" + AbSlidingSmoothTabView.this.startX + "to" + toX);
                AbSlidingSmoothTabView.this.imageSlide((View)AbSlidingSmoothTabView.this.mTabImg, AbSlidingSmoothTabView.this.startX, toX, 0, 0);
                AbSlidingSmoothTabView.this.startX = toX;
            }
        });
    }

    public void imageSlide(View v, int startX, int toX, int startY, int toY) {
        TranslateAnimation anim = new TranslateAnimation((float)startX, (float)toX, (float)startY, (float)toY);
        anim.setDuration(100L);
        anim.setFillAfter(true);
        v.startAnimation((Animation)anim);
    }

    public void computeTabImg(int index) {
        int i = 0;
        while (i < this.tabItemList.size()) {
            TextView tv = this.tabItemList.get(i);
            tv.setTextColor(this.tabColor);
            tv.setSelected(false);
            if (index == i) {
                tv.setTextColor(this.tabSelectColor);
                tv.setSelected(true);
            }
            ++i;
        }
        View tabView = this.mTabLayout.getChildAt(index);
        AbViewUtil.measureView(tabView);
        LinearLayout.LayoutParams mParams = new LinearLayout.LayoutParams(tabView.getMeasuredWidth(), this.tabSlidingHeight);
        mParams.topMargin = -this.tabSlidingHeight;
        this.mTabImg.setLayoutParams((ViewGroup.LayoutParams)mParams);
        AbLogUtil.d(AbSlidingSmoothTabView.class, "old--startX:" + this.startX);
        AbLogUtil.d(AbSlidingSmoothTabView.class, "view\u5bbd\u5ea6" + index + ":" + tabView.getMeasuredWidth());
        AbLogUtil.d(AbSlidingSmoothTabView.class, "ScrollView\u5bbd\u5ea6:" + this.mTabScrollView.getWidth());
        AbLogUtil.d(AbSlidingSmoothTabView.class, "scrollX:" + this.scrollX);
        AbLogUtil.d(AbSlidingSmoothTabView.class, "tabView right:" + tabView.getRight());
        AbLogUtil.d(AbSlidingSmoothTabView.class, "tabView left:" + tabView.getLeft());
        if (this.mSelectedTabIndex < index && tabView.getRight() - this.scrollX > this.mTabScrollView.getWidth()) {
            AbLogUtil.d(AbSlidingSmoothTabView.class, "\u53f3\u8fb9\u88ab\u906e\u6321");
            int offsetX = 0;
            if (index == this.mTabLayout.getChildCount() - 1) {
                offsetX = tabView.getRight() - this.mTabScrollView.getWidth() - this.scrollX;
                this.mTabScrollView.smoothScrollBy(offsetX, 0);
                this.scrollX += offsetX;
                AbLogUtil.d(AbSlidingSmoothTabView.class, "startX:" + this.startX + ",offsetX:" + offsetX);
                this.imageSlide((View)this.mTabImg, this.startX, this.mTabScrollView.getWidth() - tabView.getMeasuredWidth(), 0, 0);
                this.startX = this.mTabScrollView.getWidth() - tabView.getMeasuredWidth();
            } else {
                offsetX = tabView.getMeasuredWidth();
                this.mTabScrollView.smoothScrollBy(offsetX, 0);
                this.scrollX += offsetX;
                AbLogUtil.d(AbSlidingSmoothTabView.class, "startX:" + this.startX + ",offsetX:" + offsetX);
                int toX = tabView.getLeft() - this.scrollX;
                this.imageSlide((View)this.mTabImg, this.startX, toX, 0, 0);
                this.startX = toX;
            }
        } else if (this.mSelectedTabIndex > index && tabView.getLeft() < this.scrollX) {
            AbLogUtil.d(AbSlidingSmoothTabView.class, "\u5de6\u8fb9\u88ab\u906e\u6321");
            int offsetX = 0;
            if (index == 0) {
                offsetX = -this.scrollX;
                this.mTabScrollView.smoothScrollBy(offsetX, 0);
                this.scrollX += offsetX;
                this.imageSlide((View)this.mTabImg, this.startX, 0, 0, 0);
                this.startX = 0;
            } else {
                offsetX = -tabView.getMeasuredWidth();
                this.mTabScrollView.smoothScrollBy(offsetX, 0);
                this.scrollX += offsetX;
                AbLogUtil.d(AbSlidingSmoothTabView.class, "startX2:" + this.startX + ",offsetX:" + offsetX);
                int toX = tabView.getLeft() - this.scrollX;
                this.imageSlide((View)this.mTabImg, this.startX, toX, 0, 0);
                this.startX = toX;
            }
        } else {
            int toX = tabView.getLeft() - this.scrollX;
            this.imageSlide((View)this.mTabImg, this.startX, toX, 0, 0);
            this.startX = toX;
        }
        this.mSelectedTabIndex = index;
    }

    public void addItemViews(List<String> tabTexts, List<Fragment> fragments) {
        this.tabItemTextList.addAll(tabTexts);
        this.pagerItemList.addAll(fragments);
        this.tabItemList.clear();
        this.mTabLayout.removeAllViews();
        int i = 0;
        while (i < this.tabItemTextList.size()) {
            final int index = i;
            String text = this.tabItemTextList.get(i);
            TextView tv = new TextView(this.context);
            tv.setTextColor(this.tabColor);
            tv.setTextSize((float)this.tabTextSize);
            tv.setText((CharSequence)text);
            tv.setGravity(17);
            tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            tv.setPadding(12, 5, 12, 5);
            tv.setFocusable(false);
            this.tabItemList.add(tv);
            this.mTabLayout.addView((View)tv);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    AbSlidingSmoothTabView.this.mViewPager.setCurrentItem(index);
                }
            });
            ++i;
        }
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.mViewPager.setCurrentItem(0);
        this.computeTabImg(0);
    }

    public void addItemView(String tabText, Fragment fragment) {
        this.tabItemTextList.add(tabText);
        this.pagerItemList.add(fragment);
        this.tabItemList.clear();
        this.mTabLayout.removeAllViews();
        int i = 0;
        while (i < this.tabItemTextList.size()) {
            final int index = i;
            String text = this.tabItemTextList.get(i);
            TextView tv = new TextView(this.context);
            tv.setTextColor(this.tabColor);
            tv.setTextSize((float)this.tabTextSize);
            tv.setText((CharSequence)text);
            tv.setGravity(17);
            tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            tv.setPadding(12, 5, 12, 5);
            tv.setFocusable(false);
            this.tabItemList.add(tv);
            this.mTabLayout.addView((View)tv);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    AbSlidingSmoothTabView.this.mViewPager.setCurrentItem(index);
                }
            });
            ++i;
        }
        AbLogUtil.d(AbSlidingSmoothTabView.class, "addItemView finish");
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.mViewPager.setCurrentItem(0);
        this.computeTabImg(0);
    }

    public void removeItemView(int index) {
        this.tabItemList.remove(index);
        this.mTabLayout.removeViewAt(index);
        this.pagerItemList.remove(index);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
    }

    public void removeAllItemView(int index) {
        this.tabItemList.clear();
        this.mTabLayout.removeAllViews();
        this.pagerItemList.clear();
        this.mFragmentPagerAdapter.notifyDataSetChanged();
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public LinearLayout getTabLayout() {
        return this.mTabLayout;
    }

    public void setTabLayoutBackgroundResource(int res) {
        this.mTabLayout.setBackgroundResource(res);
    }

    public int getTabColor() {
        return this.tabColor;
    }

    public void setTabColor(int tabColor) {
        this.tabColor = tabColor;
    }

    public void setTabSelectColor(int tabColor) {
        this.tabSelectColor = tabColor;
        this.mTabImg.setBackgroundColor(tabColor);
    }

    public int getTabTextSize() {
        return this.tabTextSize;
    }

    public void setTabTextSize(int tabTextSize) {
        this.tabTextSize = tabTextSize;
    }

    public void setTabPadding(int left, int top, int right, int bottom) {
        int i = 0;
        while (i < this.tabItemList.size()) {
            TextView tv = this.tabItemList.get(i);
            tv.setPadding(left, top, right, bottom);
            ++i;
        }
    }

    public int getTabSlidingHeight() {
        return this.tabSlidingHeight;
    }

    public void setTabSlidingHeight(int tabSlidingHeight) {
        this.tabSlidingHeight = tabSlidingHeight;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public class MyOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        public void onPageScrollStateChanged(int arg0) {
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
        }

        public void onPageSelected(int arg0) {
            AbSlidingSmoothTabView.this.computeTabImg(arg0);
        }
    }
}

