/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ab.adapter.AbFragmentPagerAdapter;
import com.ab.util.AbAppUtil;
import com.ab.util.AbLogUtil;
import java.util.ArrayList;
import java.util.List;

public class AbSlidingSmoothFixTabView
extends LinearLayout {
    private Context context;
    private LinearLayout mTabLayout = null;
    private ViewPager mViewPager;
    private ArrayList<TextView> tabItemList = null;
    private ArrayList<Fragment> pagerItemList = null;
    private List<String> tabItemTextList = null;
    public LinearLayout.LayoutParams layoutParamsFF = null;
    public LinearLayout.LayoutParams layoutParamsFW = null;
    public LinearLayout.LayoutParams layoutParamsWW = null;
    private ImageView mTabImg;
    private int mSelectedTabIndex = 0;
    private AbFragmentPagerAdapter mFragmentPagerAdapter = null;
    private int tabTextSize = 16;
    private int tabColor = -16777216;
    private int tabSelectedColor = -16777216;
    private int tabSlidingHeight = 5;
    private int startX = 0;
    private int mWidth = 0;

    public AbSlidingSmoothFixTabView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.layoutParamsFF = new LinearLayout.LayoutParams(-1, -1);
        this.layoutParamsWW = new LinearLayout.LayoutParams(-2, -2);
        this.setOrientation(1);
        this.mTabLayout = new LinearLayout(context);
        this.mTabLayout.setOrientation(0);
        this.mTabLayout.setGravity(17);
        this.tabItemList = new ArrayList();
        this.tabItemTextList = new ArrayList<String>();
        this.addView((View)this.mTabLayout, (ViewGroup.LayoutParams)this.layoutParamsFW);
        this.mTabImg = new ImageView(context);
        this.addView((View)this.mTabImg, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, this.tabSlidingHeight));
        this.mViewPager = new ViewPager(context);
        this.mViewPager.setId(1985);
        this.pagerItemList = new ArrayList();
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)this.layoutParamsFF);
        if (!(this.context instanceof FragmentActivity)) {
            AbLogUtil.e(AbSlidingSmoothFixTabView.class, "\u6784\u9020AbSlidingSmoothTabView\u7684\u53c2\u6570context,\u5fc5\u987b\u662fFragmentActivity\u7684\u5b9e\u4f8b\u3002");
        }
        DisplayMetrics mDisplayMetrics = AbAppUtil.getDisplayMetrics(context);
        this.mWidth = mDisplayMetrics.widthPixels;
        FragmentManager mFragmentManager = ((FragmentActivity)this.context).getFragmentManager();
        this.mFragmentPagerAdapter = new AbFragmentPagerAdapter(mFragmentManager, this.pagerItemList);
        this.mViewPager.setAdapter((PagerAdapter)this.mFragmentPagerAdapter);
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new MyOnPageChangeListener());
        this.mViewPager.setOffscreenPageLimit(3);
    }

    public void imageSlide(View v, int startX, int toX, int startY, int toY) {
        TranslateAnimation anim = new TranslateAnimation((float)startX, (float)toX, (float)startY, (float)toY);
        anim.setDuration(100L);
        anim.setFillAfter(true);
        v.startAnimation((Animation)anim);
    }

    public void computeTabImg(int index) {
        int i = 0;
        while (i < this.tabItemList.size()) {
            TextView tv = this.tabItemList.get(i);
            tv.setTextColor(this.tabColor);
            tv.setSelected(false);
            if (index == i) {
                tv.setTextColor(this.tabSelectedColor);
                tv.setSelected(true);
            }
            ++i;
        }
        int itemWidth = this.mWidth / this.tabItemList.size();
        LinearLayout.LayoutParams mParams = new LinearLayout.LayoutParams(itemWidth, this.tabSlidingHeight);
        mParams.topMargin = -this.tabSlidingHeight;
        this.mTabImg.setLayoutParams((ViewGroup.LayoutParams)mParams);
        AbLogUtil.d(AbSlidingSmoothFixTabView.class, "old--startX:" + this.startX);
        int toX = itemWidth * index;
        this.imageSlide((View)this.mTabImg, this.startX, toX, 0, 0);
        this.startX = toX;
        this.mSelectedTabIndex = index;
    }

    public void addItemViews(List<String> tabTexts, List<Fragment> fragments) {
        this.tabItemTextList.addAll(tabTexts);
        this.pagerItemList.addAll(fragments);
        this.tabItemList.clear();
        this.mTabLayout.removeAllViews();
        int i = 0;
        while (i < this.tabItemTextList.size()) {
            final int index = i;
            String text = this.tabItemTextList.get(i);
            TextView tv = new TextView(this.context);
            tv.setTextColor(this.tabColor);
            tv.setTextSize((float)this.tabTextSize);
            tv.setText((CharSequence)text);
            tv.setGravity(17);
            tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            tv.setPadding(12, 5, 12, 5);
            tv.setFocusable(false);
            this.tabItemList.add(tv);
            this.mTabLayout.addView((View)tv);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    AbSlidingSmoothFixTabView.this.mViewPager.setCurrentItem(index);
                }
            });
            ++i;
        }
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.mViewPager.setCurrentItem(0);
        this.computeTabImg(0);
    }

    public void addItemView(String tabText, Fragment fragment) {
        this.tabItemTextList.add(tabText);
        this.pagerItemList.add(fragment);
        this.tabItemList.clear();
        this.mTabLayout.removeAllViews();
        int i = 0;
        while (i < this.tabItemTextList.size()) {
            final int index = i;
            String text = this.tabItemTextList.get(i);
            TextView tv = new TextView(this.context);
            tv.setTextColor(this.tabColor);
            tv.setTextSize((float)this.tabTextSize);
            tv.setText((CharSequence)text);
            tv.setGravity(17);
            tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            tv.setPadding(12, 5, 12, 5);
            tv.setFocusable(false);
            this.tabItemList.add(tv);
            this.mTabLayout.addView((View)tv);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    AbSlidingSmoothFixTabView.this.mViewPager.setCurrentItem(index);
                }
            });
            ++i;
        }
        AbLogUtil.d(AbSlidingSmoothFixTabView.class, "addItemView finish");
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.mViewPager.setCurrentItem(0);
        this.computeTabImg(0);
    }

    public void removeItemView(int index) {
        this.tabItemList.remove(index);
        this.mTabLayout.removeViewAt(index);
        this.pagerItemList.remove(index);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
    }

    public void removeAllItemView(int index) {
        this.tabItemList.clear();
        this.mTabLayout.removeAllViews();
        this.pagerItemList.clear();
        this.mFragmentPagerAdapter.notifyDataSetChanged();
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public LinearLayout getTabLayout() {
        return this.mTabLayout;
    }

    public void setTabLayoutBackgroundResource(int res) {
        this.mTabLayout.setBackgroundResource(res);
    }

    public int getTabColor() {
        return this.tabColor;
    }

    public void setTabColor(int tabColor) {
        this.tabColor = tabColor;
    }

    public void setTabSelectedColor(int tabColor) {
        this.tabSelectedColor = tabColor;
        this.mTabImg.setBackgroundColor(tabColor);
    }

    public int getTabTextSize() {
        return this.tabTextSize;
    }

    public void setTabTextSize(int tabTextSize) {
        this.tabTextSize = tabTextSize;
    }

    public void setTabPadding(int left, int top, int right, int bottom) {
        int i = 0;
        while (i < this.tabItemList.size()) {
            TextView tv = this.tabItemList.get(i);
            tv.setPadding(left, top, right, bottom);
            ++i;
        }
    }

    public int getTabSlidingHeight() {
        return this.tabSlidingHeight;
    }

    public void setTabSlidingHeight(int tabSlidingHeight) {
        this.tabSlidingHeight = tabSlidingHeight;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public class MyOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        public void onPageScrollStateChanged(int arg0) {
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
        }

        public void onPageSelected(int arg0) {
            AbSlidingSmoothFixTabView.this.computeTabImg(arg0);
        }
    }
}

