/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Scroller;
import com.ab.util.AbLogUtil;

public class AbSlidingMenuView
extends ViewGroup {
    private Scroller mScroller;
    private VelocityTracker mVelocityTracker;
    private int mWidth;
    public static final int SCREEN_STATE_CLOSE = 0;
    public static final int SCREEN_STATE_OPEN = 1;
    public static final int TOUCH_STATE_RESTART = 0;
    public static final int TOUCH_STATE_SCROLLING = 1;
    public static final int SCROLL_STATE_NO_ALLOW = 0;
    public static final int SCROLL_STATE_ALLOW = 1;
    private int mScreenState = 0;
    private int mTouchState = 0;
    private int mScrollState = 0;
    private int mVelocityValue = 0;
    private boolean mOnClick = false;

    public AbSlidingMenuView(Context context) {
        super(context);
        this.mScroller = new Scroller(context);
        this.mWidth = (int)TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public AbSlidingMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int i = 0;
        while (i < this.getChildCount()) {
            View child = this.getChildAt(i);
            int height = child.getMeasuredHeight();
            int width = child.getMeasuredWidth();
            child.layout(0, 0, width, height);
            ++i;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChildAt(i).measure(widthMeasureSpec, heightMeasureSpec);
            ++i;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.obtainVelocityTracker(ev);
        switch (ev.getAction()) {
            case 0: {
                AbLogUtil.d(AbSlidingMenuView.class, "--dispatchTouchEvent ACTION_DOWN--");
                int n = this.mTouchState = this.mScroller.isFinished() ? 0 : 1;
                if (this.mTouchState == 0) {
                    int x = (int)ev.getX();
                    int screenWidth = this.getWidth();
                    if (x <= this.mWidth && this.mScreenState == 0 && this.mTouchState == 0 || x >= screenWidth - this.mWidth && this.mScreenState == 1 && this.mTouchState == 0) {
                        if (this.mScreenState == 1) {
                            this.mOnClick = true;
                        }
                        this.mScrollState = 1;
                        break;
                    }
                    this.mOnClick = false;
                    this.mScrollState = 0;
                    break;
                }
                AbLogUtil.d(AbSlidingMenuView.class, "--dispatchTouchEvent ACTION_DOWN return false--");
                return false;
            }
            case 2: {
                AbLogUtil.d(AbSlidingMenuView.class, "--dispatchTouchEvent ACTION_MOVE--");
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)ViewConfiguration.getMaximumFlingVelocity());
                if (this.mScrollState != 1 || this.getWidth() - (int)ev.getX() >= this.mWidth) break;
                AbLogUtil.d(AbSlidingMenuView.class, "--dispatchTouchEvent ACTION_MOVE return true--");
                return true;
            }
            case 1: {
                this.releaseVelocityTracker();
                if (!this.mOnClick) break;
                this.mOnClick = false;
                this.mScreenState = 0;
                this.mScroller.startScroll(this.getChildAt(1).getScrollX(), 0, -this.getChildAt(1).getScrollX(), 0, 800);
                this.invalidate();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.obtainVelocityTracker(ev);
        switch (ev.getAction()) {
            case 0: {
                AbLogUtil.d(AbSlidingMenuView.class, "--onInterceptTouchEvent ACTION_DOWN--");
                int n = this.mTouchState = this.mScroller.isFinished() ? 0 : 1;
                if (this.mTouchState != 1) break;
                AbLogUtil.d(AbSlidingMenuView.class, "--onInterceptTouchEvent ACTION_DOWN return false--");
                return false;
            }
            case 2: {
                AbLogUtil.d(AbSlidingMenuView.class, "--onInterceptTouchEvent ACTION_MOVE--");
                this.mOnClick = false;
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)ViewConfiguration.getMaximumFlingVelocity());
                if (this.mScrollState != 1 || !(Math.abs(this.mVelocityTracker.getXVelocity()) > 200.0f)) break;
                AbLogUtil.d(AbSlidingMenuView.class, "--onInterceptTouchEvent ACTION_MOVE return true--");
                return true;
            }
            case 1: {
                this.releaseVelocityTracker();
                if (this.mScrollState != 1 || this.mScreenState != 1) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.obtainVelocityTracker(event);
        switch (event.getAction()) {
            case 0: {
                AbLogUtil.d(AbSlidingMenuView.class, "--onTouchEvent ACTION_DOWN--");
                int n = this.mTouchState = this.mScroller.isFinished() ? 0 : 1;
                if (this.mTouchState != 1) break;
                AbLogUtil.d(AbSlidingMenuView.class, "--onTouchEvent ACTION_DOWN return false--");
                return false;
            }
            case 2: {
                AbLogUtil.d(AbSlidingMenuView.class, "--onTouchEvent ACTION_MOVE--");
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)ViewConfiguration.getMaximumFlingVelocity());
                this.mVelocityValue = (int)this.mVelocityTracker.getXVelocity();
                this.getChildAt(1).scrollTo(-((int)event.getX()), 0);
                break;
            }
            case 1: {
                if (this.mScrollState != 1) break;
                if (this.mVelocityValue > 2000) {
                    this.mScreenState = 1;
                    this.mScroller.startScroll(this.getChildAt(1).getScrollX(), 0, -(this.getWidth() - Math.abs(this.getChildAt(1).getScrollX()) - this.mWidth), 0, 250);
                    this.invalidate();
                    break;
                }
                if (this.mVelocityValue < -2000) {
                    this.mScreenState = 0;
                    this.mScroller.startScroll(this.getChildAt(1).getScrollX(), 0, -this.getChildAt(1).getScrollX(), 0, 250);
                    this.invalidate();
                    break;
                }
                if (event.getX() < (float)(this.getWidth() / 2)) {
                    this.mScreenState = 0;
                    this.mScroller.startScroll(this.getChildAt(1).getScrollX(), 0, -this.getChildAt(1).getScrollX(), 0, 800);
                    this.invalidate();
                    break;
                }
                this.mScreenState = 1;
                this.mScroller.startScroll(this.getChildAt(1).getScrollX(), 0, -(this.getWidth() - Math.abs(this.getChildAt(1).getScrollX()) - this.mWidth), 0, 800);
                this.invalidate();
            }
        }
        return super.onTouchEvent(event);
    }

    public void open() {
        int n = this.mTouchState = this.mScroller.isFinished() ? 0 : 1;
        if (this.mTouchState == 0) {
            this.mScreenState = 1;
            this.mScroller.startScroll(this.getChildAt(1).getScrollX(), 0, -(this.getWidth() - Math.abs(this.getChildAt(1).getScrollX()) - this.mWidth), 0, 800);
            this.invalidate();
        }
    }

    public void close() {
        this.mScreenState = 0;
        this.mScroller.startScroll(this.getChildAt(1).getScrollX(), 0, -this.getChildAt(1).getScrollX(), 0, 800);
        this.invalidate();
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            this.getChildAt(1).scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.postInvalidate();
        }
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public int getScreenState() {
        return this.mScreenState;
    }

    public void setContentView(View view) {
        this.removeViewAt(1);
        this.addView(view, 1, this.getLayoutParams());
    }
}

