/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.sliding;

import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ab.adapter.AbFragmentPagerAdapter;
import com.ab.util.AbLogUtil;
import com.ab.view.sliding.AbTabItemView;
import java.util.ArrayList;
import java.util.List;

public class AbBottomTabView
extends LinearLayout {
    private Context context;
    private LinearLayout mTabLayout = null;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private ArrayList<TextView> tabItemList = null;
    private ArrayList<Fragment> pagerItemList = null;
    private List<String> tabItemTextList = null;
    private List<Drawable> tabItemDrawableList = null;
    private int mSelectedTabIndex = 0;
    private AbFragmentPagerAdapter mFragmentPagerAdapter = null;
    private int tabBackgroundResource = -1;
    private int tabTextSize = 30;
    private int tabTextColor = -16777216;
    private int tabSelectColor = -1;
    private View.OnClickListener mTabClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            AbTabItemView tabView = (AbTabItemView)view;
            AbBottomTabView.this.setCurrentItem(tabView.getIndex());
        }
    };

    public AbBottomTabView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.setOrientation(1);
        this.setBackgroundColor(Color.rgb((int)255, (int)255, (int)255));
        this.mTabLayout = new LinearLayout(context);
        this.mTabLayout.setOrientation(0);
        this.mTabLayout.setGravity(17);
        this.mViewPager = new ViewPager(context);
        this.mViewPager.setId(1985);
        this.pagerItemList = new ArrayList();
        this.addView((View)this.mViewPager, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        this.addView((View)this.mTabLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.tabItemList = new ArrayList();
        this.tabItemTextList = new ArrayList<String>();
        this.tabItemDrawableList = new ArrayList<Drawable>();
        if (!(this.context instanceof FragmentActivity)) {
            AbLogUtil.e(AbBottomTabView.class, "\u6784\u9020AbSlidingTabView\u7684\u53c2\u6570context,\u5fc5\u987b\u662fFragmentActivity\u7684\u5b9e\u4f8b\u3002");
        }
        FragmentManager mFragmentManager = ((FragmentActivity)this.context).getFragmentManager();
        this.mFragmentPagerAdapter = new AbFragmentPagerAdapter(mFragmentManager, this.pagerItemList);
        this.mViewPager.setAdapter((PagerAdapter)this.mFragmentPagerAdapter);
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new MyOnPageChangeListener());
        this.mViewPager.setOffscreenPageLimit(3);
    }

    public void setCurrentItem(int index) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mSelectedTabIndex = index;
        int tabCount = this.mTabLayout.getChildCount();
        int i = 0;
        while (i < tabCount) {
            AbTabItemView child = (AbTabItemView)this.mTabLayout.getChildAt(i);
            boolean isSelected = i == index;
            child.setSelected(isSelected);
            if (isSelected) {
                child.setTabTextColor(this.tabSelectColor);
                if (this.tabBackgroundResource != -1) {
                    child.setTabBackgroundResource(this.tabBackgroundResource);
                }
                if (this.tabItemDrawableList.size() >= tabCount * 2) {
                    child.setTabCompoundDrawables(null, this.tabItemDrawableList.get(index * 2 + 1), null, null);
                } else if (this.tabItemDrawableList.size() >= tabCount) {
                    child.setTabCompoundDrawables(null, this.tabItemDrawableList.get(index), null, null);
                }
                this.mViewPager.setCurrentItem(index);
            } else {
                if (this.tabBackgroundResource != -1) {
                    child.setBackgroundDrawable(null);
                }
                if (this.tabItemDrawableList.size() >= tabCount * 2) {
                    child.setTabCompoundDrawables(null, this.tabItemDrawableList.get(i * 2), null, null);
                }
                child.setTabTextColor(this.tabTextColor);
            }
            ++i;
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setTabBackgroundResource(int resid) {
        this.tabBackgroundResource = resid;
    }

    public void setTabLayoutBackgroundResource(int resid) {
        this.mTabLayout.setBackgroundResource(resid);
    }

    public int getTabTextSize() {
        return this.tabTextSize;
    }

    public void setTabTextSize(int tabTextSize) {
        this.tabTextSize = tabTextSize;
    }

    public void setTabTextColor(int tabColor) {
        this.tabTextColor = tabColor;
    }

    public void setTabSelectColor(int tabColor) {
        this.tabSelectColor = tabColor;
    }

    private void addTab(String text, int index) {
        this.addTab(text, index, null);
    }

    private void addTab(String text, int index, Drawable top) {
        AbTabItemView tabView = new AbTabItemView(this.context);
        if (top != null) {
            tabView.setTabCompoundDrawables(null, top, null, null);
        }
        tabView.setTabTextColor(this.tabTextColor);
        tabView.setTabTextSize(this.tabTextSize);
        tabView.init(index, text);
        this.tabItemList.add(tabView.getTextView());
        tabView.setOnClickListener(this.mTabClickListener);
        this.mTabLayout.addView((View)tabView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
    }

    public void notifyTabDataSetChanged() {
        this.mTabLayout.removeAllViews();
        this.tabItemList.clear();
        int count = this.mFragmentPagerAdapter.getCount();
        int i = 0;
        while (i < count) {
            if (this.tabItemDrawableList.size() >= count * 2) {
                this.addTab(this.tabItemTextList.get(i), i, this.tabItemDrawableList.get(i * 2));
            } else if (this.tabItemDrawableList.size() >= count) {
                this.addTab(this.tabItemTextList.get(i), i, this.tabItemDrawableList.get(i));
            } else {
                this.addTab(this.tabItemTextList.get(i), i);
            }
            ++i;
        }
        if (this.mSelectedTabIndex > count) {
            this.mSelectedTabIndex = count - 1;
        }
        this.setCurrentItem(this.mSelectedTabIndex);
        this.requestLayout();
    }

    public void addItemViews(List<String> tabTexts, List<Fragment> fragments) {
        this.tabItemTextList.addAll(tabTexts);
        this.pagerItemList.addAll(fragments);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void addItemViews(List<String> tabTexts, List<Fragment> fragments, List<Drawable> drawables) {
        this.tabItemTextList.addAll(tabTexts);
        this.pagerItemList.addAll(fragments);
        this.tabItemDrawableList.addAll(drawables);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void addItemView(String tabText, Fragment fragment) {
        this.tabItemTextList.add(tabText);
        this.pagerItemList.add(fragment);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void addItemView(String tabText, Fragment fragment, Drawable drawableNormal, Drawable drawablePressed) {
        this.tabItemTextList.add(tabText);
        this.pagerItemList.add(fragment);
        this.tabItemDrawableList.add(drawableNormal);
        this.tabItemDrawableList.add(drawablePressed);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void removeItemView(int index) {
        this.mTabLayout.removeViewAt(index);
        this.pagerItemList.remove(index);
        this.tabItemList.remove(index);
        this.tabItemDrawableList.remove(index);
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public void removeAllItemViews() {
        this.mTabLayout.removeAllViews();
        this.pagerItemList.clear();
        this.tabItemList.clear();
        this.tabItemDrawableList.clear();
        this.mFragmentPagerAdapter.notifyDataSetChanged();
        this.notifyTabDataSetChanged();
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setTabPadding(int left, int top, int right, int bottom) {
        int i = 0;
        while (i < this.tabItemList.size()) {
            TextView tv = this.tabItemList.get(i);
            tv.setPadding(left, top, right, bottom);
            ++i;
        }
    }

    public class MyOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        public void onPageScrollStateChanged(int arg0) {
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
        }

        public void onPageSelected(int arg0) {
            AbBottomTabView.this.setCurrentItem(arg0);
        }
    }
}

